/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskHistoryDropDownAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class TaskActivationHistoryTest
extends TestCase {
    private TaskActivationHistory history;
    private TaskList taskList;
    private AbstractTask task1;
    private AbstractTask task2;
    private AbstractTask task3;
    private AbstractTask task4;
    private AbstractTask task5;
    private ActivateTaskHistoryDropDownAction previousTaskAction;
    private TaskActivityManager taskActivityManager;

    protected void setUp() throws Exception {
        this.taskActivityManager = TasksUiPlugin.getTaskActivityManager();
        this.history = this.taskActivityManager.getTaskActivationHistory();
        this.taskList = TasksUiPlugin.getTaskList();
        this.taskActivityManager.deactivateActiveTask();
        this.taskActivityManager.clear();
        TaskTestUtil.resetTaskList();
        this.task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        this.taskList.addTask((ITask)this.task1);
        this.task2 = TasksUiInternal.createNewLocalTask((String)"task 2");
        this.taskList.addTask((ITask)this.task2);
        this.task3 = TasksUiInternal.createNewLocalTask((String)"task 3");
        this.taskList.addTask((ITask)this.task3);
        this.task4 = TasksUiInternal.createNewLocalTask((String)"task 4");
        this.taskList.addTask((ITask)this.task4);
        this.task5 = TasksUiInternal.createNewLocalTask((String)"task 5");
        this.taskList.addTask((ITask)this.task5);
        this.previousTaskAction = new ActivateTaskHistoryDropDownAction();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskList();
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(new HashSet(0));
    }

    public void testWithWorkingSet() {
        MockRepositoryQuery query1 = new MockRepositoryQuery("Query 1");
        MockRepositoryQuery query2 = new MockRepositoryQuery("Query 2");
        LocalTask task11 = TasksUiInternal.createNewLocalTask((String)"Query1 Task 1");
        LocalTask task12 = TasksUiInternal.createNewLocalTask((String)"Query1 Task 2");
        LocalTask task21 = TasksUiInternal.createNewLocalTask((String)"Query2 Task 1");
        LocalTask task22 = TasksUiInternal.createNewLocalTask((String)"Query2 Task 2");
        this.taskList.addQuery((RepositoryQuery)query1);
        this.taskList.addQuery((RepositoryQuery)query2);
        this.createWorkingSet((IAdaptable)query1);
        TasksUi.getTaskActivityManager().activateTask((ITask)task11);
        this.history.addTask((AbstractTask)task11);
        this.taskList.addTask((ITask)task11, (AbstractTaskContainer)query1);
        TasksUi.getTaskActivityManager().activateTask((ITask)task12);
        this.history.addTask((AbstractTask)task12);
        this.taskList.addTask((ITask)task12, (AbstractTaskContainer)query1);
        TasksUi.getTaskActivityManager().activateTask((ITask)task21);
        this.history.addTask((AbstractTask)task21);
        this.taskList.addTask((ITask)task21, (AbstractTaskContainer)query2);
        TasksUi.getTaskActivityManager().activateTask((ITask)task22);
        this.history.addTask((AbstractTask)task22);
        this.taskList.addTask((ITask)task22, (AbstractTaskContainer)query2);
        List prevHistoryList = this.history.getPreviousTasks();
        TaskActivationHistoryTest.assertTrue((prevHistoryList.size() >= 3 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 1) == task22 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 2) == task21 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 3) == task12 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 4) == task11 ? 1 : 0) != 0);
        prevHistoryList = this.history.getPreviousTasks(TasksUiInternal.getContainersFromWorkingSet((Set)TaskWorkingSetUpdater.getActiveWorkingSets((IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow())));
        TaskActivationHistoryTest.assertTrue((prevHistoryList.size() >= 2 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 1) == task12 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 2) == task11 ? 1 : 0) != 0);
        prevHistoryList = this.history.getPreviousTasks(new HashSet());
        TaskActivationHistoryTest.assertTrue((prevHistoryList.size() >= 3 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 1) == task22 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 2) == task21 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 3) == task12 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertTrue((prevHistoryList.get(prevHistoryList.size() - 4) == task11 ? 1 : 0) != 0);
    }

    private IWorkingSet createWorkingSet(IAdaptable element) {
        IWorkingSetManager workingSetManager1 = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager1.createWorkingSet("Task Working Set", new IAdaptable[]{element});
        workingSet.setId(TaskWorkingSetUpdater.ID_TASK_WORKING_SET);
        TaskActivationHistoryTest.assertTrue((boolean)Arrays.asList(workingSet.getElements()).contains(element));
        Set sets = TaskWorkingSetUpdater.getActiveWorkingSets((IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        sets.add(workingSet);
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows((Collection)sets);
        return workingSet;
    }

    public void testBasicHistoryNavigation() {
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task1);
        this.history.addTask(this.task1);
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task2);
        this.history.addTask(this.task2);
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task3);
        this.history.addTask(this.task3);
        TaskActivationHistoryTest.assertTrue((boolean)this.task3.isActive());
        TaskActivationHistoryTest.assertFalse((boolean)this.task2.isActive());
        TaskActivationHistoryTest.assertFalse((boolean)this.task1.isActive());
        this.previousTaskAction.run();
        TaskActivationHistoryTest.assertEquals((Object)this.task2, (Object)this.taskActivityManager.getActiveTask());
        TaskActivationHistoryTest.assertTrue((boolean)this.task2.isActive());
        this.previousTaskAction.run();
        TaskActivationHistoryTest.assertEquals((Object)this.task1, (Object)this.taskActivityManager.getActiveTask());
        TaskActivationHistoryTest.assertTrue((boolean)this.task1.isActive());
        this.previousTaskAction.run();
        TaskActivationHistoryTest.assertEquals((Object)this.task1, (Object)this.taskActivityManager.getActiveTask());
        TaskActivationHistoryTest.assertTrue((boolean)this.task1.isActive());
    }

    public void testArbitraryHistoryNavigation() {
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task1);
        this.history.addTask(this.task1);
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task2);
        this.history.addTask(this.task2);
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task3);
        this.history.addTask(this.task3);
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task4);
        this.history.addTask(this.task4);
        TaskActivationHistoryTest.assertTrue((boolean)this.task4.isActive());
        List prevHistoryList = this.history.getPreviousTasks();
        TaskActivationHistoryTest.assertTrue((prevHistoryList.size() >= 3 ? 1 : 0) != 0);
        TaskActivationHistoryTest.assertEquals((Object)this.task3, prevHistoryList.get(prevHistoryList.size() - 2));
        TaskActivationHistoryTest.assertEquals((Object)this.task2, prevHistoryList.get(prevHistoryList.size() - 3));
        TaskActivationHistoryTest.assertEquals((Object)this.task1, prevHistoryList.get(prevHistoryList.size() - 4));
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task2);
        TaskActivationHistoryTest.assertEquals((Object)this.task2, (Object)this.taskActivityManager.getActiveTask());
        TaskActivationHistoryTest.assertTrue((boolean)this.task2.isActive());
        prevHistoryList = this.history.getPreviousTasks();
        TaskActivationHistoryTest.assertEquals((Object)this.task2, prevHistoryList.get(prevHistoryList.size() - 1));
        TaskActivationHistoryTest.assertEquals((Object)this.task4, prevHistoryList.get(prevHistoryList.size() - 2));
        TaskActivationHistoryTest.assertEquals((Object)this.task1, prevHistoryList.get(prevHistoryList.size() - 4));
        TaskActivationHistoryTest.assertEquals((Object)this.task3, prevHistoryList.get(prevHistoryList.size() - 3));
        this.history.addTask(this.task3);
        prevHistoryList = this.history.getPreviousTasks();
        TaskActivationHistoryTest.assertEquals((Object)this.task3, prevHistoryList.get(prevHistoryList.size() - 1));
        TaskActivationHistoryTest.assertEquals((Object)this.task2, prevHistoryList.get(prevHistoryList.size() - 2));
        TaskActivationHistoryTest.assertEquals((Object)this.task4, prevHistoryList.get(prevHistoryList.size() - 3));
        TaskActivationHistoryTest.assertEquals((Object)this.task1, prevHistoryList.get(prevHistoryList.size() - 4));
        TasksUi.getTaskActivityManager().activateTask((ITask)this.task4);
        TaskActivationHistoryTest.assertEquals((Object)this.task4, (Object)this.taskActivityManager.getActiveTask());
        TaskActivationHistoryTest.assertTrue((boolean)this.task4.isActive());
        prevHistoryList = this.history.getPreviousTasks();
        TaskActivationHistoryTest.assertEquals((Object)this.task4, prevHistoryList.get(prevHistoryList.size() - 1));
        TaskActivationHistoryTest.assertEquals((Object)this.task3, prevHistoryList.get(prevHistoryList.size() - 2));
        TaskActivationHistoryTest.assertEquals((Object)this.task2, prevHistoryList.get(prevHistoryList.size() - 3));
        TaskActivationHistoryTest.assertEquals((Object)this.task1, prevHistoryList.get(prevHistoryList.size() - 4));
        this.previousTaskAction.run();
        TaskActivationHistoryTest.assertEquals((Object)this.task3, (Object)this.taskActivityManager.getActiveTask());
        TaskActivationHistoryTest.assertTrue((boolean)this.task3.isActive());
        prevHistoryList = this.history.getPreviousTasks();
        TaskActivationHistoryTest.assertEquals((Object)this.task3, prevHistoryList.get(prevHistoryList.size() - 1));
        TaskActivationHistoryTest.assertEquals((Object)this.task4, prevHistoryList.get(prevHistoryList.size() - 2));
        TaskActivationHistoryTest.assertEquals((Object)this.task2, prevHistoryList.get(prevHistoryList.size() - 3));
        TaskActivationHistoryTest.assertEquals((Object)this.task1, prevHistoryList.get(prevHistoryList.size() - 4));
        TasksUi.getTaskActivityManager().deactivateTask((ITask)this.task3);
    }
}

