/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.util;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.model.ResourceBundleManager;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleUtil {
    public static ResourceBundleModel findByName(IJavaProject iJavaProject, String string) throws JavaModelException, IOException, CoreException {
        return ResourceBundleUtil.findByName(iJavaProject, string, false);
    }

    /*
     * WARNING - void declaration
     */
    public static ResourceBundleModel findByName(IJavaProject iJavaProject, String string, boolean bl) throws JavaModelException, IOException, CoreException {
        IProject iProject;
        IProject[] iProjectArray2;
        void object2;
        LinkedList<ResourceBundleModel> linkedList = new LinkedList<ResourceBundleModel>();
        String string2 = Signature.getQualifier((String)string);
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        LinkedList<IProject[]> linkedList2 = new LinkedList<IProject[]>();
        boolean n = false;
        while (object2 < iPackageFragmentRootArray.length) {
            if (iPackageFragmentRootArray[object2].getKind() == 1 && (iProjectArray2 = iPackageFragmentRootArray[object2].getPackageFragment(string2)) != null && iProjectArray2.exists()) {
                linkedList2.add(iProjectArray2);
            }
            ++object2;
        }
        for (IProject[] iProjectArray2 : linkedList2) {
            Object[] objectArray = iProjectArray2.isDefaultPackage() ? ((IPackageFragmentRoot)iProjectArray2.getParent()).getNonJavaResources() : iProjectArray2.getNonJavaResources();
            ResourceBundleUtil.findAndAddResourceBundles(objectArray, linkedList);
        }
        for (ResourceBundleModel resourceBundleModel : linkedList) {
            if (!string.equals(resourceBundleModel.getFullyQualifiedName(false))) continue;
            return resourceBundleModel;
        }
        if (bl && (iProject = iJavaProject.getProject()).exists()) {
            iProjectArray2 = iProject.getReferencedProjects();
            int n2 = 0;
            while (n2 < iProjectArray2.length) {
                ResourceBundleModel resourceBundleModel;
                IJavaProject iJavaProject2 = JavaCore.create((IProject)iProjectArray2[n2]);
                if (iJavaProject2 != null && iJavaProject2.exists() && iJavaProject2.isOpen() && (resourceBundleModel = ResourceBundleUtil.findByName(iJavaProject2, string, false)) != null) {
                    return resourceBundleModel;
                }
                ++n2;
            }
        }
        return null;
    }

    public static List<ResourceBundleModel> searchForResourceBundles() {
        LinkedList<ResourceBundleModel> linkedList = new LinkedList<ResourceBundleModel>();
        try {
            IJavaProject[] iJavaProjectArray = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            int n = 0;
            while (n < iJavaProjectArray.length) {
                linkedList.addAll(ResourceBundleUtil.searchForResourceBundles(iJavaProjectArray[n]));
                ++n;
            }
        }
        catch (Exception exception) {
            Status status = new Status(4, JIntoCore.getID(), 4, "Unexpected error in resource search!", (Throwable)exception);
            JIntoCore.getDefault().getLog().log((IStatus)status);
        }
        return linkedList;
    }

    public static List<ResourceBundleModel> searchForResourceBundles(IJavaProject iJavaProject) {
        LinkedList<ResourceBundleModel> linkedList = new LinkedList<ResourceBundleModel>();
        try {
            List<IPackageFragmentRoot> list = ResourceBundleUtil.getPackageFragmentRoots(iJavaProject, linkedList);
            Iterator<IPackageFragmentRoot> iterator = list.iterator();
            while (iterator.hasNext()) {
                List<IJavaElement> list2 = ResourceBundleUtil.getPackageFragments(iterator.next());
                Iterator<IJavaElement> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    ResourceBundleUtil.findAndAddResourceBundles(((IPackageFragment)iterator2.next()).getNonJavaResources(), linkedList);
                }
            }
        }
        catch (Exception exception) {
            Status status = new Status(4, JIntoCore.getID(), 4, "Unexpected error in resource search!", (Throwable)exception);
            JIntoCore.getDefault().getLog().log((IStatus)status);
        }
        return linkedList;
    }

    private static List<IPackageFragmentRoot> getPackageFragmentRoots(IJavaProject iJavaProject, List<ResourceBundleModel> list) throws JavaModelException, IOException, CoreException {
        LinkedList<IPackageFragmentRoot> linkedList = new LinkedList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            if (iPackageFragmentRootArray[n].exists() && iPackageFragmentRootArray[n].getKind() == 1) {
                ResourceBundleUtil.findAndAddResourceBundles(iPackageFragmentRootArray[n].getNonJavaResources(), list);
                linkedList.add(iPackageFragmentRootArray[n]);
            }
            ++n;
        }
        return linkedList;
    }

    private static List<IJavaElement> getPackageFragments(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        LinkedList<IJavaElement> linkedList = new LinkedList<IJavaElement>();
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (iJavaElementArray[n].getElementType() == 4) {
                linkedList.add(iJavaElementArray[n]);
            }
            ++n;
        }
        return linkedList;
    }

    private static void findAndAddResourceBundles(Object[] objectArray, List<ResourceBundleModel> list) throws IOException, CoreException {
        int n = 0;
        while (n < objectArray.length) {
            ResourceBundleModel resourceBundleModel;
            IFile iFile;
            IResource iResource;
            if (objectArray[n] instanceof IAdaptable && (iResource = (IResource)((IAdaptable)objectArray[n]).getAdapter(IResource.class)).getType() == 1 && "properties".equals((iFile = (IFile)objectArray[n]).getFileExtension()) && (resourceBundleModel = ResourceBundleManager.createForFile((IStorage)iFile, false)) != null && !list.contains(resourceBundleModel)) {
                list.add(resourceBundleModel);
            }
            ++n;
        }
    }
}

