/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.model;

import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;

public class ResourceBundleManager {
    private static final List<ResourceBundleModel> MODELS = new LinkedList<ResourceBundleModel>();

    public static ResourceBundleModel createForFile(IStorage iStorage, boolean bl) throws IOException, CoreException {
        ResourceBundleModel resourceBundleModel = null;
        if (ResourceBundleManager.hasValidExtension(iStorage)) {
            resourceBundleModel = ResourceBundleManager.contentsAllreadyCreatedModel(iStorage);
            if (resourceBundleModel == null) {
                resourceBundleModel = new ResourceBundleModel(ResourceBundleManager.getLeadingFilename(iStorage), iStorage, bl);
                if (iStorage instanceof IFile) {
                    IResource[] iResourceArray = ((IFile)iStorage).getParent().members();
                    int n = 0;
                    while (n < iResourceArray.length) {
                        ResourceFile resourceFile;
                        if (iResourceArray[n].getType() == 1 && (resourceFile = ResourceBundleManager.checkAndGetMatchingFile(resourceBundleModel.getName(), (IStorage)((IFile)iResourceArray[n]))) != null) {
                            resourceBundleModel.addResourceFile(resourceFile);
                        }
                        ++n;
                    }
                } else {
                    ResourceFile resourceFile = ResourceBundleManager.checkAndGetMatchingFile(resourceBundleModel.getName(), iStorage);
                    if (resourceFile != null) {
                        resourceBundleModel.addResourceFile(resourceFile);
                    }
                }
                MODELS.add(resourceBundleModel);
            } else if (bl) {
                resourceBundleModel.load();
            }
        }
        return resourceBundleModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceFile checkAndGetMatchingFile(String string, IStorage iStorage) {
        if (iStorage == null || iStorage.getFullPath() == null || !ResourceBundleManager.hasValidExtension(iStorage) || !iStorage.getName().startsWith(string)) return null;
        String string2 = iStorage.getName();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object[] objectArray = ResourceBundleManager.getNextID(string2, string.length());
        string3 = (String)objectArray[0];
        if (string3 != null) {
            if (string3.length() <= 0 || Arrays.binarySearch(Locale.getISOLanguages(), string3) < 0) return null;
            int n = (Integer)objectArray[1];
            if (n != -1) {
                objectArray = ResourceBundleManager.getNextID(string2, n);
                string4 = (String)objectArray[0];
                if (string4 == null) {
                    string4 = "";
                }
                if (string4.length() > 0 && Arrays.binarySearch(Locale.getISOCountries(), string4) == -1) {
                    return null;
                }
                n = (Integer)objectArray[1];
                if (n != -1 && (string5 = (String)(objectArray = ResourceBundleManager.getNextID(string2, n))[0]) != null && (Integer)objectArray[1] != -1) {
                    return null;
                }
                if (string5 == null) {
                    string5 = "";
                }
                if (string5.length() > 0 && string3.length() == 0 && string4.length() == 0) {
                    return null;
                }
            }
        } else if (!string2.substring(string.length()).equals(".properties")) {
            return null;
        }
        Locale locale = null;
        if (string3 == null) return new ResourceFile(iStorage, locale);
        locale = new Locale(string3, string4 == null ? "" : string4, string5 == null ? "" : string5);
        return new ResourceFile(iStorage, locale);
    }

    public static String getLeadingFilename(IStorage iStorage) {
        String string = iStorage.getName();
        String[] stringArray = (string = string.substring(0, string.lastIndexOf("."))).split("_");
        int n = stringArray.length;
        if (n >= 2) {
            if (Arrays.binarySearch(Locale.getISOCountries(), stringArray[stringArray.length - 1]) >= 0) {
                n = stringArray.length - 2;
            } else if (Arrays.binarySearch(Locale.getISOLanguages(), stringArray[stringArray.length - 1]) >= 0) {
                n = stringArray.length - 1;
            } else if (Arrays.binarySearch(Locale.getISOCountries(), stringArray[stringArray.length - 2]) >= 0) {
                n = stringArray.length - 3;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(stringArray[n2]);
            if (n2 < n - 1) {
                stringBuffer.append("_");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static Object[] getNextID(String string, int n) {
        int n2 = string.indexOf("_", n);
        if (n2 != -1) {
            int n3 = string.indexOf("_", n2 + 1);
            boolean bl = true;
            if (n3 == -1) {
                n3 = string.indexOf(".", n2 + 1);
                bl = false;
            }
            if (n3 != -1) {
                return new Object[]{string.substring(n2 + 1, n3), bl ? new Integer(n3) : new Integer(-1)};
            }
        }
        Object[] objectArray = new Object[2];
        objectArray[1] = new Integer(-1);
        return objectArray;
    }

    private static ResourceBundleModel contentsAllreadyCreatedModel(IStorage iStorage) {
        int n = 0;
        while (n < MODELS.size()) {
            ResourceBundleModel resourceBundleModel = MODELS.get(n);
            if (resourceBundleModel.contains(iStorage)) {
                return resourceBundleModel;
            }
            ++n;
        }
        return null;
    }

    private static boolean hasValidExtension(IStorage iStorage) {
        String string = null;
        String string2 = iStorage.getName();
        if (string2 != null) {
            int n = string2.lastIndexOf(46);
            string = n != -1 ? string2.substring(n + 1) : iStorage.getFullPath().getFileExtension();
            return "properties".equals(string);
        }
        return false;
    }
}

