/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.model;

import de.guhsoft.jinto.core.Messages;
import de.guhsoft.jinto.core.model.AbstractResourceBundleOperation;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceRow;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RemoveRowOperation
extends AbstractResourceBundleOperation {
    private Map<String, ResourceRow> fMap = new HashMap<String, ResourceRow>();

    public RemoveRowOperation(ResourceBundleModel resourceBundleModel, String string) {
        this(resourceBundleModel, new String[]{string});
    }

    public RemoveRowOperation(ResourceBundleModel resourceBundleModel, String[] stringArray) {
        super(resourceBundleModel, Messages.getString("operations.removeRow.label", new Object[0]));
        int n = 0;
        while (n < stringArray.length) {
            this.fMap.put(stringArray[n], null);
            ++n;
        }
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        for (String string : this.fMap.keySet()) {
            this.fMap.put(string, this.getModel().removeRow(string));
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return this.execute(iProgressMonitor, iAdaptable);
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        for (Map.Entry<String, ResourceRow> entry : this.fMap.entrySet()) {
            ResourceRow resourceRow = entry.getValue();
            if (resourceRow == null) {
                String string = Messages.getString("operations.removeRow.error", new Object[0]);
                return new Status(4, null, string, new Throwable("ResourceRow object was null."));
            }
            this.getModel().addRow(entry.getKey(), resourceRow);
        }
        return Status.OK_STATUS;
    }
}

