/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CharsetInputStream
extends InputStream {
    private InputStreamReader fReader;
    private byte[] fInByteBuf;
    int fInOff;

    public CharsetInputStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(new InputStreamReader(inputStream, string));
    }

    public CharsetInputStream(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public CharsetInputStream(InputStream inputStream, CharsetDecoder charsetDecoder) {
        this(new InputStreamReader(inputStream, charsetDecoder));
    }

    private CharsetInputStream(InputStreamReader inputStreamReader) {
        this.fReader = inputStreamReader;
        this.fInOff = -1;
    }

    public int read() throws IOException {
        if (this.fInOff == -1 || this.fInOff >= this.fInByteBuf.length) {
            char[] cArray = new char[8192];
            int n = 0;
            int n2 = this.fReader.read(cArray);
            if (this.fInOff == -1 && cArray[0] == '\ufeff') {
                n = 1;
            }
            if (n2 == -1) {
                return -1;
            }
            this.fInByteBuf = this.escape(cArray, n, n2);
            this.fInOff = 0;
        }
        return this.fInByteBuf[this.fInOff++];
    }

    private byte[] escape(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = n;
        while (n3 < n2) {
            switch (cArray[n3]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    stringBuffer.append(cArray[n3]);
                    break;
                }
                default: {
                    if (cArray[n3] < ' ' || cArray[n3] > '~') {
                        stringBuffer.append("\\u");
                        String string = Integer.toHexString(cArray[n3]);
                        int n4 = 4 - string.length();
                        while (n4 > 0) {
                            stringBuffer.append('0');
                            --n4;
                        }
                        stringBuffer.append(string);
                        break;
                    }
                    stringBuffer.append(cArray[n3]);
                }
            }
            ++n3;
        }
        return stringBuffer.toString().getBytes();
    }

    public void close() throws IOException {
        this.fReader.close();
    }
}

