/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration.accessor;

import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleReference
implements Cloneable {
    private List<ClassReference> fAccessorClasses;
    private String fFullyQualifiedName;

    public ResourceBundleReference(ResourceBundleModel resourceBundleModel) {
        this(resourceBundleModel != null ? resourceBundleModel.getFullyQualifiedName(false) : null);
    }

    protected ResourceBundleReference(String string) {
        this.fFullyQualifiedName = string;
        this.fAccessorClasses = Collections.emptyList();
    }

    public String getFullyQualifiedName() {
        return this.fFullyQualifiedName;
    }

    public void setAccessorClasses(List<ClassReference> list) {
        this.fAccessorClasses = list;
    }

    public List<ClassReference> getAccessorClasses() {
        return this.fAccessorClasses;
    }

    protected ResourceBundleReference clone() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"clone");
        this.writeMemento((IMemento)xMLMemento);
        return ResourceBundleReference.readMemento((IMemento)xMLMemento);
    }

    protected void writeMemento(IMemento iMemento) {
        iMemento.putString("resourceBundleName", this.fFullyQualifiedName);
        if (this.fAccessorClasses != null) {
            for (ClassReference classReference : this.fAccessorClasses) {
                classReference.writeMemento(iMemento.createChild("accessor"));
            }
        }
    }

    protected static ResourceBundleReference readMemento(IMemento iMemento) {
        String string = iMemento.getString("resourceBundleName");
        ResourceBundleReference resourceBundleReference = new ResourceBundleReference(string);
        IMemento[] iMementoArray = iMemento.getChildren("accessor");
        LinkedList<ClassReference> linkedList = new LinkedList<ClassReference>();
        int n = 0;
        while (n < iMementoArray.length) {
            ClassReference classReference = ClassReference.readMemento(resourceBundleReference, iMementoArray[n]);
            if (classReference == null) {
                return null;
            }
            linkedList.add(classReference);
            ++n;
        }
        resourceBundleReference.setAccessorClasses(linkedList);
        return resourceBundleReference;
    }
}

