/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration.accessor;

import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReference {
    private ResourceBundleReference fParent;
    private String fFullyQualifiedTypeName;
    private List<MethodReference> fMethodReferences;

    public ClassReference(ResourceBundleReference resourceBundleReference, IType iType) {
        this(resourceBundleReference, iType != null ? iType.getFullyQualifiedName('.') : null);
    }

    protected ClassReference(ResourceBundleReference resourceBundleReference, String string) {
        this.fParent = resourceBundleReference;
        this.fFullyQualifiedTypeName = string;
        this.fMethodReferences = new LinkedList<MethodReference>();
    }

    public ResourceBundleReference getResourceBundleReference() {
        return this.fParent;
    }

    public String getFullyQualifiedTypeName() {
        return this.fFullyQualifiedTypeName;
    }

    public List<MethodReference> getMethodReferences() {
        return this.fMethodReferences;
    }

    public void setMethodReferences(List<MethodReference> list) {
        this.fMethodReferences = list;
    }

    public void writeMemento(IMemento iMemento) {
        iMemento.putString("typeName", this.fFullyQualifiedTypeName);
        for (MethodReference methodReference : this.fMethodReferences) {
            methodReference.writeMemento(iMemento.createChild("methodReference"));
        }
    }

    protected static ClassReference readMemento(ResourceBundleReference resourceBundleReference, IMemento iMemento) {
        String string = iMemento.getString("typeName");
        ClassReference classReference = new ClassReference(resourceBundleReference, string);
        IMemento[] iMementoArray = iMemento.getChildren("methodReference");
        LinkedList<MethodReference> linkedList = new LinkedList<MethodReference>();
        int n = 0;
        while (n < iMementoArray.length) {
            MethodReference methodReference = MethodReference.readMemento(classReference, iMementoArray[n]);
            if (methodReference != null) {
                linkedList.add(methodReference);
            }
            ++n;
        }
        classReference.setMethodReferences(linkedList);
        return classReference;
    }
}

