/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration.accessor;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.Messages;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.util.ParameterTypeConverter;
import de.guhsoft.jinto.core.util.ResourceBundleUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorConfiguration {
    private static final String PREFERENCE_KEY = String.valueOf(JIntoCore.getID()) + ".accessorConfiguration";
    private IJavaProject fProject;
    private ScopedPreferenceStore fPreferenceStore;
    private List<ResourceBundleReference> fResourceBundleReferences;

    protected AccessorConfiguration(IJavaProject iJavaProject) {
        this.fProject = iJavaProject;
        this.fPreferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(iJavaProject.getProject()), JIntoCore.getID());
    }

    protected void load() throws CoreException {
        this.fResourceBundleReferences = new LinkedList<ResourceBundleReference>();
        String string = this.fPreferenceStore.getString(PREFERENCE_KEY);
        if (string != null && string.length() > 0) {
            StringReader stringReader = new StringReader(string);
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)stringReader);
            IMemento[] iMementoArray = xMLMemento.getChildren("resourceBundleReference");
            int n = 0;
            while (n < iMementoArray.length) {
                ResourceBundleReference resourceBundleReference = ResourceBundleReference.readMemento(iMementoArray[n]);
                if (resourceBundleReference == null) {
                    throw new CoreException((IStatus)new Status(4, JIntoCore.getID(), "Error while loading AccessorConfiguration. The configuration file was corrupted."));
                }
                this.fResourceBundleReferences.add(resourceBundleReference);
                ++n;
            }
        }
    }

    protected void save(List<ResourceBundleReference> list) throws IOException {
        this.fResourceBundleReferences = list;
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"root");
        for (ResourceBundleReference object2 : this.fResourceBundleReferences) {
            object2.writeMemento(xMLMemento.createChild("resourceBundleReference"));
        }
        StringWriter stringWriter = new StringWriter();
        xMLMemento.save((Writer)stringWriter);
        this.fPreferenceStore.setValue(PREFERENCE_KEY, stringWriter.toString());
        this.fPreferenceStore.save();
    }

    public List<ResourceBundleReference> getResourceBundleReferences() {
        return this.getResourceBundleReferences(false);
    }

    public List<ResourceBundleReference> getResourceBundleReferences(boolean bl) {
        if (bl) {
            LinkedList<ResourceBundleReference> linkedList = new LinkedList<ResourceBundleReference>();
            for (ResourceBundleReference resourceBundleReference : this.fResourceBundleReferences) {
                linkedList.add(resourceBundleReference.clone());
            }
            return linkedList;
        }
        return this.fResourceBundleReferences;
    }

    public ResourceBundleModel resolve(ResourceBundleReference resourceBundleReference) throws JavaModelException, IOException, CoreException {
        if (resourceBundleReference != null) {
            return ResourceBundleUtil.findByName(this.fProject, resourceBundleReference.getFullyQualifiedName());
        }
        return null;
    }

    public IType resolve(ClassReference classReference) throws JavaModelException {
        if (classReference != null) {
            return this.fProject.findType(classReference.getFullyQualifiedTypeName());
        }
        return null;
    }

    public IMethod resolve(MethodReference methodReference) throws JavaModelException {
        IType iType;
        ClassReference classReference;
        if (methodReference != null && (classReference = methodReference.getClassReference()) != null && (iType = this.resolve(classReference)) != null) {
            IMethod[] iMethodArray = iType.getMethods();
            int n = 0;
            while (n < iMethodArray.length) {
                if (methodReference.getMethodName().equals(iMethodArray[n].getElementName())) {
                    String[] stringArray = ParameterTypeConverter.getEncodedParameterTypes(iMethodArray[n]);
                    int n2 = methodReference.getParameterCount();
                    if (n2 == stringArray.length) {
                        boolean bl = true;
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            String string = methodReference.getParameter(n3).getFullyQualifiedParameterType();
                            if (!ParameterTypeConverter.encodeQualifiedString(string, iMethodArray[n]).equals(stringArray[n3])) {
                                bl = false;
                                break;
                            }
                            ++n3;
                        }
                        if (bl && iMethodArray[n].exists()) {
                            return iMethodArray[n];
                        }
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public IStatus validate(ResourceBundleReference resourceBundleReference) {
        try {
            if (this.resolve(resourceBundleReference) == null) {
                return this.createError(Messages.getString("configuration.error.bundle.notExists", new Object[0]));
            }
            List<ClassReference> list = resourceBundleReference.getAccessorClasses();
            if (list == null || list.isEmpty()) {
                return this.createWarning(Messages.getString("configuration.error.bundle.noAccessors", new Object[0]));
            }
        }
        catch (JavaModelException javaModelException) {
            return this.createError(Messages.getString("configuration.error.bundle.notExists", new Object[]{javaModelException}));
        }
        catch (IOException iOException) {
            return this.createError(Messages.getString("configuration.error.bundle.notExists", iOException));
        }
        catch (CoreException coreException) {
            return this.createError(Messages.getString("configuration.error.bundle.notExists", new Object[]{coreException}));
        }
        return Status.OK_STATUS;
    }

    public IStatus validate(ClassReference classReference) {
        try {
            if (this.resolve(classReference) == null) {
                return this.createError(Messages.getString("configuration.error.accessor.notExists", new Object[0]));
            }
            List<MethodReference> list = classReference.getMethodReferences();
            if (list == null || list.isEmpty()) {
                return this.createWarning(Messages.getString("configuration.error.accessor.noMethods", new Object[0]));
            }
        }
        catch (JavaModelException javaModelException) {
            return this.createError(Messages.getString("configuration.error.accessor.notExists", new Object[0]), javaModelException);
        }
        return Status.OK_STATUS;
    }

    public IStatus validate(MethodReference methodReference) {
        try {
            if (this.resolve(methodReference) == null) {
                IType iType;
                ClassReference classReference = methodReference.getClassReference();
                if (classReference != null && (iType = this.resolve(classReference)) != null) {
                    String string = methodReference.getMethodName();
                    IMethod[] iMethodArray = iType.getMethods();
                    if (iMethodArray != null) {
                        int n = 0;
                        while (n < iMethodArray.length) {
                            if (iMethodArray[n].getElementName().equals(string)) {
                                return this.createError(Messages.getString("configuration.error.accessor.method.invalidParameter", new Object[0]));
                            }
                            ++n;
                        }
                    }
                }
                return this.createError(Messages.getString("configuration.error.accessor.method.notExists", new Object[0]));
            }
        }
        catch (JavaModelException javaModelException) {
            return this.createError(Messages.getString("configuration.error.accessor.method.notExists", new Object[0]), javaModelException);
        }
        return Status.OK_STATUS;
    }

    public IStatus validate(ResourceBundleReference resourceBundleReference, boolean bl) {
        IStatus iStatus = this.validate(resourceBundleReference);
        if (bl) {
            MultiStatus multiStatus = new MultiStatus(JIntoCore.getID(), 0, Messages.getString("configuration.error.multi", new Object[0]), null);
            multiStatus.add(iStatus);
            if (resourceBundleReference != null) {
                for (ClassReference classReference : resourceBundleReference.getAccessorClasses()) {
                    multiStatus.add(this.validate(classReference));
                    if (classReference == null) continue;
                    for (MethodReference methodReference : classReference.getMethodReferences()) {
                        multiStatus.add(this.validate(methodReference));
                    }
                }
            }
            iStatus = multiStatus;
        }
        return iStatus;
    }

    public IStatus validate() {
        MultiStatus multiStatus = new MultiStatus(JIntoCore.getID(), 0, Messages.getString("configuration.error.multi", new Object[0]), null);
        for (ResourceBundleReference resourceBundleReference : this.fResourceBundleReferences) {
            multiStatus.add(this.validate(resourceBundleReference, true));
        }
        return multiStatus;
    }

    private IStatus createError(String string) {
        return this.createError(string, null);
    }

    private IStatus createError(String string, Throwable throwable) {
        return this.createStatus(4, string, throwable);
    }

    private IStatus createWarning(String string) {
        return this.createError(string, null);
    }

    private IStatus createStatus(int n, String string, Throwable throwable) {
        return new Status(n, JIntoCore.getID(), string, throwable);
    }
}

