/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration;

import de.guhsoft.jinto.core.configuration.AccessorConfigurationProblemJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class AccessorConfigurationMonitor
implements IResourceChangeListener {
    private static AccessorConfigurationMonitor INSTANCE;
    private static final int EVENT_MASK = 25;

    public static void startup() {
        INSTANCE = new AccessorConfigurationMonitor();
    }

    public static void shutdown() {
        INSTANCE.dispose();
    }

    private AccessorConfigurationMonitor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 25);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        switch (iResourceChangeEvent.getType()) {
            case 8: {
                if (iResourceChangeEvent.getBuildKind() != 15) break;
                Object object = iResourceChangeEvent.getSource();
                if (object instanceof IProject) {
                    AccessorConfigurationProblemJob.cleanMarkers((IProject)object);
                    break;
                }
                if (!(object instanceof IWorkspace)) break;
                IProject[] iProjectArray = ((IWorkspace)object).getRoot().getProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    if (iProjectArray[n] != null && iProjectArray[n].exists() && iProjectArray[n].isOpen()) {
                        AccessorConfigurationProblemJob.cleanMarkers(iProjectArray[n]);
                    }
                    ++n;
                }
                break;
            }
            case 16: {
                IJavaProject iJavaProject;
                if (iResourceChangeEvent.getBuildKind() != 15 || (iJavaProject = this.resolveAffectedProject(iResourceChangeEvent)) == null) break;
                new AccessorConfigurationProblemJob(iJavaProject).schedule();
                break;
            }
            case 1: {
                IJavaProject iJavaProject = this.resolveAffectedProject(iResourceChangeEvent);
                if (iJavaProject == null) break;
                new AccessorConfigurationProblemJob(iJavaProject).schedule();
            }
        }
    }

    private IJavaProject resolveAffectedProject(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta[] iResourceDeltaArray;
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null && (iResourceDeltaArray = iResourceDelta.getAffectedChildren()) != null) {
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IJavaProject iJavaProject;
                IProject iProject;
                IResource iResource = iResourceDeltaArray[n].getResource();
                if (iResource != null && (iProject = iResource.getProject()) != null && (iJavaProject = JavaCore.create((IProject)iProject)) != null) {
                    return iJavaProject;
                }
                ++n;
            }
        }
        return null;
    }

    private void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

