/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.compiler;

import de.guhsoft.jinto.core.ASTUtil;
import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.Messages;
import de.guhsoft.jinto.core.compiler.JIntoJavaProblem;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfigurationManager;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ParameterReference;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JIntoCompilationParticipant
extends CompilationParticipant {
    private static final ASTParser PARSER = ASTParser.newParser((int)3);

    public boolean isActive(IJavaProject iJavaProject) {
        try {
            int n = JIntoCore.getPreferences().getInt(IPreferenceConstants.PROBLEMS_JAVA_NON_EXISTING_KEY.key(), IPreferenceConstants.PROBLEMS_JAVA_NON_EXISTING_KEY.defaultValue().intValue());
            if (n != JIntoCore.SEVERITY_IGNORE) {
                AccessorConfiguration accessorConfiguration = AccessorConfigurationManager.getInstance().getAccessorConfiguration(iJavaProject);
                boolean bl = false;
                boolean bl2 = true;
                if (accessorConfiguration.getResourceBundleReferences().size() > 0) {
                    bl = true;
                    bl2 = accessorConfiguration.validate().isOK();
                }
                if (!bl || bl && bl2) {
                    return this.checkReferencedProjects(iJavaProject) || bl && bl2;
                }
                return bl && bl2;
            }
        }
        catch (CoreException coreException) {
            String string = "Exception while resolving AccessorConfiguration for project '" + iJavaProject.getElementName() + "'.";
            Status status = new Status(4, JIntoCore.getID(), string, (Throwable)coreException);
            JIntoCore.getDefault().getLog().log((IStatus)status);
        }
        return false;
    }

    private boolean checkReferencedProjects(IJavaProject iJavaProject) throws CoreException {
        boolean bl = false;
        IProject iProject = iJavaProject.getProject();
        if (iProject.exists()) {
            IProject[] iProjectArray = iProject.getReferencedProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                AccessorConfiguration accessorConfiguration;
                IJavaProject iJavaProject2 = JavaCore.create((IProject)iProjectArray[n]);
                if (iJavaProject2 != null && (accessorConfiguration = AccessorConfigurationManager.getInstance().getAccessorConfiguration(iJavaProject2)).getResourceBundleReferences().size() > 0) {
                    bl = true;
                    if (!accessorConfiguration.validate().isOK()) {
                        return false;
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    public void buildStarting(BuildContext[] buildContextArray, boolean bl) {
        int n = 0;
        while (n < buildContextArray.length) {
            PARSER.setResolveBindings(true);
            IJavaElement iJavaElement = JavaCore.create((IFile)buildContextArray[n].getFile());
            if (iJavaElement != null && iJavaElement.getElementType() == 5) {
                PARSER.setSource((ICompilationUnit)iJavaElement);
                ASTNode aSTNode = PARSER.createAST(null);
                if (aSTNode.getNodeType() == 15) {
                    JIntoProblemVisitor jIntoProblemVisitor = new JIntoProblemVisitor(iJavaElement.getJavaProject(), buildContextArray[n].getFile(), (CompilationUnit)aSTNode);
                    aSTNode.accept((ASTVisitor)jIntoProblemVisitor);
                    buildContextArray[n].recordNewProblems((CategorizedProblem[])jIntoProblemVisitor.getProblems());
                }
            }
            ++n;
        }
    }

    public void reconcile(ReconcileContext reconcileContext) {
        try {
            CompilationUnit compilationUnit = reconcileContext.getAST3();
            if (compilationUnit != null) {
                ICompilationUnit iCompilationUnit = reconcileContext.getWorkingCopy();
                IResource iResource = iCompilationUnit.getResource();
                if (iResource.getType() != 1) {
                    iResource = null;
                }
                JIntoProblemVisitor jIntoProblemVisitor = new JIntoProblemVisitor(iCompilationUnit.getJavaProject(), (IFile)iResource, compilationUnit);
                compilationUnit.accept((ASTVisitor)jIntoProblemVisitor);
                reconcileContext.putProblems("de.guhsoft.jinto.core.java.problem", (CategorizedProblem[])jIntoProblemVisitor.getProblems());
            }
        }
        catch (JavaModelException javaModelException) {
            String string = "Error while reconciling '" + reconcileContext.getWorkingCopy().getElementName() + "'.";
            Status status = new Status(4, JIntoCore.getID(), string, (Throwable)javaModelException);
            JIntoCore.getDefault().getLog().log((IStatus)status);
        }
    }

    private static class JIntoProblemVisitor
    extends ASTVisitor {
        private IJavaProject fJavaProject;
        private IFile fResource;
        private CompilationUnit fCompilationUnit;
        private List<JIntoJavaProblem> fProblems;

        public JIntoProblemVisitor(IJavaProject iJavaProject, IFile iFile, CompilationUnit compilationUnit) {
            this.fJavaProject = iJavaProject;
            this.fResource = iFile;
            this.fCompilationUnit = compilationUnit;
            this.fProblems = new LinkedList<JIntoJavaProblem>();
        }

        public JIntoJavaProblem[] getProblems() {
            return this.fProblems.toArray(new JIntoJavaProblem[this.fProblems.size()]);
        }

        public boolean visit(MethodInvocation methodInvocation) {
            List list;
            int n;
            MethodReference methodReference;
            AccessorConfigurationManager.ProjectMethodReference projectMethodReference;
            AccessorConfigurationManager accessorConfigurationManager;
            block12: {
                ParameterReference parameterReference;
                block11: {
                    block10: {
                        block9: {
                            accessorConfigurationManager = AccessorConfigurationManager.getInstance();
                            projectMethodReference = accessorConfigurationManager.getMethodReference(this.fJavaProject, methodInvocation);
                            if (projectMethodReference != null) break block9;
                            return true;
                        }
                        methodReference = projectMethodReference.getMethodReference();
                        if (methodReference != null) break block10;
                        return true;
                    }
                    parameterReference = methodReference.getSelectedParameter();
                    if (parameterReference != null) break block11;
                    return true;
                }
                n = parameterReference.getIndex();
                list = methodInvocation.arguments();
                if (n < list.size()) break block12;
                return true;
            }
            try {
                List<StringLiteral> list2 = ASTUtil.getStringLiteral((ASTNode)list.get(n));
                for (StringLiteral stringLiteral : list2) {
                    this.analyzeStringLiteral(accessorConfigurationManager, projectMethodReference, methodReference, stringLiteral);
                }
            }
            catch (JavaModelException javaModelException) {
                this.log((Exception)((Object)javaModelException));
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
            catch (CoreException coreException) {
                this.log((Exception)((Object)coreException));
            }
            return true;
        }

        private void analyzeStringLiteral(AccessorConfigurationManager accessorConfigurationManager, AccessorConfigurationManager.ProjectMethodReference projectMethodReference, MethodReference methodReference, StringLiteral stringLiteral) throws CoreException, IOException {
            Object object;
            int n;
            int n2;
            Object object2;
            String string = stringLiteral.getEscapedValue();
            String string2 = string.substring(1, string.length() - 1);
            ClassReference classReference = methodReference.getClassReference();
            if (classReference == null) {
                return;
            }
            ResourceBundleReference resourceBundleReference = classReference.getResourceBundleReference();
            IJavaProject iJavaProject = projectMethodReference.getReferencedProject();
            AccessorConfiguration accessorConfiguration = accessorConfigurationManager.getAccessorConfiguration(iJavaProject);
            if (accessorConfiguration == null) {
                return;
            }
            ResourceBundleModel resourceBundleModel = accessorConfiguration.resolve(resourceBundleReference);
            if (resourceBundleModel == null) {
                IProject[] iProjectArray = object2 = iJavaProject.getProject().getReferencingProjects();
                n2 = ((IProject[])object2).length;
                n = 0;
                while (n < n2) {
                    object = iProjectArray[n];
                    IJavaProject iJavaProject2 = JavaCore.create((IProject)object);
                    if (iJavaProject2 != null && iJavaProject2.exists() && iJavaProject2.isOpen() && (accessorConfiguration = accessorConfigurationManager.getAccessorConfiguration(iJavaProject2)) != null && (resourceBundleModel = accessorConfiguration.resolve(classReference.getResourceBundleReference())) != null) break;
                    ++n;
                }
                if (resourceBundleModel == null) {
                    return;
                }
            }
            if (!resourceBundleModel.isLoaded()) {
                resourceBundleModel.load();
            }
            if ((object2 = resourceBundleModel.getRow(string2)) != null) {
                return;
            }
            object = Messages.getString("compiler.keyDoesntExists", string2, resourceBundleModel.getFullyQualifiedName(false));
            n = 1;
            n2 = JIntoCore.getPreferences().getInt(IPreferenceConstants.PROBLEMS_JAVA_NON_EXISTING_KEY.key(), IPreferenceConstants.PROBLEMS_JAVA_NON_EXISTING_KEY.defaultValue().intValue());
            int n3 = stringLiteral.getStartPosition();
            int n4 = n3 + stringLiteral.getLength() - 1;
            int n5 = this.fCompilationUnit.getLineNumber(n3);
            String[] stringArray = new String[]{resourceBundleModel.getFullyQualifiedName(false)};
            this.fProblems.add(new JIntoJavaProblem(this.fResource, n, n2, (String)object, n3, n4, n5, stringArray));
        }

        private void log(Exception exception) {
            String string = "Error while visiting compilation unit.";
            Status status = new Status(4, JIntoCore.getID(), string, (Throwable)exception);
            JIntoCore.getDefault().getLog().log((IStatus)status);
        }
    }
}

