/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.wizard;

import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.wizard.ConfigureNewResourceFilesPage;
import de.guhsoft.jinto.ui.wizard.INewResourceWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewResourcesWizard
extends BasicNewResourceWizard {
    private String fNewResourceFileName;
    private boolean enableLocation;
    IStatus finishStatus;

    public NewResourcesWizard() {
        this(null);
    }

    public NewResourcesWizard(String string) {
        this(string, true);
    }

    public NewResourcesWizard(String string, boolean bl) {
        this.fNewResourceFileName = string;
        this.enableLocation = bl;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(Messages.getString("wizard.window.title", new Object[0]));
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor imageDescriptor = JIntoUI.getDescriptor("newResourceFileWizard");
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }

    public void addPages() {
        super.addPages();
        ConfigureNewResourceFilesPage configureNewResourceFilesPage = new ConfigureNewResourceFilesPage("configureResourceFiles");
        this.addPage((IWizardPage)configureNewResourceFilesPage);
        configureNewResourceFilesPage.init(this.getSelection(), this.fNewResourceFileName, this.enableLocation);
    }

    public boolean performFinish() {
        this.finishStatus = new Status(0, JIntoUI.getID(), 0, "OK", null);
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                IWizardPage[] iWizardPageArray = NewResourcesWizard.this.getPages();
                int n = 0;
                int n2 = 0;
                while (n2 < iWizardPageArray.length) {
                    n += ((INewResourceWizardPage)iWizardPageArray[n2]).calcProgressMonitorWorkItems();
                    ++n2;
                }
                iProgressMonitor.beginTask("", n);
                n2 = 0;
                while (n2 < iWizardPageArray.length) {
                    iProgressMonitor.subTask(((INewResourceWizardPage)iWizardPageArray[n2]).getProgressMonitorTaskName());
                    try {
                        ((INewResourceWizardPage)iWizardPageArray[n2]).finishPage(iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        NewResourcesWizard.this.finishStatus = new Status(4, JIntoUI.getDefault().getBundle().getSymbolicName(), 4, coreException.getMessage(), coreException.fillInStackTrace());
                        JIntoUI.getDefault().getLog().log(NewResourcesWizard.this.finishStatus);
                        break;
                    }
                    ++n2;
                }
                iProgressMonitor.done();
            }
        };
        try {
            try {
                this.getContainer().run(true, false, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                this.finishStatus = new Status(4, JIntoUI.getID(), 4, throwable.getMessage(), throwable.fillInStackTrace());
                JIntoUI.getDefault().getLog().log(this.finishStatus);
                if (!this.finishStatus.isOK()) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("wizard.error.create", new Object[0]), (IStatus)this.finishStatus);
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                this.finishStatus = new Status(4, JIntoUI.getID(), 4, interruptedException.getMessage(), interruptedException.fillInStackTrace());
                JIntoUI.getDefault().getLog().log(this.finishStatus);
                if (!this.finishStatus.isOK()) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("wizard.error.create", new Object[0]), (IStatus)this.finishStatus);
                    return false;
                }
            }
        }
        finally {
            if (!this.finishStatus.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("wizard.error.create", new Object[0]), (IStatus)this.finishStatus);
                return false;
            }
        }
        return true;
    }
}

