/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search.reference;

import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ParameterReference;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.search.IJIntoSearchRequestor;
import de.guhsoft.jinto.ui.search.JIntoSearchQuery;
import de.guhsoft.jinto.ui.search.SearchUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSearchRequestorAndResult
extends AbstractTextSearchResult
implements IJIntoSearchRequestor,
IEditorMatchAdapter,
IFileMatchAdapter {
    private JIntoSearchQuery fJIntoSearchQuery;
    private String fSearchKey;
    private String fResourceFileName;
    private String fSearchScope;

    public ReferenceSearchRequestorAndResult(String string, String string2, String string3) {
        this.fSearchKey = string;
        this.fResourceFileName = string2;
        this.fSearchScope = string3;
    }

    @Override
    public void beginSearch() {
        this.removeAll();
    }

    @Override
    public void endSearch() {
    }

    @Override
    public void accepSearchMatch(Object object) {
        String string;
        Expression expression;
        MethodInvocation methodInvocation = (MethodInvocation)((Object[])object)[0];
        MethodReference methodReference = (MethodReference)((Object[])object)[1];
        ParameterReference parameterReference = methodReference.getSelectedParameter();
        if (parameterReference != null && (expression = (Expression)methodInvocation.arguments().get(parameterReference.getIndex())) != null && (string = SearchUtil.buildSourceKeyValue(expression)) != null && string.equals(this.fSearchKey)) {
            int n;
            IJavaElement iJavaElement = (IJavaElement)((Object[])object)[2];
            int n2 = methodInvocation.getStartPosition();
            IJavaElement iJavaElement2 = SearchUtil.findClosestJavaElement(iJavaElement, n2, n = methodInvocation.getLength());
            if (iJavaElement2 != null) {
                iJavaElement = iJavaElement2;
            }
            this.addMatch(new Match((Object)iJavaElement, n2, n));
        }
    }

    public String getLabel() {
        String string = String.valueOf(this.getMatchCount());
        return Messages.getString("search.result.label", this.fSearchKey, this.fResourceFileName, string, this.fSearchScope);
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return JIntoUI.getDescriptor("search");
    }

    @Override
    public void setQuery(JIntoSearchQuery jIntoSearchQuery) {
        this.fJIntoSearchQuery = jIntoSearchQuery;
    }

    public ISearchQuery getQuery() {
        return this.fJIntoSearchQuery;
    }

    public boolean isShownInEditor(Match match, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (match.getElement() instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)match.getElement();
            if (iEditorInput instanceof IFileEditorInput) {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                if (iPackageFragmentRoot.isArchive()) {
                    return false;
                }
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                IResource iResource = null;
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
                if (iCompilationUnit != null) {
                    iResource = iCompilationUnit.getResource();
                } else {
                    IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
                    if (iClassFile != null) {
                        iResource = iClassFile.getResource();
                    }
                }
                if (iResource != null) {
                    return iFile.equals((Object)iResource);
                }
                return false;
            }
        } else if (match.getElement() instanceof IFile && iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile().equals(match.getElement());
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return this.computeContainedMatches(abstractTextSearchResult, iFileEditorInput.getFile());
        }
        return null;
    }

    private void collectMatches(Set<Match> set, IJavaElement iJavaElement) {
        Match[] matchArray = this.getMatches(iJavaElement);
        if (matchArray.length != 0) {
            int n = 0;
            while (n < matchArray.length) {
                set.add(matchArray[n]);
                ++n;
            }
        }
        if (iJavaElement instanceof IParent) {
            IParent iParent = (IParent)iJavaElement;
            try {
                IJavaElement[] iJavaElementArray = iParent.getChildren();
                int n = 0;
                while (n < iJavaElementArray.length) {
                    this.collectMatches(set, iJavaElementArray[n]);
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
        IJavaElement iJavaElement = JavaCore.create((IFile)iFile);
        if (!(iJavaElement instanceof ICompilationUnit) && !(iJavaElement instanceof IClassFile)) {
            return new Match[0];
        }
        HashSet<Match> hashSet = new HashSet<Match>();
        this.collectMatches(hashSet, iJavaElement);
        return hashSet.toArray(new Match[hashSet.size()]);
    }

    public IFile getFile(Object object) {
        if (object instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)object;
            IFile iFile = null;
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
            if (iCompilationUnit != null) {
                iFile = (IFile)iCompilationUnit.getResource();
            } else {
                IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
                if (iClassFile != null) {
                    iFile = (IFile)iClassFile.getResource();
                }
            }
            return iFile;
        }
        if (object instanceof IFile) {
            return (IFile)object;
        }
        return null;
    }

    public String toString() {
        return Messages.getString("search.requestor.reference", new Object[0]);
    }
}

