/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search.general;

import de.guhsoft.jinto.core.JIntoBundleMarker;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.search.SearchUtil;
import de.guhsoft.jinto.ui.search.general.GeneralMatchAdditional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class GeneralSearchResultPage
extends AbstractTextSearchViewPage {
    public GeneralSearchResultPage() {
        super(2);
    }

    protected void elementsChanged(Object[] objectArray) {
        if (objectArray.length > 0) {
            this.getViewer().refresh();
        }
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        treeViewer.setContentProvider((IContentProvider)new GeneralContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new GeneralLabelProvider());
        treeViewer.setSorter((ViewerSorter)new GeneralSorter());
    }

    protected void configureTableViewer(TableViewer tableViewer) {
    }

    protected void showMatch(Match match, int n, int n2, boolean bl) {
        try {
            Object object;
            GeneralMatchAdditional generalMatchAdditional = (GeneralMatchAdditional)match.getElement();
            IEditorPart iEditorPart = null;
            IFile iFile = null;
            if (generalMatchAdditional.getCategoryID() == 2) {
                iFile = generalMatchAdditional.getReferencedFile();
            } else {
                object = ((IJavaElement)generalMatchAdditional.getObject()).getResource();
                if (object.getType() == 1) {
                    iFile = (IFile)object;
                }
            }
            if (iFile != null) {
                object = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                iEditorPart = IDE.openEditor((IWorkbenchPage)object, (IFile)iFile, (boolean)bl);
                if (iEditorPart instanceof ITextEditor) {
                    ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                    int n3 = match.getOffset();
                    int n4 = match.getLength();
                    iTextEditor.selectAndReveal(n3, n4);
                } else if (iEditorPart != null && generalMatchAdditional.getReferencedFile() != null) {
                    this.showWithMarker(iEditorPart, generalMatchAdditional.getReferencedFile(), (String)generalMatchAdditional.getObject());
                }
            } else {
                object = JIntoUI.getID();
                String string = "File for element(" + generalMatchAdditional + ") is null.";
                Status status = new Status(4, (String)object, 4, string, new Throwable());
                JIntoUI.getDefault().getLog().log((IStatus)status);
            }
        }
        catch (PartInitException partInitException) {
            String string = JIntoUI.getID();
            Status status = new Status(4, string, 4, partInitException.getMessage(), (Throwable)partInitException);
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
    }

    private void showWithMarker(IEditorPart iEditorPart, IFile iFile, String string) throws PartInitException {
        try {
            IMarker iMarker = iFile.createMarker("de.guhsoft.jinto.core.bundle.problem");
            HashMap hashMap = new HashMap(2);
            JIntoBundleMarker.addRow(hashMap, (String)string);
            iMarker.setAttributes(hashMap);
            IDE.gotoMarker((IEditorPart)iEditorPart, (IMarker)iMarker);
            iMarker.delete();
        }
        catch (CoreException coreException) {
            throw new PartInitException("Could not create marker", (Throwable)coreException);
        }
    }

    private class GeneralCategory {
        private String fCategoryName;
        private Image fCategoryImage;
        private List<GeneralMatchAdditional> fChildren;
        private int fCategoryID;
        private int fMatchesCount;

        public GeneralCategory(String string, Image image, int n) {
            this.fCategoryName = string;
            this.fCategoryImage = image;
            this.fCategoryID = n;
            this.fChildren = new LinkedList<GeneralMatchAdditional>();
            this.fMatchesCount = 0;
        }

        public String getCategoryName() {
            return Messages.getString("search.general.categoryLabel", this.fCategoryName, String.valueOf(this.fMatchesCount));
        }

        public Image getCategoryImage() {
            return this.fCategoryImage;
        }

        public int getCategoryID() {
            return this.fCategoryID;
        }

        public void addChild(GeneralMatchAdditional generalMatchAdditional) {
            this.fChildren.add(generalMatchAdditional);
            this.fMatchesCount += GeneralSearchResultPage.this.getDisplayedMatchCount(generalMatchAdditional);
        }

        public GeneralMatchAdditional[] getChildren() {
            GeneralMatchAdditional[] generalMatchAdditionalArray = new GeneralMatchAdditional[this.fChildren.size()];
            this.fChildren.toArray(generalMatchAdditionalArray);
            return generalMatchAdditionalArray;
        }

        public boolean contains(GeneralMatchAdditional generalMatchAdditional) {
            return generalMatchAdditional.getCategoryID() == this.fCategoryID;
        }

        public boolean equals(Object object) {
            if (object instanceof GeneralCategory) {
                return this.getCategoryID() == ((GeneralCategory)object).getCategoryID();
            }
            return super.equals(object);
        }
    }

    private class GeneralContentProvider
    implements ITreeContentProvider {
        private Viewer fViewer;

        GeneralContentProvider() {
        }

        public Object[] getChildren(Object object) {
            GeneralMatchAdditional generalMatchAdditional;
            if (object instanceof GeneralCategory) {
                GeneralCategory generalCategory = (GeneralCategory)object;
                if (generalCategory.getCategoryID() == 2) {
                    return generalCategory.getChildren();
                }
                GeneralMatchAdditional[] generalMatchAdditionalArray = generalCategory.getChildren();
                if (generalMatchAdditionalArray.length > 0) {
                    return this.getConvertedChildren(generalCategory.getCategoryID(), (IJavaElement)((IJavaElement)generalMatchAdditionalArray[0].getObject()).getJavaModel());
                }
            } else if (object instanceof GeneralMatchAdditional && (generalMatchAdditional = (GeneralMatchAdditional)object).getObject() instanceof IJavaElement) {
                Object[] objectArray = this.getConvertedChildren(generalMatchAdditional.getCategoryID(), (IJavaElement)generalMatchAdditional.getObject());
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((AbstractTextSearchResult)this.fViewer.getInput()).getElements();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        if (objectArray[n].equals(objectArray2[n2])) {
                            objectArray[n] = objectArray2[n2];
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
                return objectArray;
            }
            return new Object[0];
        }

        private Object[] getConvertedChildren(int n, IJavaElement iJavaElement) {
            Object[] objectArray = ((AbstractTextSearchResult)this.fViewer.getInput()).getElements();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (((GeneralMatchAdditional)objectArray[n2]).getCategoryID() == n) {
                    linkedList.add(((GeneralMatchAdditional)objectArray[n2]).getObject());
                }
                ++n2;
            }
            IJavaElement[] iJavaElementArray = new IJavaElement[linkedList.size()];
            linkedList.toArray(iJavaElementArray);
            IJavaElement[] iJavaElementArray2 = SearchUtil.getChildrenWithSkippingCompilationUnitsAndNotNeededElements(iJavaElement, iJavaElementArray);
            return this.convert(iJavaElementArray2, n);
        }

        private Object[] convert(IJavaElement[] iJavaElementArray, int n) {
            Object[] objectArray = new Object[iJavaElementArray.length];
            int n2 = 0;
            while (n2 < iJavaElementArray.length) {
                objectArray[n2] = new GeneralMatchAdditional(n, iJavaElementArray[n2]);
                ++n2;
            }
            return objectArray;
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            ArrayList<GeneralCategory> arrayList = new ArrayList<GeneralCategory>(3);
            Object[] objectArray = ((AbstractTextSearchResult)object).getElements();
            int n = 0;
            while (n < objectArray.length) {
                GeneralMatchAdditional generalMatchAdditional = (GeneralMatchAdditional)objectArray[n];
                boolean bl = false;
                for (GeneralCategory generalCategory : arrayList) {
                    if (!generalCategory.contains(generalMatchAdditional)) continue;
                    generalCategory.addChild(generalMatchAdditional);
                    bl = true;
                    break;
                }
                if (!bl) {
                    GeneralCategory generalCategory;
                    Object object2 = null;
                    generalCategory = null;
                    int n2 = generalMatchAdditional.getCategoryID();
                    switch (n2) {
                        case 2: {
                            object2 = Messages.getString("search.general.unusedKeyLabel", new Object[0]);
                            generalCategory = JIntoUI.getImage("search/unusedKeys");
                            break;
                        }
                        case 0: {
                            object2 = Messages.getString("search.general.undefiniedKeyLabel", new Object[0]);
                            generalCategory = JIntoUI.getImage("search/undefiniedKeys");
                            break;
                        }
                        case 1: {
                            object2 = Messages.getString("search.general.indeterminableKeyLabel", new Object[0]);
                            generalCategory = JIntoUI.getImage("search/indeterminableKeys");
                        }
                    }
                    GeneralCategory generalCategory2 = new GeneralCategory((String)object2, (Image)generalCategory, n2);
                    arrayList.add(generalCategory2);
                    generalCategory2.addChild(generalMatchAdditional);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.fViewer = viewer;
        }
    }

    private class GeneralLabelProvider
    extends JavaElementLabelProvider {
        GeneralLabelProvider() {
        }

        public Image getImage(Object object) {
            if (object instanceof GeneralCategory) {
                return ((GeneralCategory)object).getCategoryImage();
            }
            if (object instanceof GeneralMatchAdditional) {
                GeneralMatchAdditional generalMatchAdditional = (GeneralMatchAdditional)object;
                if (generalMatchAdditional.getCategoryID() == 2) {
                    return JIntoUI.getImage("search/unusedKey");
                }
                return super.getImage(generalMatchAdditional.getObject());
            }
            return super.getImage(object);
        }

        public String getText(Object object) {
            if (object instanceof GeneralCategory) {
                return ((GeneralCategory)object).getCategoryName();
            }
            if (object instanceof GeneralMatchAdditional) {
                GeneralMatchAdditional generalMatchAdditional = (GeneralMatchAdditional)object;
                if (generalMatchAdditional.getCategoryID() == 2) {
                    return (String)generalMatchAdditional.getObject();
                }
                return super.getText(generalMatchAdditional.getObject());
            }
            return super.getText(object);
        }
    }

    private static class GeneralSorter
    extends ViewerSorter {
        GeneralSorter() {
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            if (object instanceof GeneralCategory && object2 instanceof GeneralCategory) {
                int n;
                int n2 = ((GeneralCategory)object).getCategoryID();
                if (n2 > (n = ((GeneralCategory)object2).getCategoryID())) {
                    return 1;
                }
                if (n2 < n) {
                    return -1;
                }
                return 0;
            }
            return super.compare(viewer, object, object2);
        }
    }
}

