/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search.general;

import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ParameterReference;
import de.guhsoft.jinto.core.model.IResourceBundleListener;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.search.IJIntoSearchRequestor;
import de.guhsoft.jinto.ui.search.JIntoSearchQuery;
import de.guhsoft.jinto.ui.search.SearchUtil;
import de.guhsoft.jinto.ui.search.general.GeneralMatchAdditional;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralSearchRequestorAndResult
extends AbstractTextSearchResult
implements IJIntoSearchRequestor,
IEditorMatchAdapter,
IFileMatchAdapter,
IResourceBundleListener {
    private JIntoSearchQuery fJIntoSearchQuery;
    private ResourceBundleModel fResourceBundleModel;
    private Set<String> fKeysSet;
    private boolean fUnusedKeys;
    private boolean fUndefinedKeys;
    private boolean fIndeterminableKeys;
    private String fSearchScope;

    public GeneralSearchRequestorAndResult(ResourceBundleModel resourceBundleModel, boolean bl, boolean bl2, boolean bl3, String string) {
        this.fResourceBundleModel = resourceBundleModel;
        this.fUnusedKeys = bl;
        this.fUndefinedKeys = bl2;
        this.fIndeterminableKeys = bl3;
        this.fSearchScope = string;
    }

    @Override
    public void beginSearch() {
        this.removeAll();
        if (!this.fResourceBundleModel.isLoaded()) {
            try {
                this.fResourceBundleModel.load();
            }
            catch (IOException iOException) {
                this.logException(iOException);
            }
            catch (CoreException coreException) {
                this.logException((Exception)((Object)coreException));
            }
        }
        this.fKeysSet = new HashSet<String>();
        Iterator iterator = this.fResourceBundleModel.getRowKeys();
        while (iterator.hasNext()) {
            this.fKeysSet.add((String)iterator.next());
        }
    }

    @Override
    public void endSearch() {
        if (this.fUnusedKeys) {
            IFile iFile = (IFile)this.fResourceBundleModel.getSelectedStorage().getAdapter(IFile.class);
            if (iFile != null) {
                Iterator<String> iterator = this.fKeysSet.iterator();
                while (iterator.hasNext()) {
                    this.addMatch(new Match((Object)new GeneralMatchAdditional(iterator.next(), iFile), 0, 0));
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer("ResourceBundle storage(");
                stringBuffer.append(this.fResourceBundleModel.getSelectedStorage());
                stringBuffer.append(") is no instance of IFile.");
                this.logException(new Exception(stringBuffer.toString()));
            }
        }
        this.fResourceBundleModel.addListener((IResourceBundleListener)this);
    }

    @Override
    public void accepSearchMatch(Object object) {
        Expression expression;
        MethodInvocation methodInvocation = (MethodInvocation)((Object[])object)[0];
        MethodReference methodReference = (MethodReference)((Object[])object)[1];
        ParameterReference parameterReference = methodReference.getSelectedParameter();
        if (parameterReference != null && (expression = (Expression)methodInvocation.arguments().get(parameterReference.getIndex())) != null) {
            String string = SearchUtil.buildSourceKeyValue(expression);
            if (string == null) {
                if (this.fIndeterminableKeys) {
                    this.addMatch(this.createMatch(methodInvocation, (IJavaElement)((Object[])object)[2], 1));
                }
            } else {
                this.fKeysSet.remove(string);
                if (this.fUndefinedKeys && this.fResourceBundleModel.getRow(string) == null) {
                    this.addMatch(this.createMatch(methodInvocation, (IJavaElement)((Object[])object)[2], 0));
                }
            }
        }
    }

    private Match createMatch(MethodInvocation methodInvocation, IJavaElement iJavaElement, int n) {
        int n2;
        int n3 = methodInvocation.getStartPosition();
        IJavaElement iJavaElement2 = SearchUtil.findClosestJavaElement(iJavaElement, n3, n2 = methodInvocation.getLength());
        if (iJavaElement2 != null) {
            iJavaElement = iJavaElement2;
        }
        GeneralMatchAdditional generalMatchAdditional = new GeneralMatchAdditional(n, iJavaElement);
        Object[] objectArray = this.getElements();
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (generalMatchAdditional.equals(objectArray[n4])) {
                generalMatchAdditional = (GeneralMatchAdditional)objectArray[n4];
                break;
            }
            ++n4;
        }
        return new Match((Object)generalMatchAdditional, n3, n2);
    }

    private void logException(Exception exception) {
        Throwable throwable = exception.getCause();
        Status status = new Status(4, JIntoUI.getID(), 4, throwable.getMessage(), throwable.fillInStackTrace());
        JIntoUI.getDefault().getLog().log((IStatus)status);
    }

    public String getLabel() {
        String string = String.valueOf(this.getMatchCount());
        return Messages.getString("search.general.resultLabel", this.fResourceBundleModel.toString(), string, this.fSearchScope);
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return JIntoUI.getDescriptor("/icons/search.gif");
    }

    @Override
    public void setQuery(JIntoSearchQuery jIntoSearchQuery) {
        this.fJIntoSearchQuery = jIntoSearchQuery;
    }

    public ISearchQuery getQuery() {
        return this.fJIntoSearchQuery;
    }

    public void rowAdded(String string, ResourceRow resourceRow) {
    }

    public void rowRemoved(String string, ResourceRow resourceRow) {
        Object[] objectArray = this.getElements();
        int n = 0;
        while (n < objectArray.length) {
            GeneralMatchAdditional generalMatchAdditional = (GeneralMatchAdditional)objectArray[n];
            if (generalMatchAdditional.getCategoryID() == 2 && generalMatchAdditional.getObject().equals(string)) {
                this.removeMatches(this.getMatches(generalMatchAdditional));
                break;
            }
            ++n;
        }
    }

    public void rowKeyChanged(String string, String string2, ResourceRow resourceRow) {
    }

    public void rowValueChanged(ResourceRow resourceRow, String string, String string2) {
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public boolean isShownInEditor(Match match, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Object object = match.getElement();
        if (object instanceof GeneralMatchAdditional && ((GeneralMatchAdditional)object).getObject() instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)((GeneralMatchAdditional)object).getObject();
            if (iEditorInput instanceof IFileEditorInput) {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                if (iPackageFragmentRoot.isArchive()) {
                    return false;
                }
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                IResource iResource = null;
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
                if (iCompilationUnit != null) {
                    iResource = iCompilationUnit.getResource();
                } else {
                    IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
                    if (iClassFile != null) {
                        iResource = iClassFile.getResource();
                    }
                }
                if (iResource != null) {
                    return iFile.equals((Object)iResource);
                }
                return false;
            }
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return this.computeContainedMatches(abstractTextSearchResult, iFileEditorInput.getFile());
        }
        return null;
    }

    private void collectMatches(Set<Match> set, IJavaElement iJavaElement) {
        int n;
        IJavaElement[] iJavaElementArray;
        Object[] objectArray = this.getElements();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (((GeneralMatchAdditional)objectArray[n2]).getObject().equals(iJavaElement) && (iJavaElementArray = this.getMatches(objectArray[n2])).length != 0) {
                n = 0;
                while (n < iJavaElementArray.length) {
                    set.add((Match)iJavaElementArray[n]);
                    ++n;
                }
            }
            ++n2;
        }
        if (iJavaElement instanceof IParent) {
            IParent iParent = (IParent)iJavaElement;
            try {
                iJavaElementArray = iParent.getChildren();
                n = 0;
                while (n < iJavaElementArray.length) {
                    this.collectMatches(set, iJavaElementArray[n]);
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
        IJavaElement iJavaElement = JavaCore.create((IFile)iFile);
        if (!(iJavaElement instanceof ICompilationUnit) && !(iJavaElement instanceof IClassFile)) {
            return new Match[0];
        }
        HashSet<Match> hashSet = new HashSet<Match>();
        this.collectMatches(hashSet, iJavaElement);
        return hashSet.toArray(new Match[hashSet.size()]);
    }

    public IFile getFile(Object object) {
        if (object instanceof GeneralMatchAdditional && ((GeneralMatchAdditional)object).getObject() instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)((GeneralMatchAdditional)object).getObject();
            IFile iFile = null;
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
            if (iCompilationUnit != null) {
                iFile = (IFile)iCompilationUnit.getResource();
            } else {
                IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
                if (iClassFile != null) {
                    iFile = (IFile)iClassFile.getResource();
                }
            }
            return iFile;
        }
        return null;
    }

    public String toString() {
        return Messages.getString("search.requestor.general", new Object[0]);
    }
}

