/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search;

import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfigurationManager;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.core.model.ResourceBundleManager;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.util.ResourceBundleUtil;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.search.IJIntoSearchRequestor;
import de.guhsoft.jinto.ui.search.JIntoSearchQuery;
import de.guhsoft.jinto.ui.search.JIntoSearchScope;
import de.guhsoft.jinto.ui.search.ResourceBundleSearchLabelProvider;
import de.guhsoft.jinto.ui.search.ResourceBundleSearchSelectionDialog;
import de.guhsoft.jinto.ui.search.general.GeneralSearchRequestorAndResult;
import de.guhsoft.jinto.ui.search.reference.ReferenceSearchRequestorAndResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSearch
extends DialogPage
implements ISearchPage {
    public static String REFERENCE_SEARCH_KEY = null;
    private static final String SETTINGS_SECTION_ID = "de.guhsoft.jinto.resourceSearchPageV2";
    private static final String RESOURCE_BUNDLE_HISTORY_ID = "selectedResourceBundle";
    private static final String PROJECT_KEY = "projectKey";
    private static final String REFERENCE_KEY = "referenceKey";
    private static final String OPTIONS_REFERENCE = "optionsReference";
    private static final String UNUSED_KEYS = "unusedKeys";
    private static final String UNDEFINED_KEYS = "undefinedKeys";
    private static final String UNDETERMINABLE_KEYS = "undeterminableKeys";
    ISearchPageContainer fSearchContainer;
    private IDialogSettings fSettings;
    Text fResourceBundleField;
    private List<ResourceBundleModel> fAllResourceBundles;
    private Button fFindUnusedKeysButton;
    private Button fFindUndefinedKeysButton;
    private Button fFindIndeterminableKeysButton;
    Text fProjectField;
    private Text fReferenceKeyField;
    Button fGeneralSearchButton;
    Button fReferenceSearchButton;
    private ProblemMessage fProblemMessage;
    private HashMap<IJavaProject, AccessorConfiguration> fAccessorConfigurations;
    private ResourceBundleContentProposalProvider fBundleContentProposalProvider;
    private SimpleContentProposalProvider fKeyContentProposalProvider;
    private Button fChooseProject;
    private Button fChooseBundle;
    private Button fChooseKeyReference;
    ModifyListener fResourceBundleFieldModifyListener;

    public void createControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new GridLayout());
        this.loadConfiguration();
        this.createResourceBundleComposite(composite2);
        this.createOptionsGroup(composite2);
        this.loadSettings();
        IJavaProject[] iJavaProjectArray = this.getProjectList();
        if (iJavaProjectArray == null || iJavaProjectArray.length == 0) {
            this.fChooseProject.setEnabled(false);
        }
        if (this.fAllResourceBundles == null || this.fAllResourceBundles.size() == 0) {
            this.fChooseBundle.setEnabled(false);
        }
        this.addListenerToControl();
        this.initSelection();
        this.setControl((Control)composite2);
    }

    private void initSelection() {
        Object object;
        ISelection iSelection = this.fSearchContainer.getSelection();
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof IFile) {
            try {
                ResourceBundleModel resourceBundleModel = ResourceBundleManager.createForFile((IStorage)((IFile)object), (boolean)false);
                if (resourceBundleModel == null) {
                    this.loadSettings();
                } else {
                    this.fResourceBundleField.setText(resourceBundleModel.getFullyQualifiedName(false));
                    this.bundleSelectionChanged(resourceBundleModel);
                }
            }
            catch (IOException iOException) {
                this.loadSettings();
            }
            catch (CoreException coreException) {
                this.loadSettings();
            }
        }
    }

    private void loadConfiguration() {
        this.fAllResourceBundles = ResourceBundleUtil.searchForResourceBundles();
        try {
            this.fAccessorConfigurations = new HashMap();
            IJavaProject[] iJavaProjectArray = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            if (iJavaProjectArray != null) {
                int n = 0;
                while (n < iJavaProjectArray.length) {
                    this.loadConfiguration(iJavaProjectArray[n]);
                    ++n;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            Status status = new Status(4, JIntoUI.getID(), "Error while creating Java model for projects...", (Throwable)javaModelException);
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
    }

    private void loadConfiguration(IJavaProject iJavaProject) {
        try {
            this.fAccessorConfigurations.put(iJavaProject, AccessorConfigurationManager.getInstance().getAccessorConfiguration(iJavaProject));
        }
        catch (CoreException coreException) {
            StringBuffer stringBuffer = new StringBuffer("Error while loading AccessorConfiguration for project '");
            stringBuffer.append(iJavaProject);
            stringBuffer.append("'...");
            Status status = new Status(4, JIntoUI.getID(), stringBuffer.toString(), (Throwable)coreException);
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
    }

    private void createResourceBundleComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 16384);
        label.setText(Messages.getString("search.label.project", new Object[0]));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.fProjectField = new Text(composite2, 2048);
        this.fProjectField.setLayoutData((Object)new GridData(768));
        this.installProjectAutocompletion(this.fProjectField);
        this.fChooseProject = new Button(composite2, 8);
        this.fChooseProject.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.fChooseProject.setText(Messages.getString("search.button.chooseProject", new Object[0]));
        this.setButtonDimensionHint(this.fChooseProject);
        Label label2 = new Label(composite2, 16384);
        label2.setText(Messages.getString("search.label.resourceBundle", new Object[0]));
        label2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.fResourceBundleField = new Text(composite2, 2052);
        this.fResourceBundleField.setLayoutData((Object)new GridData(768));
        this.installBundleAutocompletion(this.fResourceBundleField);
        this.fChooseBundle = new Button(composite2, 8);
        this.fChooseBundle.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.fChooseBundle.setText(Messages.getString("search.button.chooseBundleButton", new Object[0]));
        this.setButtonDimensionHint(this.fChooseBundle);
        this.fProblemMessage = new ProblemMessage(composite2);
    }

    private void createOptionsGroup(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.getString("search.label.optionsGroup", new Object[0]));
        this.fGeneralSearchButton = new Button((Composite)group, 16);
        this.fGeneralSearchButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fGeneralSearchButton.setText(Messages.getString("search.options.general.title", new Object[0]));
        int n = 20;
        Label label = new Label((Composite)group, 0);
        GridData gridData = new GridData();
        gridData.widthHint = n;
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        this.createGeneralSearchOptions((Composite)group);
        this.fReferenceSearchButton = new Button((Composite)group, 16);
        this.fReferenceSearchButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fReferenceSearchButton.setText(Messages.getString("search.options.reference.title", new Object[0]));
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.widthHint = n;
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        this.createReferenceSearchOptions((Composite)group);
    }

    private void createReferenceSearchOptions(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.fReferenceKeyField = new Text(composite2, 2048);
        this.fReferenceKeyField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.installKeyAutocompletion(this.fReferenceKeyField);
        this.fChooseKeyReference = new Button(composite2, 8);
        this.fChooseKeyReference.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.fChooseKeyReference.setText(Messages.getString("search.button.chooseReferenceButton", new Object[0]));
        this.setButtonDimensionHint(this.fChooseKeyReference);
    }

    private void createGeneralSearchOptions(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        composite2.setLayout((Layout)new GridLayout(3, true));
        this.fFindUnusedKeysButton = new Button(composite2, 32);
        this.fFindUnusedKeysButton.setText(Messages.getString("search.options.general.unusedKeys", new Object[0]));
        this.fFindUndefinedKeysButton = new Button(composite2, 32);
        this.fFindUndefinedKeysButton.setText(Messages.getString("search.options.general.undefinedKeys", new Object[0]));
        this.fFindIndeterminableKeysButton = new Button(composite2, 32);
        this.fFindIndeterminableKeysButton.setText(Messages.getString("search.options.general.undeterminableKeys", new Object[0]));
    }

    private void addListenerToControl() {
        this.fProjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceSearch.this.projectSelectionChanged();
            }
        });
        this.fProjectField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((Text)focusEvent.widget).selectAll();
            }
        });
        this.fChooseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceSearch.this.chooseProjectAction();
            }
        });
        this.fResourceBundleFieldModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceSearch.this.bundleSelectionChanged(null);
            }
        };
        this.fResourceBundleField.addModifyListener(this.fResourceBundleFieldModifyListener);
        this.fResourceBundleField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((Text)focusEvent.widget).selectAll();
            }
        });
        this.fChooseBundle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceSearch.this.chooseBundleAction();
            }
        });
        this.fGeneralSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceSearch.this.changeOptionsModus(ResourceSearch.this.fGeneralSearchButton.getSelection());
                ResourceSearch.this.validate();
            }
        });
        this.fReferenceSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceSearch.this.changeOptionsModus(!ResourceSearch.this.fReferenceSearchButton.getSelection());
                ResourceSearch.this.validate();
            }
        });
        this.fReferenceKeyField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceSearch.this.validate();
            }
        });
        this.fReferenceKeyField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((Text)focusEvent.widget).selectAll();
            }
        });
        this.fChooseKeyReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceSearch.this.chooseReferenceKey();
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceSearch.this.validate();
            }
        };
        this.fFindUnusedKeysButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.fFindUndefinedKeysButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.fFindIndeterminableKeysButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void installProjectAutocompletion(Text text) {
        String[] stringArray = null;
        IJavaProject[] iJavaProjectArray = this.getProjectList();
        if (iJavaProjectArray != null) {
            stringArray = new String[iJavaProjectArray.length];
            int n = 0;
            while (n < iJavaProjectArray.length) {
                stringArray[n] = iJavaProjectArray[n].getElementName();
                ++n;
            }
        } else {
            stringArray = new String[]{};
        }
        TextContentAdapter textContentAdapter = new TextContentAdapter();
        SimpleContentProposalProvider simpleContentProposalProvider = new SimpleContentProposalProvider(stringArray);
        simpleContentProposalProvider.setFiltering(true);
        KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)32);
        ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)simpleContentProposalProvider, keyStroke, null);
        contentProposalAdapter.setPropagateKeys(true);
        contentProposalAdapter.setProposalAcceptanceStyle(2);
        contentProposalAdapter.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((IContentProposal)object).getContent();
            }

            public Image getImage(Object object) {
                return JIntoUI.getImage("project");
            }
        });
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.setDescriptionText(String.valueOf(fieldDecoration.getDescription()) + " (" + keyStroke.format() + ")");
        controlDecoration.setShowOnlyOnFocus(true);
    }

    private void installBundleAutocompletion(Text text) {
        TextContentAdapter textContentAdapter = new TextContentAdapter();
        this.fBundleContentProposalProvider = new ResourceBundleContentProposalProvider();
        this.fBundleContentProposalProvider.setBundles(this.getProjectBundles());
        KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)32);
        ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)this.fBundleContentProposalProvider, keyStroke, null);
        contentProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal iContentProposal) {
                ResourceSearch.this.fResourceBundleField.removeModifyListener(ResourceSearch.this.fResourceBundleFieldModifyListener);
                ResourceSearch.this.bundleSelectionChanged(((ResourceBundleContentProposal)iContentProposal).getResourceBundle());
                ResourceSearch.this.fResourceBundleField.addModifyListener(ResourceSearch.this.fResourceBundleFieldModifyListener);
            }
        });
        contentProposalAdapter.setPropagateKeys(true);
        contentProposalAdapter.setProposalAcceptanceStyle(2);
        contentProposalAdapter.setLabelProvider((ILabelProvider)new ResourceBundleSearchLabelProvider(this.getBundelConfiguration()){

            public String getText(Object object) {
                StringBuffer stringBuffer = new StringBuffer(super.getText(object));
                ResourceBundleModel resourceBundleModel = ResourceSearch.this.getModelForString(stringBuffer.toString());
                IJavaProject iJavaProject = ResourceSearch.getJavaProjectFromResourceBundleModel(resourceBundleModel);
                if (iJavaProject != null) {
                    stringBuffer.append(" - ");
                    stringBuffer.append(iJavaProject.getElementName());
                }
                return stringBuffer.toString();
            }
        });
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.setDescriptionText(String.valueOf(fieldDecoration.getDescription()) + " (" + keyStroke.format() + ")");
        controlDecoration.setShowOnlyOnFocus(true);
    }

    private void installKeyAutocompletion(Text text) {
        TextContentAdapter textContentAdapter = new TextContentAdapter();
        this.fKeyContentProposalProvider = new SimpleContentProposalProvider(new String[0]);
        this.fKeyContentProposalProvider.setFiltering(true);
        KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)32);
        ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)this.fKeyContentProposalProvider, keyStroke, null);
        contentProposalAdapter.setPropagateKeys(true);
        contentProposalAdapter.setProposalAcceptanceStyle(2);
        contentProposalAdapter.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((IContentProposal)object).getContent();
            }

            public Image getImage(Object object) {
                return JIntoUI.getImage("key");
            }
        });
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.setDescriptionText(String.valueOf(fieldDecoration.getDescription()) + " (" + keyStroke.format() + ")");
        controlDecoration.setShowOnlyOnFocus(true);
    }

    void bundleSelectionChanged(ResourceBundleModel resourceBundleModel) {
        Object object;
        ResourceBundleModel resourceBundleModel2 = resourceBundleModel;
        if (resourceBundleModel2 == null && ((String)(object = this.fResourceBundleField.getText())).length() > 0) {
            resourceBundleModel2 = this.getModelForString((String)object);
        }
        if ((object = ResourceSearch.getJavaProjectFromResourceBundleModel(resourceBundleModel2)) != null && !this.fProjectField.getText().equals(object.getElementName())) {
            this.fProjectField.setText(object.getElementName());
        }
        if (this.fReferenceSearchButton.getSelection()) {
            String string = this.fReferenceKeyField.getText();
            if (resourceBundleModel2 == null || resourceBundleModel2.getRow(string) == null) {
                this.fReferenceKeyField.setText("");
            }
        }
        this.validate();
        this.changeKeyAutoCompletionInput();
    }

    void projectSelectionChanged() {
        this.validate();
        this.changeBundleAutoCompletionInput();
    }

    private void changeBundleAutoCompletionInput() {
        List<ResourceBundleModel> list = this.getProjectBundles();
        this.fBundleContentProposalProvider.setBundles(list);
        this.fChooseBundle.setEnabled(list.size() > 0);
    }

    private void changeKeyAutoCompletionInput() {
        List<String> list = this.getKeyReferenceInput();
        this.fKeyContentProposalProvider.setProposals(list.toArray(new String[list.size()]));
        if (this.fReferenceSearchButton.getSelection()) {
            this.fChooseKeyReference.setEnabled(list.size() > 0);
        }
    }

    private List<String> getKeyReferenceInput() {
        ResourceBundleModel resourceBundleModel = this.getModelForString(this.fResourceBundleField.getText());
        LinkedList<String> linkedList = new LinkedList<String>();
        if (resourceBundleModel != null) {
            if (!resourceBundleModel.isLoaded()) {
                Status status;
                try {
                    resourceBundleModel.load();
                }
                catch (IOException iOException) {
                    status = new Status(4, JIntoUI.getID(), "Error while loading resource file", (Throwable)iOException);
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("search.error.bundle.load", this.fResourceBundleField.getText()), (IStatus)status);
                }
                catch (CoreException coreException) {
                    status = new Status(4, JIntoUI.getID(), "Error while loading resource file", (Throwable)coreException);
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("search.error.bundle.load", this.fResourceBundleField.getText()), (IStatus)status);
                }
            }
            Iterator iterator = resourceBundleModel.getRowKeys();
            int n = 0;
            while (iterator.hasNext()) {
                linkedList.add((String)iterator.next());
                ++n;
            }
        }
        Collections.sort(linkedList);
        return linkedList;
    }

    void changeOptionsModus(boolean bl) {
        this.fFindUnusedKeysButton.setEnabled(bl);
        this.fFindUndefinedKeysButton.setEnabled(bl);
        this.fFindIndeterminableKeysButton.setEnabled(bl);
        this.fReferenceKeyField.setEnabled(!bl);
        this.fChooseKeyReference.setEnabled(!bl);
    }

    private void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object object = button.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = this.getButtonWidthHint(button);
            ((GridData)object).horizontalAlignment = 4;
        }
    }

    private int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        GC gC = new GC((Drawable)button);
        gC.setFont(button.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private void loadSettings() {
        String string;
        String string2;
        String string3;
        this.fSettings = JIntoUI.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_ID);
        if (this.fSettings == null) {
            this.fSettings = JIntoUI.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_ID);
            this.fSettings.put(OPTIONS_REFERENCE, false);
            this.fSettings.put(UNUSED_KEYS, true);
            this.fSettings.put(UNDEFINED_KEYS, true);
            this.fSettings.put(UNDETERMINABLE_KEYS, true);
        }
        if ((string3 = this.fSettings.get(PROJECT_KEY)) != null && string3.trim().length() > 0) {
            this.fProjectField.setText(string3);
        }
        if ((string2 = this.fSettings.get(RESOURCE_BUNDLE_HISTORY_ID)) != null && string2.trim().length() > 0) {
            this.fResourceBundleField.setText(string2);
        }
        boolean bl = REFERENCE_SEARCH_KEY != null || this.fSettings.getBoolean(OPTIONS_REFERENCE);
        this.fGeneralSearchButton.setSelection(!bl);
        this.changeOptionsModus(bl);
        this.fReferenceSearchButton.setSelection(bl);
        this.changeOptionsModus(!bl);
        this.fFindUnusedKeysButton.setSelection(this.fSettings.getBoolean(UNUSED_KEYS));
        this.fFindUndefinedKeysButton.setSelection(this.fSettings.getBoolean(UNDEFINED_KEYS));
        this.fFindIndeterminableKeysButton.setSelection(this.fSettings.getBoolean(UNDETERMINABLE_KEYS));
        String string4 = string = REFERENCE_SEARCH_KEY != null ? REFERENCE_SEARCH_KEY : this.fSettings.get(REFERENCE_KEY);
        if (string != null && string.length() > 0) {
            this.fReferenceKeyField.setText(string);
        }
    }

    private void saveSettings(String string) {
        this.fSettings = JIntoUI.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_ID);
        this.fSettings.put(PROJECT_KEY, this.fProjectField.getText());
        this.fSettings.put(RESOURCE_BUNDLE_HISTORY_ID, string);
        this.fSettings.put(OPTIONS_REFERENCE, this.fReferenceSearchButton.getSelection());
        this.fSettings.put(UNUSED_KEYS, this.fFindUnusedKeysButton.getSelection());
        this.fSettings.put(UNDEFINED_KEYS, this.fFindUndefinedKeysButton.getSelection());
        this.fSettings.put(UNDETERMINABLE_KEYS, this.fFindIndeterminableKeysButton.getSelection());
        this.fSettings.put(REFERENCE_KEY, this.fReferenceKeyField.getText());
    }

    void chooseReferenceKey() {
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object object) {
                return JIntoUI.getImage("key");
            }
        };
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        elementListSelectionDialog.setTitle(Messages.getString("search.keyDialog.title", new Object[0]));
        elementListSelectionDialog.setMessage(Messages.getString("search.keyDialog.message", new Object[0]));
        List<String> list = this.getKeyReferenceInput();
        elementListSelectionDialog.setElements(list.toArray());
        if (elementListSelectionDialog.open() == 0) {
            this.fReferenceKeyField.setText(elementListSelectionDialog.getFirstResult().toString());
        }
    }

    void chooseProjectAction() {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        elementListSelectionDialog.setImage(JIntoUI.getImage("project"));
        elementListSelectionDialog.setTitle(Messages.getString("search.projectDialog.title", new Object[0]));
        elementListSelectionDialog.setMessage(Messages.getString("search.projectDialog.message", new Object[0]));
        Object[] objectArray = this.getProjectList();
        if (objectArray != null && objectArray.length > 0) {
            elementListSelectionDialog.setElements(objectArray);
        }
        if (elementListSelectionDialog.open() == 0) {
            IJavaProject iJavaProject = (IJavaProject)elementListSelectionDialog.getFirstResult();
            if (iJavaProject != null) {
                this.fProjectField.setText(iJavaProject.getElementName());
            }
            this.validate();
        }
    }

    void chooseBundleAction() {
        List<ResourceBundleModel> list = this.getProjectBundles();
        ResourceBundleSearchLabelProvider resourceBundleSearchLabelProvider = new ResourceBundleSearchLabelProvider(this.getBundelConfiguration());
        ResourceBundleSearchSelectionDialog resourceBundleSearchSelectionDialog = new ResourceBundleSearchSelectionDialog(this.getShell(), resourceBundleSearchLabelProvider);
        resourceBundleSearchSelectionDialog.setElements(list.toArray());
        if (resourceBundleSearchSelectionDialog.open() == 0) {
            ResourceBundleModel resourceBundleModel = (ResourceBundleModel)resourceBundleSearchSelectionDialog.getFirstResult();
            this.fResourceBundleField.setText(resourceBundleModel.getFullyQualifiedName(false));
            this.bundleSelectionChanged(resourceBundleModel);
        }
    }

    private List<ResourceBundleModel> getProjectBundles() {
        String string = this.fProjectField.getText();
        if (string.trim().length() == 0) {
            return this.fAllResourceBundles;
        }
        LinkedList<ResourceBundleModel> linkedList = new LinkedList<ResourceBundleModel>();
        for (ResourceBundleModel resourceBundleModel : this.fAllResourceBundles) {
            IJavaProject iJavaProject = ResourceSearch.getJavaProjectFromResourceBundleModel(resourceBundleModel);
            if (iJavaProject == null || !iJavaProject.getElementName().equals(string)) continue;
            linkedList.add(resourceBundleModel);
        }
        Collections.sort(linkedList, new Comparator<ResourceBundleModel>(){

            @Override
            public int compare(ResourceBundleModel resourceBundleModel, ResourceBundleModel resourceBundleModel2) {
                return resourceBundleModel.getFullyQualifiedName(false).compareTo(resourceBundleModel2.getFullyQualifiedName(false));
            }
        });
        return linkedList;
    }

    private AccessorConfiguration getAccessorConfiguration(ResourceBundleModel resourceBundleModel) {
        IJavaProject iJavaProject;
        if (resourceBundleModel != null && (iJavaProject = ResourceSearch.getJavaProjectFromResourceBundleModel(resourceBundleModel)) != null) {
            return this.fAccessorConfigurations.get(iJavaProject);
        }
        return null;
    }

    private HashMap<ResourceBundleModel, AccessorConfiguration> getBundelConfiguration() {
        List<ResourceBundleModel> list = this.getProjectBundles();
        HashMap<ResourceBundleModel, AccessorConfiguration> hashMap = new HashMap<ResourceBundleModel, AccessorConfiguration>();
        for (ResourceBundleModel resourceBundleModel : list) {
            IJavaProject iJavaProject = ResourceSearch.getJavaProjectFromResourceBundleModel(resourceBundleModel);
            if (iJavaProject == null) continue;
            hashMap.put(resourceBundleModel, this.getAccessorConfiguration(resourceBundleModel));
        }
        return hashMap;
    }

    private IJavaProject[] getProjectList() {
        if (this.fAccessorConfigurations != null) {
            Set<IJavaProject> set = this.fAccessorConfigurations.keySet();
            return set.toArray(new IJavaProject[set.size()]);
        }
        return null;
    }

    ResourceBundleModel getModelForString(String string) {
        return this.getModelForString(string, null);
    }

    ResourceBundleModel getModelForString(String string, IJavaProject iJavaProject) {
        if (string != null && string.trim().length() > 0 && this.fAllResourceBundles != null) {
            for (ResourceBundleModel resourceBundleModel : this.fAllResourceBundles) {
                String string2 = resourceBundleModel.getFullyQualifiedName(false);
                if (!string2.equals(string)) continue;
                if (iJavaProject != null) {
                    IJavaProject iJavaProject2 = ResourceSearch.getJavaProjectFromResourceBundleModel(resourceBundleModel);
                    if (iJavaProject2 == null || !iJavaProject2.equals(iJavaProject)) continue;
                    return resourceBundleModel;
                }
                return resourceBundleModel;
            }
        }
        return null;
    }

    static IJavaProject getJavaProjectFromResourceBundleModel(ResourceBundleModel resourceBundleModel) {
        IJavaProject iJavaProject;
        IFile iFile;
        IProject iProject;
        if (resourceBundleModel != null && (iProject = (iFile = (IFile)resourceBundleModel.getSelectedStorage()).getProject()) != null && (iJavaProject = JavaCore.create((IProject)iProject)) != null) {
            return iJavaProject;
        }
        return null;
    }

    void validate() {
        boolean bl;
        Object object;
        String string = null;
        String string2 = this.fProjectField.getText();
        Object object2 = null;
        if (string2.length() == 0) {
            string = Messages.getString("search.warning.project.empty", new Object[0]);
        }
        if (string == null) {
            object = this.getProjectList();
            if (object == null || ((IJavaProject[])object).length == 0) {
                string = Messages.getString("search.warning.project.notExists", new Object[0]);
            }
            if (string == null) {
                if (object != null) {
                    int n = 0;
                    while (n < ((Object)object).length) {
                        if (object[n].getElementName().equals(string2)) {
                            object2 = object[n];
                            break;
                        }
                        ++n;
                    }
                }
                if (object2 == null) {
                    string = Messages.getString("search.warning.project.notExists", new Object[0]);
                }
            }
        }
        if (string == null && ((object = this.getProjectBundles()) == null || object.size() == 0)) {
            string = Messages.getString("search.warning.project.noBundles", new Object[0]);
        }
        if (string == null) {
            object = this.fResourceBundleField.getText();
            if (((String)object).length() == 0) {
                string = Messages.getString("search.warning.bundle.empty", new Object[0]);
            }
            if (string == null) {
                ResourceBundleModel resourceBundleModel = this.getModelForString((String)object, (IJavaProject)object2);
                if (resourceBundleModel == null) {
                    string = Messages.getString("search.warning.bundle.notExists", new Object[0]);
                }
                if (string == null) {
                    AccessorConfiguration accessorConfiguration = this.fAccessorConfigurations.get(object2);
                    if (accessorConfiguration == null) {
                        string = Messages.getString("search.warning.bundle.config", new Object[0]);
                    }
                    if (string == null) {
                        IStatus iStatus;
                        ResourceBundleReference resourceBundleReference = this.getResourceBundleReference(resourceBundleModel, accessorConfiguration);
                        if (resourceBundleReference == null) {
                            string = Messages.getString("search.warning.configInvalid", new Object[0]);
                        }
                        if (string == null && accessorConfiguration != null && (iStatus = accessorConfiguration.validate(resourceBundleReference, true)).getSeverity() != 0) {
                            string = Messages.getString("search.warning.configInvalid", new Object[0]);
                        }
                    }
                }
            }
        }
        if (string != null) {
            this.fProblemMessage.showError(string);
        }
        boolean bl2 = bl = string == null;
        if (string == null) {
            this.fProblemMessage.hide();
            bl = this.fGeneralSearchButton.getSelection() ? this.fFindUnusedKeysButton.getSelection() || this.fFindUndefinedKeysButton.getSelection() || this.fFindIndeterminableKeysButton.getSelection() : this.fReferenceKeyField.getText().length() > 0;
        }
        this.fSearchContainer.setPerformActionEnabled(bl);
    }

    public boolean performAction() {
        int n;
        Object object;
        ResourceBundleReference resourceBundleReference;
        AccessorConfiguration accessorConfiguration;
        String string = this.fResourceBundleField.getText();
        ResourceBundleModel resourceBundleModel = this.getModelForString(string);
        if (resourceBundleModel == null) {
            String string2 = "Found no model for " + string;
            Throwable throwable = new Throwable().fillInStackTrace();
            Status status = new Status(4, JIntoUI.getID(), 4, string2, throwable);
            JIntoUI.getDefault().getLog().log((IStatus)status);
            return false;
        }
        this.saveSettings(string);
        IRunnableContext iRunnableContext = this.fSearchContainer.getRunnableContext();
        String string3 = null;
        JIntoSearchScope jIntoSearchScope = null;
        switch (this.fSearchContainer.getSelectedScope()) {
            case 0: {
                jIntoSearchScope = JIntoSearchScope.createWorkspaceScope(iRunnableContext);
                string3 = Messages.getString("search.result.scope.workspace", new Object[0]);
                break;
            }
            case 1: {
                accessorConfiguration = (IStructuredSelection)this.fSearchContainer.getSelection();
                jIntoSearchScope = JIntoSearchScope.createSelectionScope((IStructuredSelection)accessorConfiguration, iRunnableContext);
                string3 = Messages.getString("search.result.scope.selection", this.createSelectionStringForScope(jIntoSearchScope));
                break;
            }
            case 3: {
                jIntoSearchScope = JIntoSearchScope.createSelectedProjectsScope((IStructuredSelection)this.fSearchContainer.getSelection(), iRunnableContext);
                string3 = Messages.getString("search.result.scope.project", this.createSelectionStringForScope(jIntoSearchScope));
                break;
            }
            case 2: {
                resourceBundleReference = this.fSearchContainer.getSelectedWorkingSets();
                jIntoSearchScope = JIntoSearchScope.createWorkingSetScope((IWorkingSet[])resourceBundleReference, iRunnableContext);
                object = new StringBuffer();
                n = 0;
                while (n < ((ResourceBundleReference)resourceBundleReference).length) {
                    ((StringBuffer)object).append("'");
                    ((StringBuffer)object).append(resourceBundleReference[n].getName());
                    ((StringBuffer)object).append("'");
                    if (n < ((ResourceBundleReference)resourceBundleReference).length - 1) {
                        ((StringBuffer)object).append(", ");
                    }
                    ++n;
                }
                string3 = Messages.getString("search.result.scope.workingSet", ((StringBuffer)object).toString());
            }
        }
        accessorConfiguration = this.getAccessorConfiguration(resourceBundleModel);
        resourceBundleReference = this.getResourceBundleReference(resourceBundleModel, accessorConfiguration);
        object = null;
        if (this.fGeneralSearchButton.getSelection()) {
            n = this.fFindUnusedKeysButton.getSelection() ? 1 : 0;
            boolean bl = this.fFindUndefinedKeysButton.getSelection();
            boolean bl2 = this.fFindIndeterminableKeysButton.getSelection();
            object = new GeneralSearchRequestorAndResult(resourceBundleModel, n != 0, bl, bl2, string3);
        } else {
            object = new ReferenceSearchRequestorAndResult(this.fReferenceKeyField.getText(), string, string3);
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)new JIntoSearchQuery(resourceBundleReference, accessorConfiguration, jIntoSearchScope, (IJIntoSearchRequestor)object));
        return true;
    }

    private ResourceBundleReference getResourceBundleReference(ResourceBundleModel resourceBundleModel, AccessorConfiguration accessorConfiguration) {
        List list;
        if (resourceBundleModel != null && accessorConfiguration != null && (list = accessorConfiguration.getResourceBundleReferences()) != null) {
            for (ResourceBundleReference resourceBundleReference : list) {
                if (!resourceBundleReference.getFullyQualifiedName().equals(resourceBundleModel.getFullyQualifiedName(false))) continue;
                return resourceBundleReference;
            }
        }
        return null;
    }

    private String createSelectionStringForScope(JIntoSearchScope jIntoSearchScope) {
        StringBuffer stringBuffer = new StringBuffer();
        IJavaElement[] iJavaElementArray = jIntoSearchScope.getRootElements();
        int n = 0;
        while (n < iJavaElementArray.length) {
            stringBuffer.append("'");
            stringBuffer.append(iJavaElementArray[n].getElementName());
            stringBuffer.append("'");
            if (n < iJavaElementArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.fSearchContainer = iSearchPageContainer;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.fProjectField.getText().length() > 0 || this.fResourceBundleField.getText().length() > 0) {
                this.validate();
            } else {
                this.fSearchContainer.setPerformActionEnabled(false);
            }
        }
        super.setVisible(bl);
    }

    void openPropertyDialog() {
        PreferenceDialog preferenceDialog;
        IJavaProject iJavaProject = ResourceSearch.getJavaProjectFromResourceBundleModel(this.getModelForString(this.fResourceBundleField.getText()));
        if (iJavaProject != null && (preferenceDialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)iJavaProject, (String)"de.guhsoft.jinto.ui.propertyPages.JintoProjectPropertyPage", null, null)).open() == 0) {
            this.loadConfiguration(iJavaProject);
            this.validate();
        }
    }

    class ProblemMessage
    extends Canvas {
        private Label fWarning;
        private Link fLink;

        public ProblemMessage(Composite composite) {
            super(composite, 0);
            this.createContents();
            this.hide();
        }

        protected void hide() {
            this.showProblem("", null);
        }

        protected void showError(String string) {
            this.showProblem(string, JIntoUI.getImage("errorIcon"));
        }

        private void showProblem(String string, Image image) {
            this.fLink.setText(string);
            this.fWarning.setImage(image);
            this.setVisible(image != null);
            this.getParent().layout(true, true);
        }

        private void createContents() {
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.setLayoutData(gridData);
            this.fWarning = new Label((Composite)this, 0);
            this.fWarning.setImage(JIntoUI.getImage("errorIcon"));
            this.fWarning.pack();
            this.fLink = new Link((Composite)this, 0);
            this.fLink.setText("");
            this.fLink.setLayoutData((Object)new GridData(768));
            this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ResourceSearch.this.openPropertyDialog();
                }
            });
        }
    }

    public static class ResourceBundleContentProposal
    implements IContentProposal {
        private ResourceBundleModel fResourceBundle;

        public ResourceBundleContentProposal(ResourceBundleModel resourceBundleModel) {
            this.fResourceBundle = resourceBundleModel;
        }

        public ResourceBundleModel getResourceBundle() {
            return this.fResourceBundle;
        }

        public String getContent() {
            return this.fResourceBundle.getFullyQualifiedName(false);
        }

        public int getCursorPosition() {
            return this.getContent().length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            StringBuffer stringBuffer = new StringBuffer(this.fResourceBundle.getFullyQualifiedName(false));
            IJavaProject iJavaProject = ResourceSearch.getJavaProjectFromResourceBundleModel(this.fResourceBundle);
            if (iJavaProject != null) {
                stringBuffer.append(" - ");
                stringBuffer.append(iJavaProject.getElementName());
            }
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceBundleContentProposalProvider
    implements IContentProposalProvider {
        private List<ResourceBundleModel> fBundles = new LinkedList<ResourceBundleModel>();

        public void setBundles(List<ResourceBundleModel> list) {
            this.fBundles = list;
        }

        public IContentProposal[] getProposals(String string, int n) {
            ArrayList<ResourceBundleContentProposal> arrayList = new ArrayList<ResourceBundleContentProposal>(this.fBundles.size());
            for (ResourceBundleModel resourceBundleModel : this.fBundles) {
                String string2 = resourceBundleModel.getFullyQualifiedName(false);
                if (string2.length() <= string.length() || !string2.substring(0, string.length()).equalsIgnoreCase(string)) continue;
                arrayList.add(new ResourceBundleContentProposal(resourceBundleModel));
            }
            return arrayList.toArray(new IContentProposal[arrayList.size()]);
        }
    }
}

