/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search;

import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;

public class ResourceBundleSearchSelectionDialog
extends AbstractElementListSelectionDialog {
    private Object[] fElements;
    private CLabel fProject;

    public ResourceBundleSearchSelectionDialog(Shell shell, LabelProvider labelProvider) {
        super(shell, (ILabelProvider)labelProvider);
        this.setImage(JIntoUI.getDefault().getImageRegistry().get("resourceBundle"));
        this.setTitle(Messages.getString("search.bundleDialog.title", new Object[0]));
        this.setMessage(Messages.getString("search.bundleDialog.message", new Object[0]));
    }

    public void setElements(Object[] objectArray) {
        this.fElements = objectArray;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.createFilterText(composite2);
        final FilteredList filteredList = this.createFilteredList(composite2);
        ViewForm viewForm = new ViewForm(composite2, 0x800800);
        viewForm.setLayoutData((Object)new GridData(768));
        this.fProject = new CLabel((Composite)viewForm, 0x800000);
        this.fProject.setLayoutData((Object)new GridData(768));
        viewForm.setContent((Control)this.fProject);
        filteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object[] objectArray = filteredList.getSelection();
                if (objectArray != null && objectArray.length > 0) {
                    ResourceBundleSearchSelectionDialog.this.updateProject((ResourceBundleModel)objectArray[0]);
                } else {
                    ResourceBundleSearchSelectionDialog.this.updateProject(null);
                }
            }
        });
        this.setListElements(this.fElements);
        this.setSelection(this.getInitialElementSelections().toArray());
        return composite2;
    }

    void updateProject(ResourceBundleModel resourceBundleModel) {
        if (resourceBundleModel != null) {
            IJavaProject iJavaProject = this.getJavaProjectFromBundle(resourceBundleModel);
            if (iJavaProject != null) {
                this.fProject.setText(iJavaProject.getElementName());
                if (this.fProject.getImage() == null) {
                    this.fProject.setImage(JIntoUI.getImage("project"));
                }
            } else {
                this.fProject.setText("");
                this.fProject.setImage(null);
            }
        } else {
            this.fProject.setText("");
            this.fProject.setImage(null);
        }
    }

    IJavaProject getJavaProjectFromBundle(ResourceBundleModel resourceBundleModel) {
        IFile iFile;
        IJavaElement iJavaElement;
        if (resourceBundleModel != null && (iJavaElement = JavaCore.create((IResource)(iFile = (IFile)resourceBundleModel.getSelectedStorage()).getParent())) != null) {
            return iJavaElement.getJavaProject();
        }
        return null;
    }
}

