/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search;

import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.search.ResourceSearch;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleSearchLabelProvider
extends LabelProvider {
    private HashMap<ResourceBundleModel, AccessorConfiguration> fBundleConfigurations;
    private ProblemsLabelDecorator fProblemLabelProvider;

    public ResourceBundleSearchLabelProvider(HashMap<ResourceBundleModel, AccessorConfiguration> hashMap) {
        this.fBundleConfigurations = hashMap;
        this.fProblemLabelProvider = new ProblemsLabelDecorator(){

            protected int computeAdornmentFlags(Object object) {
                if (!ResourceBundleSearchLabelProvider.this.isValid((ResourceBundleModel)object)) {
                    return 32;
                }
                return 0;
            }
        };
    }

    public Image getImage(Object object) {
        Image image = JIntoUI.getImage("resourceBundle");
        if (object instanceof ResourceSearch.ResourceBundleContentProposal) {
            ResourceBundleModel resourceBundleModel = ((ResourceSearch.ResourceBundleContentProposal)object).getResourceBundle();
            if (resourceBundleModel != null) {
                return this.fProblemLabelProvider.decorateImage(image, (Object)resourceBundleModel);
            }
            return JIntoUI.getImage("warningIcon");
        }
        return this.fProblemLabelProvider.decorateImage(image, object);
    }

    public String getText(Object object) {
        if (object instanceof IContentProposal) {
            return ((IContentProposal)object).getLabel();
        }
        if (object instanceof ResourceBundleModel) {
            ResourceBundleModel resourceBundleModel = (ResourceBundleModel)object;
            return Util.convertFullyQualifiedNameIntoLeadingName((String)resourceBundleModel.getFullyQualifiedName(false));
        }
        return super.getText(object);
    }

    boolean isValid(ResourceBundleModel resourceBundleModel) {
        List list;
        AccessorConfiguration accessorConfiguration;
        if (this.fBundleConfigurations != null && (accessorConfiguration = this.fBundleConfigurations.get(resourceBundleModel)) != null && (list = accessorConfiguration.getResourceBundleReferences()) != null) {
            for (ResourceBundleReference resourceBundleReference : list) {
                if (!resourceBundleModel.getFullyQualifiedName(false).equals(resourceBundleReference.getFullyQualifiedName())) continue;
                return accessorConfiguration.validate(resourceBundleReference, true).getSeverity() == 0;
            }
        }
        return false;
    }
}

