/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search;

import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.search.IJIntoSearchRequestor;
import de.guhsoft.jinto.ui.search.JIntoSearchScope;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class JIntoSearchQuery
implements ISearchQuery {
    private HashMap<String, ClassReference> fClassAndMethodReferences = new HashMap();
    private JIntoSearchScope fScope;
    IJIntoSearchRequestor fSearchRequestor;
    private JIntoASTVisitor fVisitor;
    private AccessorConfiguration fAccessorConfiguration;

    public JIntoSearchQuery(ResourceBundleReference resourceBundleReference, AccessorConfiguration accessorConfiguration, JIntoSearchScope jIntoSearchScope, IJIntoSearchRequestor iJIntoSearchRequestor) {
        this.fAccessorConfiguration = accessorConfiguration;
        List list = resourceBundleReference.getAccessorClasses();
        for (ClassReference classReference : list) {
            this.fClassAndMethodReferences.put(classReference.getFullyQualifiedTypeName(), classReference);
        }
        this.fScope = jIntoSearchScope;
        this.fSearchRequestor = iJIntoSearchRequestor;
        this.fSearchRequestor.setQuery(this);
    }

    public String getLabel() {
        return Messages.getString("search.label", new Object[0]);
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fSearchRequestor;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        this.fSearchRequestor.beginSearch();
        int n = this.fScope.size();
        int n2 = n + 2;
        iProgressMonitor.beginTask(this.fSearchRequestor.toString(), n2);
        ASTParser aSTParser = ASTParser.newParser((int)3);
        iProgressMonitor.worked(1);
        String string = String.valueOf(n);
        int n3 = 1;
        Iterator<IJavaElement> iterator = this.fScope.iterator();
        while (iterator.hasNext()) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iterator.next();
            iProgressMonitor.subTask(Messages.getString("search.label.monitor.scan", String.valueOf(n3), string, iCompilationUnit.getElementName()));
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, n3, 4);
            subProgressMonitor.beginTask("", n);
            aSTParser.setSource(iCompilationUnit);
            aSTParser.setResolveBindings(true);
            aSTParser.createAST((IProgressMonitor)subProgressMonitor).accept(this.getVisitor(iCompilationUnit));
            if (iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            iProgressMonitor.worked(1);
            ++n3;
        }
        iProgressMonitor.worked(1);
        this.fSearchRequestor.endSearch();
        iProgressMonitor.worked(1);
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }

    private ASTVisitor getVisitor(ICompilationUnit iCompilationUnit) {
        if (this.fVisitor == null) {
            this.fVisitor = new JIntoASTVisitor();
        }
        this.fVisitor.setCompilationUnit(iCompilationUnit);
        return this.fVisitor;
    }

    MethodReference getMethodReferenceFromNode(MethodInvocation methodInvocation, ClassReference classReference) {
        List list;
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        IMethod iMethod = (IMethod)iMethodBinding.getJavaElement();
        if (this.fAccessorConfiguration != null && (list = classReference.getMethodReferences()) != null) {
            for (MethodReference methodReference : list) {
                try {
                    IMethod iMethod2 = this.fAccessorConfiguration.resolve(methodReference);
                    if (iMethod2 == null || !iMethod.equals(iMethod2)) continue;
                    return methodReference;
                }
                catch (JavaModelException javaModelException) {
                    StringBuffer stringBuffer = new StringBuffer("Error while resolving MethodReference '");
                    stringBuffer.append(methodReference.getDisplayString());
                    stringBuffer.append("'");
                    Status status = new Status(4, JIntoUI.getID(), stringBuffer.toString(), (Throwable)javaModelException);
                    JIntoUI.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return null;
    }

    ClassReference getClassReferenceForQualifiedName(MethodInvocation methodInvocation) {
        Expression expression;
        ITypeBinding iTypeBinding = null;
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (iMethodBinding != null) {
            iTypeBinding = iMethodBinding.getDeclaringClass();
        }
        if (iTypeBinding == null && (expression = methodInvocation.getExpression()) != null) {
            iTypeBinding = expression.resolveTypeBinding();
        }
        while (iTypeBinding != null) {
            expression = this.fClassAndMethodReferences.get(iTypeBinding.getQualifiedName());
            if (expression != null) {
                return expression;
            }
            iTypeBinding = iTypeBinding.getSuperclass();
        }
        return null;
    }

    private class JIntoASTVisitor
    extends ASTVisitor {
        private ICompilationUnit fCompilationUnit;

        JIntoASTVisitor() {
        }

        public boolean visit(MethodInvocation methodInvocation) {
            MethodReference methodReference;
            ClassReference classReference = JIntoSearchQuery.this.getClassReferenceForQualifiedName(methodInvocation);
            if (classReference != null && (methodReference = JIntoSearchQuery.this.getMethodReferenceFromNode(methodInvocation, classReference)) != null) {
                JIntoSearchQuery.this.fSearchRequestor.accepSearchMatch(new Object[]{methodInvocation, methodReference, this.fCompilationUnit});
            }
            return true;
        }

        public void setCompilationUnit(ICompilationUnit iCompilationUnit) {
            this.fCompilationUnit = iCompilationUnit;
        }
    }
}

