/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.properties;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfigurationManager;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import de.guhsoft.jinto.core.util.CodeAnalyser;
import de.guhsoft.jinto.core.util.ResourceBundleUtil;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.properties.AccessorConfigurationContentProvider;
import de.guhsoft.jinto.ui.properties.AccessorConfigurationLabelProvider;
import de.guhsoft.jinto.ui.properties.AccessorMethodDialog;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIntoProjectPropertyPage
extends PropertyPage {
    public static final String PROP_ID = "de.guhsoft.jinto.ui.propertyPages.JintoProjectPropertyPage";
    private IJavaProject fJavaProject;
    private TreeViewer fTreeViewer;
    private Button fAddBundleButton;
    private Button fAddAccessorButton;
    private Button fConfigAccessorButton;
    private Button fRemoveButton;
    private List<ResourceBundleModel> fProjectResourceBundles;
    private AccessorConfiguration fAccessorConfiguration;
    private boolean fIsDirty;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("property.label", new Object[0]));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        try {
            this.fAccessorConfiguration = AccessorConfigurationManager.getInstance().getAccessorConfiguration(this.fJavaProject);
        }
        catch (CoreException coreException) {
            Status status = new Status(4, JIntoUI.getID(), "Error while create AccessorConfiguration...", (Throwable)coreException);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("errorDialog.title", new Object[0]), (String)Messages.getString("property.error.load", new Object[0]), (IStatus)status);
        }
        this.createViewer(composite2);
        this.createButtons(composite2);
        this.initialize();
        return composite2;
    }

    private void createViewer(Composite composite) {
        this.fTreeViewer = new TreeViewer(composite, 2308);
        this.fTreeViewer.setContentProvider((IContentProvider)new AccessorConfigurationContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new AccessorConfigurationLabelProvider(this.fAccessorConfiguration, true));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 200;
        gridData.heightHint = 200;
        this.fTreeViewer.getTree().setLayoutData((Object)gridData);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                JIntoProjectPropertyPage.this.enableButtons();
            }
        });
        this.fTreeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                LabelProvider labelProvider = (LabelProvider)((StructuredViewer)viewer).getLabelProvider();
                String string = labelProvider.getText(object);
                String string2 = labelProvider.getText(object2);
                return string.compareTo(string2);
            }
        });
        this.fTreeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127) {
                    JIntoProjectPropertyPage.this.removePressed();
                }
            }
        });
    }

    private void createButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1040));
        this.fAddBundleButton = new Button(composite2, 8);
        this.fAddBundleButton.setText(Messages.getString("property.button.chooseBundle", new Object[0]));
        this.fAddBundleButton.setLayoutData((Object)new GridData(768));
        this.fAddBundleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JIntoProjectPropertyPage.this.addBundlePressed();
            }
        });
        this.fAddAccessorButton = new Button(composite2, 8);
        this.fAddAccessorButton.setText(Messages.getString("property.button.chooseAccessor", new Object[0]));
        this.fAddAccessorButton.setLayoutData((Object)new GridData(768));
        this.fAddAccessorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JIntoProjectPropertyPage.this.addAccessorPressed();
            }
        });
        this.fConfigAccessorButton = new Button(composite2, 8);
        this.fConfigAccessorButton.setText(Messages.getString("property.button.configAccessor", new Object[0]));
        this.fConfigAccessorButton.setLayoutData((Object)new GridData(768));
        this.fConfigAccessorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JIntoProjectPropertyPage.this.configAccessorPressed();
            }
        });
        new Label(composite2, 0).setVisible(false);
        this.fRemoveButton = new Button(composite2, 8);
        this.fRemoveButton.setText(Messages.getString("property.button.remove", new Object[0]));
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JIntoProjectPropertyPage.this.removePressed();
            }
        });
    }

    private void initialize() {
        this.fProjectResourceBundles = ResourceBundleUtil.searchForResourceBundles((IJavaProject)this.fJavaProject);
        this.loadAndSetConfiguration();
        this.enableButtons();
        this.fTreeViewer.expandAll();
        this.fIsDirty = false;
    }

    private void loadAndSetConfiguration() {
        List list;
        if (this.fAccessorConfiguration != null && (list = this.fAccessorConfiguration.getResourceBundleReferences(true)) != null) {
            this.refreshTree(list);
        }
    }

    void refreshTree() {
        this.refreshTree(null);
    }

    void refreshTree(List<ResourceBundleReference> list) {
        ((AccessorConfigurationLabelProvider)this.fTreeViewer.getLabelProvider()).resetErrorList();
        if (list != null) {
            this.fTreeViewer.setInput(list);
        } else {
            this.fTreeViewer.refresh();
        }
        this.fTreeViewer.expandAll();
        LinkedList<String> linkedList = new LinkedList<String>();
        HashMap<Object, IStatus> hashMap = ((AccessorConfigurationLabelProvider)this.fTreeViewer.getLabelProvider()).getErrors();
        if (hashMap.size() > 0) {
            Object object;
            Object object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = object2.next().getValue();
                if (object == null || object.getMessage().trim().length() <= 0 || linkedList.contains(object.getMessage())) continue;
                linkedList.add(object.getMessage());
            }
            object2 = new StringBuffer();
            object = linkedList.iterator();
            while (object.hasNext()) {
                ((StringBuffer)object2).append((String)object.next());
                if (!object.hasNext()) continue;
                ((StringBuffer)object2).append("; ");
            }
            this.setMessage(((StringBuffer)object2).toString(), 2);
        } else {
            this.setMessage(null, 2);
        }
        this.enableButtons();
    }

    void enableButtons() {
        List<ResourceBundleModel> list = this.getProjectBundleSelectionList();
        this.fAddBundleButton.setEnabled(list != null && list.size() > 0);
        Object object = this.getTreeViewerSelection();
        if (object != null) {
            if (object instanceof ResourceBundleReference) {
                this.fAddAccessorButton.setEnabled(true);
                this.fRemoveButton.setEnabled(true);
                this.fConfigAccessorButton.setEnabled(false);
            } else if (object instanceof ClassReference) {
                this.fAddAccessorButton.setEnabled(true);
                this.fConfigAccessorButton.setEnabled(true);
                this.fRemoveButton.setEnabled(true);
            } else if (object instanceof MethodReference) {
                this.fConfigAccessorButton.setEnabled(false);
                this.fAddAccessorButton.setEnabled(false);
                this.fRemoveButton.setEnabled(false);
            }
        } else {
            this.fAddAccessorButton.setEnabled(false);
            this.fConfigAccessorButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
        }
    }

    List<ResourceBundleModel> getProjectBundleSelectionList() {
        List<ResourceBundleReference> list;
        LinkedList<ResourceBundleModel> linkedList = new LinkedList<ResourceBundleModel>();
        if (this.fProjectResourceBundles != null && (list = this.getTreeViewerInput()).size() > 0) {
            for (ResourceBundleModel resourceBundleModel : this.fProjectResourceBundles) {
                boolean bl = false;
                for (ResourceBundleReference resourceBundleReference : list) {
                    if (!resourceBundleModel.getFullyQualifiedName(false).equals(resourceBundleReference.getFullyQualifiedName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                linkedList.add(resourceBundleModel);
            }
            return linkedList;
        }
        return this.fProjectResourceBundles;
    }

    List<ResourceBundleReference> getTreeViewerInput() {
        Object[] objectArray;
        LinkedList<ResourceBundleReference> linkedList = new LinkedList<ResourceBundleReference>();
        IStructuredContentProvider iStructuredContentProvider = (IStructuredContentProvider)this.fTreeViewer.getContentProvider();
        if (iStructuredContentProvider != null && (objectArray = iStructuredContentProvider.getElements(this.fTreeViewer.getInput())) != null) {
            int n = 0;
            while (n < objectArray.length) {
                linkedList.add((ResourceBundleReference)objectArray[n]);
                ++n;
            }
        }
        return linkedList;
    }

    private Object getTreeViewerSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty()) {
            return iStructuredSelection.getFirstElement();
        }
        return null;
    }

    void addBundlePressed() {
        this.chooseBundle();
    }

    void addAccessorPressed() {
        Object object = this.getTreeViewerSelection();
        if (object != null) {
            ClassReference classReference;
            ResourceBundleReference resourceBundleReference = null;
            if (object instanceof ResourceBundleReference) {
                resourceBundleReference = (ResourceBundleReference)object;
            } else if (object instanceof ClassReference) {
                resourceBundleReference = ((ClassReference)object).getResourceBundleReference();
            }
            if (resourceBundleReference != null && (classReference = this.chooseAccessor(resourceBundleReference)) != null) {
                resourceBundleReference.getAccessorClasses().add(classReference);
                this.refreshTree();
                this.fIsDirty = true;
            }
        }
    }

    void configAccessorPressed() {
        Object object = this.getTreeViewerSelection();
        if (object != null) {
            ClassReference classReference = null;
            if (object instanceof ClassReference) {
                classReference = (ClassReference)object;
            } else if (object instanceof MethodReference) {
                classReference = ((MethodReference)object).getClassReference();
            }
            this.configAccessor(classReference);
            this.refreshTree();
            this.fIsDirty = true;
        }
    }

    void removePressed() {
        Object object = this.getTreeViewerSelection();
        if (object != null && (object instanceof ResourceBundleReference || object instanceof ClassReference)) {
            List<ResourceBundleReference> list = this.remove(object);
            this.refreshTree(list);
            this.fIsDirty = true;
        }
    }

    private List<ResourceBundleReference> remove(Object object) {
        ResourceBundleReference resourceBundleReference;
        ResourceBundleReference resourceBundleReference2 = null;
        List<ResourceBundleReference> list = this.getTreeViewerInput();
        if (object instanceof ResourceBundleReference) {
            resourceBundleReference2 = this.getPreviousElement((ResourceBundleReference)object);
            list.remove(object);
        } else if (object instanceof ClassReference && (resourceBundleReference = ((ClassReference)object).getResourceBundleReference()) != null) {
            resourceBundleReference2 = this.getPreviousElement((ClassReference)object);
            if (resourceBundleReference2 == null) {
                resourceBundleReference2 = resourceBundleReference;
            }
            resourceBundleReference.getAccessorClasses().remove(object);
        }
        if (resourceBundleReference2 != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)resourceBundleReference2));
        }
        return list;
    }

    TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    private ResourceBundleReference getPreviousElement(ResourceBundleReference resourceBundleReference) {
        List<ResourceBundleReference> list;
        if (resourceBundleReference != null && (list = this.getTreeViewerInput()).size() > 1) {
            Collections.sort(list, new Comparator<ResourceBundleReference>(){

                @Override
                public int compare(ResourceBundleReference resourceBundleReference, ResourceBundleReference resourceBundleReference2) {
                    return JIntoProjectPropertyPage.this.getTreeViewer().getSorter().compare((Viewer)JIntoProjectPropertyPage.this.getTreeViewer(), (Object)resourceBundleReference, (Object)resourceBundleReference2);
                }
            });
            int n = 0;
            while (n < list.size()) {
                ResourceBundleReference resourceBundleReference2 = list.get(n);
                if (resourceBundleReference2.equals(resourceBundleReference)) {
                    int n2 = n - 1;
                    int n3 = n + 1;
                    if (n2 > -1) {
                        return list.get(n2);
                    }
                    if (n3 > -1 && n + 1 < list.size()) {
                        return list.get(n3);
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private ClassReference getPreviousElement(ClassReference classReference) {
        LinkedList linkedList = new LinkedList(classReference.getResourceBundleReference().getAccessorClasses());
        if (linkedList.size() > 1) {
            Collections.sort(linkedList, new Comparator<ClassReference>(){

                @Override
                public int compare(ClassReference classReference, ClassReference classReference2) {
                    return JIntoProjectPropertyPage.this.getTreeViewer().getSorter().compare((Viewer)JIntoProjectPropertyPage.this.getTreeViewer(), (Object)classReference, (Object)classReference2);
                }
            });
            int n = 0;
            while (n < linkedList.size()) {
                ClassReference classReference2 = (ClassReference)linkedList.get(n);
                if (classReference2.equals(classReference)) {
                    int n2 = n - 1;
                    int n3 = n + 1;
                    if (n2 > -1) {
                        return (ClassReference)linkedList.get(n2);
                    }
                    if (n3 > -1 && n + 1 < linkedList.size()) {
                        return (ClassReference)linkedList.get(n3);
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private void chooseBundle() {
        Object object;
        ResourceBundleReference resourceBundleReference;
        ClassReference classReference;
        AccessorConfigurationLabelProvider accessorConfigurationLabelProvider = new AccessorConfigurationLabelProvider(this.fAccessorConfiguration);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)accessorConfigurationLabelProvider);
        elementListSelectionDialog.setImage(JIntoUI.getDefault().getImageRegistry().get("resourceBundle"));
        elementListSelectionDialog.setTitle(Messages.getString("property.dialog.bundleSelection.title", new Object[0]));
        elementListSelectionDialog.setMessage(Messages.getString("property.dialog.bundleSelection.message", new Object[0]));
        elementListSelectionDialog.setElements(this.getProjectBundleSelectionList().toArray());
        if (elementListSelectionDialog.open() == 0 && (classReference = this.chooseAccessor(resourceBundleReference = new ResourceBundleReference((ResourceBundleModel)(object = elementListSelectionDialog.getFirstResult())))) != null) {
            LinkedList<ClassReference> linkedList = new LinkedList<ClassReference>();
            linkedList.add(classReference);
            resourceBundleReference.setAccessorClasses(linkedList);
            this.addBundle(resourceBundleReference);
        }
    }

    private ClassReference chooseAccessor(ResourceBundleReference resourceBundleReference) {
        if (resourceBundleReference != null) {
            try {
                IType iType;
                ClassReference classReference;
                int n;
                Object[] objectArray;
                IRunnableContext iRunnableContext = null;
                int n2 = 2;
                int n3 = 11;
                IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fJavaProject}, (int)n3);
                SelectionDialog selectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), iRunnableContext, (IJavaSearchScope)iJavaSearchScope, (int)n2, (boolean)false, (String)"", (TypeSelectionExtension)new AccessorTypeSelectionExtension(resourceBundleReference.getAccessorClasses()));
                selectionDialog.setTitle(Messages.getString("property.dialog.accessorSelection.title", new Object[0]));
                selectionDialog.setMessage(Messages.getString("property.dialog.accessorSelection.message", new Object[0]));
                if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && (n = this.configAccessor(classReference = new ClassReference(resourceBundleReference, iType = (IType)objectArray[0]))) == 0) {
                    return classReference;
                }
            }
            catch (JavaModelException javaModelException) {
                Status status = new Status(4, JIntoUI.getID(), 4, "Error while choose accessor class", (Throwable)javaModelException);
                JIntoUI.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    private int configAccessor(ClassReference classReference) {
        List list = classReference.getMethodReferences();
        AccessorMethodDialog accessorMethodDialog = new AccessorMethodDialog(this.getShell(), classReference, list, this.fAccessorConfiguration);
        int n = accessorMethodDialog.open();
        if (n == 0) {
            classReference.setMethodReferences(accessorMethodDialog.getValue());
        }
        return n;
    }

    private void addBundle(ResourceBundleReference resourceBundleReference) {
        if (resourceBundleReference != null) {
            List<ResourceBundleReference> list = this.getTreeViewerInput();
            list.add(resourceBundleReference);
            this.refreshTree(list);
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)resourceBundleReference));
            this.fIsDirty = true;
        }
    }

    public boolean performOk() {
        this.saveConfiguration();
        if (this.fIsDirty) {
            IProject iProject;
            int n = JIntoCore.getPreferences().getInt(IPreferenceConstants.PROBLEMS_JAVA_NON_EXISTING_KEY.key(), ((Integer)IPreferenceConstants.PROBLEMS_JAVA_NON_EXISTING_KEY.defaultValue()).intValue());
            if (n != JIntoCore.SEVERITY_IGNORE && (iProject = this.fJavaProject.getProject()) != null) {
                new BuildJob(iProject).schedule();
            }
            this.fIsDirty = false;
        }
        return super.performOk();
    }

    protected void performApply() {
        if (this.performOk()) {
            this.loadAndSetConfiguration();
            this.fTreeViewer.expandAll();
        }
    }

    protected void performDefaults() {
        this.initialize();
    }

    private void saveConfiguration() {
        try {
            List<ResourceBundleReference> list = this.getTreeViewerInput();
            AccessorConfigurationManager.getInstance().save(this.fAccessorConfiguration, list);
        }
        catch (IOException iOException) {
            Status status = new Status(4, JIntoUI.getID(), 4, Messages.getString("property.error.save.store", new Object[0]), (Throwable)iOException);
            JIntoUI.getDefault().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("property.error.save", new Object[0]), (IStatus)status);
        }
    }

    public void setElement(IAdaptable iAdaptable) {
        IProject iProject = (IProject)iAdaptable.getAdapter(IResource.class);
        this.fJavaProject = JavaCore.create((IProject)iProject);
    }

    public IAdaptable getElement() {
        return this.fJavaProject;
    }

    IType getType(ClassReference classReference) {
        try {
            return this.fAccessorConfiguration.resolve(classReference);
        }
        catch (JavaModelException javaModelException) {
            JIntoUI.getDefault().getLog().log((IStatus)new Status(4, JIntoUI.getID(), "Error while validate Classreference...", (Throwable)javaModelException));
            return null;
        }
    }

    public IStatus validate(ClassReference classReference) {
        if (classReference != null) {
            return this.fAccessorConfiguration.validate(classReference);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccessorTypeSelectionExtension
    extends TypeSelectionExtension
    implements ITypeInfoFilterExtension {
        private List<ClassReference> fAccessorList;
        private ISelectionStatusValidator fValidator;

        public AccessorTypeSelectionExtension(List<ClassReference> list) {
            this.fAccessorList = list;
            this.fValidator = new ISelectionStatusValidator(){

                public IStatus validate(Object[] objectArray) {
                    if (objectArray != null) {
                        int n = 0;
                        while (n < objectArray.length) {
                            if (objectArray[n] instanceof IType) {
                                try {
                                    if (CodeAnalyser.hasValidMethods((IType)((IType)objectArray[n]))) {
                                        return Status.OK_STATUS;
                                    }
                                }
                                catch (JavaModelException javaModelException) {
                                    StringBuffer stringBuffer = new StringBuffer("Error while analysing type '");
                                    stringBuffer.append(((IType)objectArray[n]).getFullyQualifiedName());
                                    stringBuffer.append("'");
                                    JIntoUI.getDefault().getLog().log((IStatus)new Status(4, JIntoUI.getID(), stringBuffer.toString(), (Throwable)javaModelException));
                                }
                            }
                            ++n;
                        }
                    }
                    return new Status(4, JIntoUI.getID(), Messages.getString("property.dialog.accessorSelection.error.methods", new Object[0]));
                }
            };
        }

        public ITypeInfoFilterExtension getFilterExtension() {
            return this;
        }

        public ISelectionStatusValidator getSelectionValidator() {
            return this.fValidator;
        }

        public boolean select(ITypeInfoRequestor iTypeInfoRequestor) {
            if (this.fAccessorList != null && this.fAccessorList.size() > 0) {
                for (ClassReference classReference : this.fAccessorList) {
                    StringBuffer stringBuffer = new StringBuffer(iTypeInfoRequestor.getPackageName());
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(".");
                    }
                    stringBuffer.append(iTypeInfoRequestor.getTypeName());
                    if (!classReference.getFullyQualifiedTypeName().equalsIgnoreCase(stringBuffer.toString().trim())) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static final class BuildJob
    extends Job {
        private IProject fProject;

        BuildJob(IProject iProject) {
            super(Messages.getString("property.dialog.buildJob.name", new Object[0]));
            this.fProject = iProject;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                try {
                    iProgressMonitor.beginTask(Messages.getString("property.dialog.buildJob.taskName", this.fProject.getName()), 2);
                    this.fProject.build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    IProject[] iProjectArray = this.fProject.getReferencingProjects();
                    int n = 0;
                    while (n < iProjectArray.length) {
                        iProjectArray[n].build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    IStatus iStatus = coreException.getStatus();
                    iProgressMonitor.done();
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    iProgressMonitor.done();
                    return iStatus;
                }
            }
            finally {
                iProgressMonitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == object;
        }
    }
}

