/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.properties;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ParameterReference;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorConfigurationLabelProvider
extends LabelProvider {
    private JavaElementLabelProvider fJavaElementLabelProvider;
    private ConfigurationProblemLabelDecorator fProblemLabelProvider;
    private int style = 2304;
    private int methodStyle = JavaElementLabelProvider.SHOW_DEFAULT | 0x100;
    private AccessorConfiguration fAccessorConfiguration;
    private boolean fDoValidate;
    private HashMap<Object, IStatus> fErrors;

    public AccessorConfigurationLabelProvider(AccessorConfiguration accessorConfiguration) {
        this(accessorConfiguration, false);
    }

    public AccessorConfigurationLabelProvider(AccessorConfiguration accessorConfiguration, boolean bl) {
        this.fAccessorConfiguration = accessorConfiguration;
        this.fDoValidate = bl;
        this.fJavaElementLabelProvider = new JavaElementLabelProvider(this.style);
        this.fProblemLabelProvider = new ConfigurationProblemLabelDecorator();
        this.fErrors = new HashMap();
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof ResourceBundleReference) {
            image = JIntoUI.getDefault().getImageRegistry().get("resourceBundle");
        } else if (object instanceof ClassReference) {
            IType iType = this.getType((ClassReference)object);
            if (iType != null) {
                image = this.fJavaElementLabelProvider.getImage((Object)iType);
            }
            if (image == null) {
                image = JIntoUI.getImage("classObject");
            }
        } else if (object instanceof MethodReference) {
            IMethod iMethod = this.getMethod((MethodReference)object);
            if (iMethod != null) {
                this.fJavaElementLabelProvider.turnOff(this.style);
                this.fJavaElementLabelProvider.turnOn(this.methodStyle);
                image = this.fJavaElementLabelProvider.getImage((Object)iMethod);
                this.fJavaElementLabelProvider.turnOff(this.methodStyle);
                this.fJavaElementLabelProvider.turnOn(this.style);
            }
            if (image == null) {
                image = JIntoUI.getImage("publicMethod");
            }
        } else if (object instanceof ParameterReference) {
            ParameterReference parameterReference = (ParameterReference)object;
            image = this.fJavaElementLabelProvider.getImage((Object)parameterReference.getFullyQualifiedParameterType());
            if (image == null) {
                image = parameterReference.isValidType() ? JIntoUI.getDefault().getImageRegistry().get("parameter") : JIntoUI.getDefault().getImageRegistry().get("nonvalidParameter");
            }
        } else {
            image = object instanceof ResourceBundleModel ? JIntoUI.getDefault().getImageRegistry().get("resourceBundle") : JIntoUI.getDefault().getImageRegistry().get("warningIcon");
        }
        if (this.fDoValidate) {
            return this.fProblemLabelProvider.decorateImage(image, object);
        }
        return image;
    }

    public String getText(Object object) {
        if (object instanceof ResourceBundleReference) {
            return Util.convertFullyQualifiedNameIntoLeadingName((String)((ResourceBundleReference)object).getFullyQualifiedName());
        }
        if (object instanceof ClassReference) {
            IType iType = this.getType((ClassReference)object);
            if (iType != null) {
                return this.fJavaElementLabelProvider.getText((Object)iType);
            }
            return Util.convertFullyQualifiedNameIntoLeadingName((String)((ClassReference)object).getFullyQualifiedTypeName());
        }
        if (object instanceof MethodReference) {
            IMethod iMethod = this.getMethod((MethodReference)object);
            if (iMethod != null) {
                this.fJavaElementLabelProvider.turnOff(this.style);
                this.fJavaElementLabelProvider.turnOn(this.methodStyle);
                String string = this.fJavaElementLabelProvider.getText((Object)iMethod);
                this.fJavaElementLabelProvider.turnOff(this.methodStyle);
                this.fJavaElementLabelProvider.turnOn(this.style);
                return string;
            }
            return ((MethodReference)object).getDisplayString();
        }
        if (object instanceof ParameterReference) {
            return ((ParameterReference)object).getDisplayString();
        }
        if (object instanceof ResourceBundleModel) {
            ResourceBundleModel resourceBundleModel = (ResourceBundleModel)object;
            return Util.convertFullyQualifiedNameIntoLeadingName((String)resourceBundleModel.getFullyQualifiedName(false));
        }
        return super.getText(object);
    }

    private IType getType(ClassReference classReference) {
        try {
            return this.fAccessorConfiguration.resolve(classReference);
        }
        catch (JavaModelException javaModelException) {
            JIntoUI.getDefault().getLog().log((IStatus)new Status(4, JIntoUI.getID(), "Error while resolving ClassReference to IType...", (Throwable)javaModelException));
            return null;
        }
    }

    private IMethod getMethod(MethodReference methodReference) {
        try {
            return this.fAccessorConfiguration.resolve(methodReference);
        }
        catch (JavaModelException javaModelException) {
            JIntoUI.getDefault().getLog().log((IStatus)new Status(4, JIntoUI.getID(), "Error while resolving MethodReference to IMethod...", (Throwable)javaModelException));
            return null;
        }
    }

    AccessorConfiguration getAccessorConfiguration() {
        return this.fAccessorConfiguration;
    }

    public void dispose() {
        this.fJavaElementLabelProvider.dispose();
        this.fProblemLabelProvider.dispose();
        super.dispose();
    }

    public void resetErrorList() {
        this.fErrors.clear();
        this.fProblemLabelProvider.resetStateList();
    }

    public HashMap<Object, IStatus> getErrors() {
        return this.fErrors;
    }

    public void addError(Object object, IStatus iStatus) {
        this.fErrors.put(object, iStatus);
    }

    public class ConfigurationProblemLabelDecorator
    extends ProblemsLabelDecorator {
        private IStatus fStatus;
        private HashMap<Object, IStatus> fCheckedElements = new HashMap();

        protected int computeAdornmentFlags(Object object) {
            Object object2 = object instanceof ResourceBundleReference ? this.validate((ResourceBundleReference)object) : (object instanceof ClassReference ? this.validate((ClassReference)object) : (object instanceof MethodReference ? this.validate((MethodReference)object) : new Status(2, JIntoUI.getID(), Messages.getString("property.warning.unknown", new Object[0]))));
            if (4 == object2.getSeverity() || 2 == object2.getSeverity()) {
                AccessorConfigurationLabelProvider.this.addError(object, (IStatus)object2);
                return 32;
            }
            this.fCheckedElements.put(object, (IStatus)object2);
            return 0;
        }

        public IStatus getState() {
            return this.fStatus;
        }

        void resetStateList() {
            this.fCheckedElements.clear();
        }

        private IStatus validate(ResourceBundleReference resourceBundleReference) {
            IStatus iStatus = AccessorConfigurationLabelProvider.this.getAccessorConfiguration().validate(resourceBundleReference);
            this.fCheckedElements.put(resourceBundleReference, iStatus);
            MultiStatus multiStatus = new MultiStatus(JIntoCore.getID(), 0, this.getStatusMessage(iStatus), null);
            multiStatus.add(iStatus);
            for (ClassReference classReference : resourceBundleReference.getAccessorClasses()) {
                IStatus iStatus2 = this.validate(classReference);
                multiStatus.add(iStatus2);
            }
            iStatus = multiStatus;
            return iStatus;
        }

        private IStatus validate(ClassReference classReference) {
            IStatus iStatus = this.fCheckedElements.get(classReference);
            if (iStatus == null) {
                iStatus = AccessorConfigurationLabelProvider.this.getAccessorConfiguration().validate(classReference);
                this.fCheckedElements.put(classReference, iStatus);
            }
            MultiStatus multiStatus = new MultiStatus(JIntoCore.getID(), 0, this.getStatusMessage(iStatus), null);
            multiStatus.add(iStatus);
            for (MethodReference methodReference : classReference.getMethodReferences()) {
                IStatus iStatus2 = this.validate(methodReference);
                multiStatus.add(iStatus2);
            }
            iStatus = multiStatus;
            return iStatus;
        }

        private IStatus validate(MethodReference methodReference) {
            IStatus iStatus = this.fCheckedElements.get(methodReference);
            if (iStatus == null) {
                iStatus = AccessorConfigurationLabelProvider.this.getAccessorConfiguration().validate(methodReference);
            }
            return iStatus;
        }

        private String getStatusMessage(IStatus iStatus) {
            if (4 == iStatus.getSeverity() || 2 == iStatus.getSeverity()) {
                return iStatus.getMessage();
            }
            return "";
        }
    }
}

