/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.preferences;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.ProblemsCheckingJob;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import de.guhsoft.jinto.ui.preferences.ColorEditor;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static Color virtualTextColor = new Color((Device)Display.getCurrent(), JIntoCore.getPreferences().getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.defaultValue()).intValue()), JIntoCore.getPreferences().getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.defaultValue()).intValue()), JIntoCore.getPreferences().getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.defaultValue()).intValue()));
    private Button saveEmptyValuesButton;
    private Button showVirtualValuesButton;
    private ColorEditor colorButton;
    private List<ProblemClass> problemClassList;
    private IWorkbench fWorkbench;
    Combo fOutlineSeparatorCombo;
    private Button fIncludeHeaders;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createGeneralContent(composite2);
        this.createEmptyValuesContent(composite2);
        this.createProblemsContent(composite2);
        return composite2;
    }

    private void createGeneralContent(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.getString("prefs.general.title", new Object[0]));
        Label label = new Label((Composite)group, 16384);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label.setText(Messages.getString("prefs.general.outline.label", new Object[0]));
        this.fOutlineSeparatorCombo = new Combo((Composite)group, 2052);
        this.fOutlineSeparatorCombo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fOutlineSeparatorCombo.setTextLimit(1);
        this.fOutlineSeparatorCombo.add(".");
        this.fOutlineSeparatorCombo.add("_");
        this.fOutlineSeparatorCombo.add(":");
        this.fOutlineSeparatorCombo.add(";");
        this.fOutlineSeparatorCombo.setText(String.valueOf((char)JIntoCore.getPreferences().getInt(IPreferenceConstants.OUTLINE_SEPARATOR.key(), ((Integer)IPreferenceConstants.OUTLINE_SEPARATOR.defaultValue()).intValue())));
        this.fOutlineSeparatorCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (MainPreferencePage.this.fOutlineSeparatorCombo.getText().length() > 0) {
                    MainPreferencePage.this.setErrorMessage(null);
                    MainPreferencePage.this.setValid(true);
                } else {
                    MainPreferencePage.this.setErrorMessage(Messages.getString("prefs.general.outline.error", new Object[0]));
                    MainPreferencePage.this.setValid(false);
                }
            }
        });
        this.fIncludeHeaders = new Button((Composite)group, 32);
        this.fIncludeHeaders.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fIncludeHeaders.setText(Messages.getString("prefs.general.fileHeader.label", new Object[0]));
        this.fIncludeHeaders.setSelection(JIntoCore.getPreferences().getBoolean(IPreferenceConstants.SAVING_INCLUDE_HEADER.key(), ((Boolean)IPreferenceConstants.SAVING_INCLUDE_HEADER.defaultValue()).booleanValue()));
    }

    private void createProblemsContent(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.getString("prefs.problems.title", new Object[0]));
        Label label = new Label((Composite)group, 16384);
        label.setText(Messages.getString("prefs.problems.description", new Object[0]));
        label.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        int n = 0;
        while (n < this.problemClassList.size()) {
            this.problemClassList.get(n).createContent((Composite)group);
            ++n;
        }
    }

    private void createEmptyValuesContent(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.getString("prefs.saving.title", new Object[0]));
        IEclipsePreferences iEclipsePreferences = JIntoCore.getPreferences();
        this.saveEmptyValuesButton = new Button((Composite)group, 32);
        this.saveEmptyValuesButton.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.saveEmptyValuesButton.setText(Messages.getString("prefs.saving.emptyValues", new Object[0]));
        this.saveEmptyValuesButton.setSelection(!iEclipsePreferences.getBoolean(IPreferenceConstants.SAVING_EMPTY_VALUES.key(), ((Boolean)IPreferenceConstants.SAVING_EMPTY_VALUES.defaultValue()).booleanValue()));
        this.saveEmptyValuesButton.addSelectionListener((SelectionListener)this);
        this.showVirtualValuesButton = new Button((Composite)group, 32);
        this.showVirtualValuesButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.showVirtualValuesButton.setText(Messages.getString("prefs.saving.virtualValues", new Object[0]));
        this.showVirtualValuesButton.setSelection(iEclipsePreferences.getBoolean(IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.key(), ((Boolean)IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.defaultValue()).booleanValue()));
        this.showVirtualValuesButton.setEnabled(this.saveEmptyValuesButton.getSelection());
        this.colorButton = new ColorEditor((Composite)group);
        int n = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.defaultValue()).intValue());
        int n2 = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.defaultValue()).intValue());
        int n3 = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.defaultValue()).intValue());
        this.colorButton.setColorValue(new RGB(n, n2, n3));
        this.colorButton.getButton().setEnabled(this.saveEmptyValuesButton.getSelection());
    }

    public void init(IWorkbench iWorkbench) {
        this.fWorkbench = iWorkbench;
        this.problemClassList = new LinkedList<ProblemClass>();
        this.problemClassList.add(new ProblemClass("prefs.problems.emptyKey.description", (IPreferenceConstants.PreferenceValue<Integer>)IPreferenceConstants.PROBLEMS_EMPTY_KEY, ProblemClass.Rebuild.Jinto));
        this.problemClassList.add(new ProblemClass("prefs.problems.emptyValue.description", (IPreferenceConstants.PreferenceValue<Integer>)IPreferenceConstants.PROBLEMS_EMPTY_VALUE, ProblemClass.Rebuild.Jinto));
        this.problemClassList.add(new ProblemClass("prefs.problems.equalCellContent.description", (IPreferenceConstants.PreferenceValue<Integer>)IPreferenceConstants.PROBLEMS_EQUAL_CELL_CONTENT, ProblemClass.Rebuild.Jinto));
        this.problemClassList.add(new ProblemClass("prefs.problems.java.nonExistingKey", (IPreferenceConstants.PreferenceValue<Integer>)IPreferenceConstants.PROBLEMS_JAVA_NON_EXISTING_KEY, ProblemClass.Rebuild.JDT));
    }

    protected void performDefaults() {
        IEclipsePreferences iEclipsePreferences = JIntoCore.getDefaultPreferences();
        this.saveEmptyValuesButton.setSelection(!iEclipsePreferences.getBoolean(IPreferenceConstants.SAVING_EMPTY_VALUES.key(), ((Boolean)IPreferenceConstants.SAVING_EMPTY_VALUES.defaultValue()).booleanValue()));
        this.showVirtualValuesButton.setSelection(iEclipsePreferences.getBoolean(IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.key(), ((Boolean)IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.defaultValue()).booleanValue()));
        int n = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.defaultValue()).intValue());
        int n2 = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.defaultValue()).intValue());
        int n3 = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.defaultValue()).intValue());
        this.colorButton.setColorValue(new RGB(n, n2, n3));
        this.showVirtualValuesButton.setEnabled(this.saveEmptyValuesButton.getSelection());
        this.colorButton.getButton().setEnabled(this.saveEmptyValuesButton.getSelection());
        int n4 = 0;
        while (n4 < this.problemClassList.size()) {
            this.problemClassList.get(n4).setDefault();
            ++n4;
        }
        this.fOutlineSeparatorCombo.setText(String.valueOf((char)iEclipsePreferences.getInt(IPreferenceConstants.OUTLINE_SEPARATOR.key(), ((Integer)IPreferenceConstants.OUTLINE_SEPARATOR.defaultValue()).intValue())));
        this.fIncludeHeaders.setSelection(iEclipsePreferences.getBoolean(IPreferenceConstants.SAVING_INCLUDE_HEADER.key(), ((Boolean)IPreferenceConstants.SAVING_INCLUDE_HEADER.defaultValue()).booleanValue()));
        super.performDefaults();
    }

    public boolean performOk() {
        MessageDialog messageDialog;
        Object object;
        IEclipsePreferences iEclipsePreferences = JIntoCore.getPreferences();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.problemClassList.size()) {
            object = this.problemClassList.get(n);
            switch (((ProblemClass)object).needsRebuild()) {
                case Jinto: {
                    bl = true;
                    break;
                }
                case JDT: {
                    bl2 = true;
                    break;
                }
            }
            ++n;
        }
        if (bl2) {
            String string = Messages.getString("prefs.problems.jdtRebuild.tite", new Object[0]);
            object = Messages.getString("prefs.problems.jdtRebuild.message", new Object[0]);
            String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            messageDialog = new MessageDialog(this.getShell(), string, null, (String)object, 3, stringArray, 2);
            int n2 = messageDialog.open();
            if (n2 == 1) {
                bl2 = false;
            } else if (n2 != 0) {
                return false;
            }
        }
        iEclipsePreferences.putBoolean(IPreferenceConstants.SAVING_EMPTY_VALUES.key(), !this.saveEmptyValuesButton.getSelection());
        iEclipsePreferences.putBoolean(IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.key(), this.showVirtualValuesButton.getSelection());
        RGB rGB = this.colorButton.getColorValue();
        iEclipsePreferences.putInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.key(), rGB.red);
        iEclipsePreferences.putInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.key(), rGB.green);
        iEclipsePreferences.putInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.key(), rGB.blue);
        virtualTextColor.dispose();
        virtualTextColor = new Color((Device)Display.getCurrent(), rGB.red, rGB.green, rGB.blue);
        int n3 = 0;
        while (n3 < this.problemClassList.size()) {
            this.problemClassList.get(n3).store();
            ++n3;
        }
        iEclipsePreferences.putInt(IPreferenceConstants.OUTLINE_SEPARATOR.key(), (int)this.fOutlineSeparatorCombo.getText().charAt(0));
        iEclipsePreferences.putBoolean(IPreferenceConstants.SAVING_INCLUDE_HEADER.key(), this.fIncludeHeaders.getSelection());
        IEditorReference[] iEditorReferenceArray = this.fWorkbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n4 = 0;
        while (n4 < iEditorReferenceArray.length) {
            messageDialog = iEditorReferenceArray[n4].getEditor(false);
            if (messageDialog instanceof ResourceEditor) {
                if (bl) {
                    new ProblemsCheckingJob((ResourceEditor)messageDialog).schedule();
                }
                ((ResourceEditor)messageDialog).refreshTable();
            }
            ++n4;
        }
        if (bl2) {
            new BuildJob(Messages.getString("prefs.buildJob.name", new Object[0])).schedule();
        }
        return true;
    }

    public static Color getVirtualTextColor() {
        return virtualTextColor;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.showVirtualValuesButton.setEnabled(this.saveEmptyValuesButton.getSelection());
        this.colorButton.getButton().setEnabled(this.saveEmptyValuesButton.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private static final class BuildJob
    extends Job {
        BuildJob(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] jobArray = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int n = 0;
                while (n < jobArray.length) {
                    Job job = jobArray[n];
                    if (job != this && job instanceof BuildJob) {
                        job.cancel();
                    }
                    ++n;
                }
            }
            try {
                try {
                    iProgressMonitor.beginTask(Messages.getString("prefs.buildJob.taskName", new Object[0]), 2);
                    ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                }
                catch (CoreException coreException) {
                    IStatus iStatus = coreException.getStatus();
                    iProgressMonitor.done();
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    iProgressMonitor.done();
                    return iStatus;
                }
            }
            finally {
                iProgressMonitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProblemClass {
        private String descriptionID;
        private IPreferenceConstants.PreferenceValue<Integer> preferencesID;
        private Combo combo;
        private IEclipsePreferences preferences;
        private Rebuild fRebuildType;

        ProblemClass(String string, IPreferenceConstants.PreferenceValue<Integer> preferenceValue, Rebuild rebuild) {
            this.descriptionID = string;
            this.preferencesID = preferenceValue;
            this.preferences = JIntoCore.getPreferences();
            this.fRebuildType = rebuild;
        }

        void createContent(Composite composite) {
            Label label = new Label(composite, 16384);
            label.setText(Messages.getString(this.descriptionID, new Object[0]));
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.combo = new Combo(composite, 8);
            this.combo.setLayoutData((Object)new GridData(131072, 0, false, false));
            this.combo.add(Messages.getString("prefs.problems.ignore", new Object[0]));
            this.combo.add(Messages.getString("prefs.problems.warning", new Object[0]));
            this.combo.add(Messages.getString("prefs.problems.error", new Object[0]));
            this.combo.select(this.preferences.getInt(this.preferencesID.key(), ((Integer)this.preferencesID.defaultValue()).intValue()));
        }

        void setDefault() {
            this.combo.select(JIntoCore.getDefaultPreferences().getInt(this.preferencesID.key(), ((Integer)this.preferencesID.defaultValue()).intValue()));
        }

        Rebuild needsRebuild() {
            int n;
            int n2 = this.preferences.getInt(this.preferencesID.key(), ((Integer)this.preferencesID.defaultValue()).intValue());
            if (n2 != (n = this.combo.getSelectionIndex())) {
                return this.fRebuildType;
            }
            return Rebuild.NoRebuild;
        }

        void store() {
            int n = this.combo.getSelectionIndex();
            this.preferences.putInt(this.preferencesID.key(), n);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Rebuild {
            NoRebuild,
            Jinto,
            JDT;

        }
    }
}

