/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.table;

import de.guhsoft.jinto.ui.editor.table.ResourceViewer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceViewerFocusCellManager
extends TableViewerFocusCellManager
implements ISelectionChangedListener {
    private ResourceViewer fViewer;

    public ResourceViewerFocusCellManager(ResourceViewer resourceViewer, FocusCellHighlighter focusCellHighlighter) {
        super((TableViewer)resourceViewer, focusCellHighlighter);
        this.fViewer = resourceViewer;
        this.fViewer.addSelectionChangedListener(this);
    }

    protected void initalize() {
        try {
            Method method = this.findMethod("init", new Class[0]);
            if (method != null) {
                method.setAccessible(true);
                method.invoke((Object)this, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
            throw new IllegalAccessError(securityException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAccessError(illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalAccessError(invocationTargetException.getMessage());
        }
    }

    public void setViewerFocusCell(ViewerCell viewerCell) {
        if (viewerCell != null) {
            this.fViewer.removeSelectionChangedListener(this);
            this.fViewer.setSelection((ISelection)new StructuredSelection(viewerCell.getElement()), true);
            this.fViewer.addSelectionChangedListener(this);
            try {
                Method method = this.findMethod("setFocusCell", ViewerCell.class);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)this, viewerCell);
                }
            }
            catch (SecurityException securityException) {
                throw new IllegalAccessError(securityException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalAccessError(illegalArgumentException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalAccessError(invocationTargetException.getMessage());
            }
        }
    }

    private Method findMethod(String string, Class<?> ... classArray) {
        Method method = null;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        while (clazz != null) {
            try {
                method = clazz.getDeclaredMethod(string, classArray);
                break;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            clazz = clazz.getSuperclass();
        }
        return method;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            ViewerRow viewerRow;
            Widget widget;
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            ViewerCell viewerCell = this.getFocusCell();
            if (object != null && !object.equals(viewerCell == null ? null : viewerCell.getElement()) && (widget = this.fViewer.doFindItem(object)) != null && (viewerRow = this.fViewer.getViewerRowFromItem(widget)) != null) {
                int n = -1;
                if (viewerCell != null) {
                    n = viewerCell.getColumnIndex();
                } else if (viewerRow.getColumnCount() > 0) {
                    n = 0;
                }
                if (n != -1) {
                    this.setViewerFocusCell(viewerRow.getCell(n));
                }
            }
        }
    }

    public ViewerCell getFirstViewerCell() {
        Table table = this.fViewer.getTable();
        if (table.getItemCount() > 0) {
            return this.fViewer.getViewerRowFromItem((Widget)table.getItem(0)).getCell(0);
        }
        return null;
    }

    public ViewerCell getLastViewerCell() {
        Table table = this.fViewer.getTable();
        int n = table.getItemCount();
        if (n > 0) {
            ViewerRow viewerRow = this.fViewer.getViewerRowFromItem((Widget)table.getItem(n - 1));
            return viewerRow.getCell(viewerRow.getColumnCount() - 1);
        }
        return null;
    }
}

