/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.table;

import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.model.ModifyRowKeyOperation;
import de.guhsoft.jinto.core.model.ModifyRowValueOperation;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.EditorDialog;
import de.guhsoft.jinto.ui.editor.ResourceEditorRenderer;
import de.guhsoft.jinto.ui.editor.table.ResourceViewer;
import de.guhsoft.jinto.ui.editor.table.ResourceViewerFocusCellManager;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ResourceViewerEditor
extends ColumnViewerEditor {
    TableEditor fTableEditor;
    private ResourceViewerFocusCellManager fFocusCellManager;
    private ResourceEditorRenderer fRenderer;

    ResourceViewerEditor(ResourceViewer resourceViewer, ResourceViewerFocusCellManager resourceViewerFocusCellManager, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n, ResourceEditorRenderer resourceEditorRenderer) {
        super((ColumnViewer)resourceViewer, columnViewerEditorActivationStrategy, n);
        this.fTableEditor = new TableEditor(resourceViewer.getTable());
        this.fFocusCellManager = resourceViewerFocusCellManager;
        this.fRenderer = resourceEditorRenderer;
        this.initEditorDialogListeners();
    }

    private void initEditorDialogListeners() {
        this.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000B && keyEvent.stateMask == SWT.MOD1) {
                    ResourceViewerEditor.this.openEditorInNonEditMode();
                }
            }
        });
    }

    void openEditorInNonEditMode() {
        ViewerRow viewerRow;
        ViewerCell viewerCell = this.fFocusCellManager.getFocusCell();
        if (viewerCell != null && (viewerRow = viewerCell.getViewerRow()) != null && viewerRow.getColumnCount() > 0) {
            String string;
            boolean bl;
            String string2 = viewerCell.getText();
            String string3 = Util.unescapeForLabel((String)string2);
            String string4 = String.valueOf(Messages.getString("editor.editingDialog.title", new Object[0])) + " " + viewerRow.getText(0);
            Shell shell = this.getViewer().getControl().getShell();
            EditorDialog editorDialog = new EditorDialog(shell, string4, string3, this.fRenderer, bl = viewerCell.getColumnIndex() == 0);
            if (editorDialog.open() == 0 && !(string = Util.escapeForLabel((String)editorDialog.getValue())).equals(string3)) {
                ResourceBundleModel resourceBundleModel = this.fRenderer.getResourceDataModel();
                if (bl) {
                    this.fRenderer.execute((IUndoableOperation)new ModifyRowKeyOperation(resourceBundleModel, string2, string));
                } else {
                    ResourceRow resourceRow = (ResourceRow)viewerCell.getElement();
                    TableColumn tableColumn = ((ResourceViewer)this.getViewer()).getTable().getColumn(viewerCell.getColumnIndex());
                    String string5 = tableColumn.getText();
                    this.fRenderer.execute((IUndoableOperation)new ModifyRowValueOperation(resourceBundleModel, resourceRow, string5, string));
                }
            }
        }
    }

    public static void create(ResourceViewer resourceViewer, ResourceViewerFocusCellManager resourceViewerFocusCellManager, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n, ResourceEditorRenderer resourceEditorRenderer) {
        ResourceViewerEditor resourceViewerEditor = new ResourceViewerEditor(resourceViewer, resourceViewerFocusCellManager, columnViewerEditorActivationStrategy, n, resourceEditorRenderer);
        resourceViewer.setColumnViewerEditor(resourceViewerEditor);
        if (resourceViewerFocusCellManager != null) {
            resourceViewerFocusCellManager.initalize();
        }
    }

    public static void create(ResourceViewer resourceViewer, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n, ResourceEditorRenderer resourceEditorRenderer) {
        ResourceViewerEditor.create(resourceViewer, null, columnViewerEditorActivationStrategy, n, resourceEditorRenderer);
    }

    protected void setEditor(Control control, Item item, int n) {
        this.fTableEditor.setEditor(control, (TableItem)item, n);
    }

    protected void setLayoutData(CellEditor.LayoutData layoutData) {
        this.fTableEditor.grabHorizontal = layoutData.grabHorizontal;
        this.fTableEditor.horizontalAlignment = layoutData.horizontalAlignment;
        this.fTableEditor.minimumWidth = layoutData.minimumWidth;
    }

    public ViewerCell getFocusCell() {
        if (this.fFocusCellManager != null) {
            return this.fFocusCellManager.getFocusCell();
        }
        return super.getFocusCell();
    }

    protected void updateFocusCell(ViewerCell viewerCell, ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        if (columnViewerEditorActivationEvent.eventType == 4 || columnViewerEditorActivationEvent.eventType == 5) {
            List<?> list = ((ResourceViewer)this.getViewer()).getSelectionFromWidget();
            if (this.fFocusCellManager != null) {
                this.fFocusCellManager.setViewerFocusCell(viewerCell);
            }
            if (!list.contains(viewerCell.getElement())) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(viewerCell.getElement()), true);
            }
        }
    }

    protected void processTraverseEvent(int n, ViewerRow viewerRow, TraverseEvent traverseEvent) {
        if (traverseEvent.keyCode == 0x1000001) {
            traverseEvent.detail = 8;
            traverseEvent.stateMask = 262144;
        } else if (traverseEvent.keyCode == 0x1000002) {
            traverseEvent.detail = 16;
            traverseEvent.stateMask = 262144;
        }
        super.processTraverseEvent(n, viewerRow, traverseEvent);
    }
}

