/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.outline;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.model.IResourceBundleListener;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import de.guhsoft.jinto.ui.editor.actions.SearchForReferenceAction;
import de.guhsoft.jinto.ui.editor.outline.CollapseAllAction;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ResourceBundleOutlinePage
extends Page
implements IContentOutlinePage,
IEclipsePreferences.IPreferenceChangeListener {
    static char SEPARATOR = (char)JIntoCore.getPreferences().getInt(IPreferenceConstants.OUTLINE_SEPARATOR.key(), ((Integer)IPreferenceConstants.OUTLINE_SEPARATOR.defaultValue()).intValue());
    private ResourceEditor fEditor;
    private Composite fComposite;
    TreeViewer fTreeViewer;
    private IResourceBundleListener fResourceBundleListener;

    public ResourceBundleOutlinePage(ResourceEditor resourceEditor) {
        this.fEditor = resourceEditor;
        JIntoCore.getPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void createControl(Composite composite) {
        this.fComposite = new Composite(composite, 0);
        this.fComposite.setLayout((Layout)new FillLayout());
        this.fTreeViewer = new TreeViewer(this.fComposite, 4);
        this.fTreeViewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.fTreeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof OutlineElement && object2 instanceof OutlineElement) {
                    int n = 0;
                    OutlineElement outlineElement = (OutlineElement)object;
                    OutlineElement outlineElement2 = (OutlineElement)object2;
                    n = outlineElement.getChildren().length > 0 && outlineElement2.getChildren().length == 0 ? -1 : (outlineElement.getChildren().length == 0 && outlineElement2.getChildren().length > 0 ? 1 : outlineElement.getCurrent().compareTo(outlineElement2.getCurrent()));
                    return n;
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.fTreeViewer.setInput((Object)this.fEditor.getResourceDataModel());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                OutlineElement outlineElement = (OutlineElement)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                if (outlineElement != null) {
                    ResourceBundleOutlinePage.this.singleClicked(outlineElement);
                    String string = ResourceBundleOutlinePage.this.buildKey(outlineElement);
                    if (ResourceBundleOutlinePage.this.isKey(string)) {
                        ResourceBundleOutlinePage.this.getSite().getActionBars().getStatusLineManager().setMessage(string);
                    }
                }
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                OutlineElement outlineElement = (OutlineElement)((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
                if (outlineElement != null) {
                    ResourceBundleOutlinePage.this.doubleClicked(outlineElement);
                }
            }
        });
        this.fResourceBundleListener = new IResourceBundleListener(){

            public void rowAdded(String string, ResourceRow resourceRow) {
                ResourceBundleOutlinePage.this.fTreeViewer.refresh();
            }

            public void rowRemoved(String string, ResourceRow resourceRow) {
                ResourceBundleOutlinePage.this.fTreeViewer.refresh();
            }

            public void rowKeyChanged(String string, String string2, ResourceRow resourceRow) {
                ResourceBundleOutlinePage.this.fTreeViewer.refresh();
            }

            public void rowValueChanged(ResourceRow resourceRow, String string, String string2) {
            }
        };
        this.fEditor.getResourceDataModel().addListener(this.fResourceBundleListener);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new SearchForReferenceAction(new SearchForReferenceAction.IKeyResolver(){

            public String resolveKey() {
                OutlineElement outlineElement = (OutlineElement)((IStructuredSelection)ResourceBundleOutlinePage.this.fTreeViewer.getSelection()).getFirstElement();
                if (outlineElement != null) {
                    return outlineElement.getCurrent();
                }
                return null;
            }
        }));
        Tree tree = this.fTreeViewer.getTree();
        tree.setMenu(menuManager.createContextMenu((Control)tree));
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)new CollapseAllAction(this.fTreeViewer));
    }

    void singleClicked(OutlineElement outlineElement) {
        String string = this.buildKey(outlineElement);
        if (this.isKey(string)) {
            this.fEditor.selectRow(string);
        }
    }

    boolean isKey(OutlineElement outlineElement) {
        return this.isKey(this.buildKey(outlineElement));
    }

    boolean isKey(String string) {
        return this.fEditor.getResourceDataModel().getRow(string) != null;
    }

    String buildKey(OutlineElement outlineElement) {
        StringBuffer stringBuffer = new StringBuffer();
        while (outlineElement.getCurrent() != null) {
            stringBuffer.insert(0, outlineElement.getCurrent());
            outlineElement = outlineElement.getParent();
            if (outlineElement.getCurrent() == null) continue;
            stringBuffer.insert(0, SEPARATOR);
        }
        return stringBuffer.toString();
    }

    void doubleClicked(OutlineElement outlineElement) {
        if (outlineElement.getChildren().length > 0) {
            if (this.fTreeViewer.getExpandedState((Object)outlineElement)) {
                this.fTreeViewer.collapseToLevel((Object)outlineElement, -1);
            } else {
                this.fTreeViewer.expandToLevel((Object)outlineElement, 1);
            }
        }
    }

    public Control getControl() {
        return this.fComposite;
    }

    public void setFocus() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public void setSelection(ISelection iSelection) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(IPreferenceConstants.OUTLINE_SEPARATOR.key())) {
            SEPARATOR = (char)preferenceChangeEvent.getNode().getInt(IPreferenceConstants.OUTLINE_SEPARATOR.key(), ((Integer)IPreferenceConstants.OUTLINE_SEPARATOR.defaultValue()).intValue());
            this.fTreeViewer.refresh();
        }
    }

    public void dispose() {
        super.dispose();
        JIntoCore.getPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.fEditor.getResourceDataModel().removeListener(this.fResourceBundleListener);
    }

    private class OutlineContentProvider
    implements ITreeContentProvider {
        OutlineContentProvider() {
        }

        public Object[] getChildren(Object object) {
            return ((OutlineElement)object).getChildren();
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            ResourceBundleModel resourceBundleModel = (ResourceBundleModel)object;
            String[] stringArray = new String[resourceBundleModel.getRowCount()];
            Iterator iterator = resourceBundleModel.getRowKeys();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                ++n;
            }
            return this.getChildren(new OutlineElement(null, null, stringArray));
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class OutlineElement {
        private OutlineElement fParent;
        private String fCurrent;
        private String[] fSuffixArray;
        private OutlineElement[] fChildren;

        public OutlineElement(OutlineElement outlineElement, String string, String[] stringArray) {
            this.fParent = outlineElement;
            this.fCurrent = string;
            this.fSuffixArray = stringArray;
        }

        private OutlineElement[] createChildren() {
            LinkedList<String> linkedList;
            Object object;
            HashMap hashMap = new HashMap();
            int n = 0;
            while (n < this.fSuffixArray.length) {
                int n2 = this.fSuffixArray[n].indexOf(SEPARATOR);
                object = this.fSuffixArray[n];
                String string = null;
                if (n2 != -1) {
                    object = this.fSuffixArray[n].substring(0, n2);
                    string = this.fSuffixArray[n].substring(n2 + 1);
                }
                if ((linkedList = (List)((AbstractMap)hashMap).get(object)) == null) {
                    linkedList = new LinkedList<String>();
                    ((AbstractMap)hashMap).put(object, linkedList);
                }
                if (string != null && string.length() > 0) {
                    linkedList.add(string);
                }
                ++n;
            }
            this.fSuffixArray = null;
            Set set = ((AbstractMap)hashMap).entrySet();
            OutlineElement[] outlineElementArray = new OutlineElement[set.size()];
            object = set.iterator();
            int n3 = 0;
            while (object.hasNext()) {
                linkedList = (Map.Entry)object.next();
                List list = (List)linkedList.getValue();
                String[] stringArray = new String[list.size()];
                list.toArray(stringArray);
                outlineElementArray[n3] = new OutlineElement(this, (String)linkedList.getKey(), stringArray);
                ++n3;
            }
            return outlineElementArray;
        }

        public OutlineElement[] getChildren() {
            if (this.fChildren == null && this.fSuffixArray != null) {
                this.fChildren = this.createChildren();
            }
            return this.fChildren;
        }

        public String getCurrent() {
            return this.fCurrent;
        }

        public OutlineElement getParent() {
            return this.fParent;
        }

        public int hashCode() {
            int n = this.fParent == null ? 0 : this.fParent.hashCode();
            n += Arrays.hashCode(this.fSuffixArray);
            return n += this.fCurrent == null ? 0 : this.fCurrent.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof OutlineElement) {
                return this.internalEquals((OutlineElement)object);
            }
            return super.equals(object);
        }

        private boolean internalEquals(OutlineElement outlineElement) {
            boolean bl = false;
            bl = this.getCurrent() == null && outlineElement.getCurrent() == null ? true : (this.getCurrent() == null && outlineElement.getCurrent() != null || this.getCurrent() == null && outlineElement.getCurrent() != null ? false : this.getCurrent().equals(outlineElement.getCurrent()));
            if (bl) {
                bl = this.getParent() == null && outlineElement.getParent() == null ? true : (this.getParent() != null && outlineElement.getParent() == null || this.getParent() == null && outlineElement.getParent() != null ? false : this.getParent().equals(outlineElement.getParent()));
            }
            return bl;
        }
    }

    private class OutlineLabelProvider
    implements ILabelProvider {
        OutlineLabelProvider() {
        }

        public Image getImage(Object object) {
            OutlineElement outlineElement = (OutlineElement)object;
            if (ResourceBundleOutlinePage.this.isKey(outlineElement)) {
                return JIntoUI.getImage("key");
            }
            return JIntoUI.getImage("keyless");
        }

        public String getText(Object object) {
            return ((OutlineElement)object).getCurrent();
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

