/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.find;

import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.find.IFindProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class FindDialog
extends Dialog
implements SelectionListener {
    public static final String SETTINGS_SECTION_ID = "de.guhsoft.jinto.findDialog";
    private static final String DIRECTION_ID = "direction";
    public static final String CASE_SENSITIVE_ID = "caseSensitive";
    public static final String WRAP_SEARCH_ID = "wrapSearch";
    public static final String SEARCH_HISTORY_ID = "searchHistory";
    private static final int FIND_ID = 90000;
    private static final String FIND_LABEL = Messages.getString("find.button.label", new Object[0]);
    private Combo findCombo;
    private IDialogSettings settings;
    private IFindProvider findProvider;
    private Label statusLabel;

    public FindDialog(Shell shell, IFindProvider iFindProvider) {
        super(shell);
        this.findProvider = iFindProvider;
        IDialogSettings iDialogSettings = JIntoUI.getDefault().getDialogSettings();
        this.settings = iDialogSettings.getSection(SETTINGS_SECTION_ID);
        if (this.settings == null) {
            this.settings = iDialogSettings.addNewSection(SETTINGS_SECTION_ID);
            this.settings.put(DIRECTION_ID, 0);
            this.settings.put(CASE_SENSITIVE_ID, false);
            this.settings.put(WRAP_SEARCH_ID, false);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite2.setLayout((Layout)gridLayout);
        this.createFindComposite(composite2);
        this.createDirectionGroup(composite2);
        this.createOptionsGroup(composite2);
        Label label = new Label(composite2, 258);
        label.setVisible(false);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        this.statusLabel = new Label(composite2, 16384);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return composite2;
    }

    private void createFindComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(Messages.getString("find.label.text", new Object[0]));
        this.findCombo = new Combo(composite2, 4);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 150;
        this.findCombo.setLayoutData((Object)gridData);
        String[] stringArray = this.settings.getArray(SEARCH_HISTORY_ID);
        if (stringArray != null) {
            this.findCombo.setItems(stringArray);
            this.findCombo.select(0);
            this.findCombo.setSelection(new Point(0, this.findCombo.getText().length()));
        }
    }

    private void createDirectionGroup(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.getString("find.direction.label", new Object[0]));
        boolean bl = this.settings.getInt(DIRECTION_ID) == 0;
        Button button = new Button((Composite)group, 16400);
        button.setText(Messages.getString("find.direction.forward", new Object[0]));
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setData((Object)"forwardRadioButton");
        button.addSelectionListener((SelectionListener)this);
        button.setSelection(bl);
        Button button2 = new Button((Composite)group, 16400);
        button2.setText(Messages.getString("find.direction.backward", new Object[0]));
        button2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button2.setData((Object)"backwardRadioButton");
        button2.addSelectionListener((SelectionListener)this);
        button2.setSelection(!bl);
    }

    private void createOptionsGroup(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.getString("find.options.label", new Object[0]));
        Button button = new Button((Composite)group, 16416);
        button.setText(Messages.getString("find.options.caseSensitive", new Object[0]));
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setData((Object)"caseSensitiveCheckBox");
        button.addSelectionListener((SelectionListener)this);
        button.setSelection(this.settings.getBoolean(CASE_SENSITIVE_ID));
        Button button2 = new Button((Composite)group, 16416);
        button2.setText(Messages.getString("find.options.wrapSearch", new Object[0]));
        button2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button2.setData((Object)"wrapSearchCheckBox");
        button2.addSelectionListener((SelectionListener)this);
        button2.setSelection(this.settings.getBoolean(WRAP_SEARCH_ID));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 90000, FIND_LABEL, true);
        this.createButton(composite, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int n) {
        if (n == 90000) {
            String string = this.findCombo.getText();
            if (string.length() > 0) {
                int n2 = 0;
                while (n2 < this.findCombo.getItemCount()) {
                    if (this.findCombo.getItem(n2).equals(string)) {
                        this.findCombo.remove(n2);
                        break;
                    }
                    ++n2;
                }
                this.findCombo.add(string, 0);
                this.findCombo.setText(string);
                this.settings.put(SEARCH_HISTORY_ID, this.findCombo.getItems());
                if (this.findProvider.find(string, this.settings.getInt(DIRECTION_ID) == 0, this.settings.getBoolean(CASE_SENSITIVE_ID), this.settings.getBoolean(WRAP_SEARCH_ID))) {
                    this.statusLabel.setText("");
                } else {
                    this.statusLabel.setText(Messages.getString("find.dialog.error", new Object[0]));
                }
            }
        } else if (n == 12) {
            this.close();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("find.dialog.title", new Object[0]));
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string = (String)((Widget)selectionEvent.getSource()).getData();
        if (string.equals("forwardRadioButton")) {
            this.settings.put(DIRECTION_ID, 0);
        } else if (string.equals("backwardRadioButton")) {
            this.settings.put(DIRECTION_ID, 1);
        } else if (string.equals("caseSensitiveCheckBox")) {
            this.settings.put(CASE_SENSITIVE_ID, !this.settings.getBoolean(CASE_SENSITIVE_ID));
        } else if (string.equals("wrapSearchCheckBox")) {
            this.settings.put(WRAP_SEARCH_ID, !this.settings.getBoolean(WRAP_SEARCH_ID));
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

