/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.actions;

import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import de.guhsoft.jinto.ui.editor.find.FindDialog;
import de.guhsoft.jinto.ui.editor.find.IFindProvider;
import de.guhsoft.jinto.ui.editor.table.ResourceViewerFocusCellManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;

public class FindAction
extends Action
implements IFindProvider {
    private ResourceViewerFocusCellManager fFocusCellManager;
    private ResourceEditor fEditor;

    public FindAction(ResourceEditor resourceEditor, ResourceViewerFocusCellManager resourceViewerFocusCellManager) {
        this.fEditor = resourceEditor;
        this.fFocusCellManager = resourceViewerFocusCellManager;
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        this.fEditor.cancelEditing();
        FindDialog findDialog = new FindDialog(this.fEditor.getSite().getShell(), this);
        findDialog.open();
    }

    public boolean find(boolean bl) {
        String[] stringArray;
        IDialogSettings iDialogSettings = JIntoUI.getDefault().getDialogSettings().getSection("de.guhsoft.jinto.findDialog");
        if (iDialogSettings != null && (stringArray = iDialogSettings.getArray("searchHistory")) != null && stringArray.length > 0) {
            boolean bl2 = iDialogSettings.getBoolean("caseSensitive");
            boolean bl3 = iDialogSettings.getBoolean("wrapSearch");
            return this.find(stringArray[0], bl, bl2, bl3);
        }
        return false;
    }

    public boolean find(String string, boolean bl, boolean bl2, boolean bl3) {
        ViewerCell viewerCell = this.fFocusCellManager.getFocusCell();
        if (viewerCell == null) {
            viewerCell = this.fFocusCellManager.getFirstViewerCell();
        }
        if (viewerCell != null) {
            ViewerCell viewerCell2 = this.next(viewerCell, bl, bl3);
            if (viewerCell2 != null) {
                viewerCell = viewerCell2;
                if (this.equals(string, viewerCell2.getText(), bl2)) {
                    this.fFocusCellManager.setViewerFocusCell(viewerCell2);
                    return true;
                }
                viewerCell2 = this.next(viewerCell2, bl, bl3);
            }
            while (viewerCell2 != null && !viewerCell2.equals((Object)viewerCell)) {
                if (this.equals(string, viewerCell2.getText(), bl2)) {
                    this.fFocusCellManager.setViewerFocusCell(viewerCell2);
                    return true;
                }
                viewerCell2 = this.next(viewerCell2, bl, bl3);
            }
        }
        return false;
    }

    private ViewerCell next(ViewerCell viewerCell, boolean bl, boolean bl2) {
        ViewerCell viewerCell2 = null;
        int n = bl ? ViewerCell.RIGHT : ViewerCell.LEFT;
        viewerCell2 = viewerCell.getNeighbor(n, true);
        if (viewerCell2 == null) {
            n = bl ? ViewerCell.BELOW : ViewerCell.ABOVE;
            ViewerRow viewerRow = viewerCell.getViewerRow().getNeighbor(n, true);
            if (viewerRow != null) {
                viewerCell2 = bl ? viewerRow.getCell(0) : viewerRow.getCell(viewerRow.getColumnCount() - 1);
            } else if (bl2) {
                viewerCell2 = bl ? this.fFocusCellManager.getFirstViewerCell() : this.fFocusCellManager.getLastViewerCell();
            }
        }
        return viewerCell2;
    }

    private boolean equals(String string, String string2, boolean bl) {
        if (bl) {
            return string2.indexOf(string) != -1;
        }
        return string2.toLowerCase().indexOf(string.toLowerCase()) != -1;
    }
}

