/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.actions;

import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractOperationHistoryAction
extends Action
implements IOperationHistoryListener {
    private ResourceEditor fEditor;

    public AbstractOperationHistoryAction(ResourceEditor resourceEditor) {
        this.fEditor = resourceEditor;
        IOperationHistory iOperationHistory = OperationHistoryFactory.getOperationHistory();
        iOperationHistory.addOperationHistoryListener((IOperationHistoryListener)this);
        this.setEnabled(this.canExecute(iOperationHistory, this.getContext()));
    }

    protected abstract String getErrorMessageKey();

    protected abstract boolean canExecute(IOperationHistory var1, IUndoContext var2);

    protected abstract void execute(IOperationHistory var1, IUndoContext var2) throws ExecutionException;

    public void historyNotification(OperationHistoryEvent operationHistoryEvent) {
        this.setEnabled(this.canExecute(OperationHistoryFactory.getOperationHistory(), this.getContext()));
    }

    public void run() {
        IUndoContext iUndoContext;
        IOperationHistory iOperationHistory = OperationHistoryFactory.getOperationHistory();
        if (this.canExecute(iOperationHistory, iUndoContext = this.getContext())) {
            try {
                this.execute(iOperationHistory, iUndoContext);
            }
            catch (ExecutionException executionException) {
                String string = JIntoUI.getID();
                Status status = new Status(4, string, 4, "ExecutionException occurs", (Throwable)executionException);
                JIntoUI.getDefault().getLog().log((IStatus)status);
                String string2 = Messages.getString("error.dialog.title", new Object[0]);
                String string3 = Messages.getString(this.getErrorMessageKey(), new Object[0]);
                ErrorDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)string2, (String)string3, (IStatus)status);
            }
        }
    }

    private IUndoContext getContext() {
        return this.fEditor.getResourceDataModel().getUndoContent();
    }
}

