/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.model.AddRowOperation;
import de.guhsoft.jinto.core.model.RemoveRowOperation;
import de.guhsoft.jinto.core.model.ResourceBundleManager;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceFile;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.GoToResource;
import de.guhsoft.jinto.ui.editor.ProblemsCheckingJob;
import de.guhsoft.jinto.ui.editor.ResourceEditorRenderer;
import de.guhsoft.jinto.ui.editor.UpdateEditorJob;
import de.guhsoft.jinto.ui.editor.actions.FindAction;
import de.guhsoft.jinto.ui.editor.actions.RedoAction;
import de.guhsoft.jinto.ui.editor.actions.UndoAction;
import de.guhsoft.jinto.ui.editor.outline.ResourceBundleOutlinePage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ResourceEditor
extends EditorPart
implements IResourceChangeListener,
KeyListener,
ISelectionProvider {
    private Map<String, IAction> fActions = new HashMap<String, IAction>();
    private ResourceBundleModel resourceDataModel;
    private boolean isDirty = false;
    private boolean isReadOnly;
    private ResourceEditorRenderer fRenderer;
    private IUndoableOperation fFirstOperation;

    public void doSave(IProgressMonitor iProgressMonitor) {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        boolean bl = JIntoCore.getPreferences().getBoolean(IPreferenceConstants.SAVING_EMPTY_VALUES.key(), ((Boolean)IPreferenceConstants.SAVING_EMPTY_VALUES.defaultValue()).booleanValue());
        boolean bl2 = JIntoCore.getPreferences().getBoolean(IPreferenceConstants.SAVING_INCLUDE_HEADER.key(), ((Boolean)IPreferenceConstants.SAVING_INCLUDE_HEADER.defaultValue()).booleanValue());
        try {
            this.getResourceDataModel().save(iProgressMonitor, bl, bl2);
        }
        catch (IOException iOException) {
            Status status = new Status(4, JIntoUI.getID(), 4, "IOException occurs", iOException.fillInStackTrace());
            JIntoUI.getDefault().getLog().log((IStatus)status);
            ErrorDialog.openError(null, (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("error.saving", new Object[0]), (IStatus)status);
        }
        catch (CoreException coreException) {
            Status status = new Status(4, JIntoUI.getID(), 4, "CoreException occurs", coreException.fillInStackTrace());
            JIntoUI.getDefault().getLog().log((IStatus)status);
            ErrorDialog.openError(null, (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("error.saving", new Object[0]), (IStatus)status);
        }
        this.setDirty(false);
        this.fFirstOperation = null;
        this.clearOperationHistory();
        iProgressMonitor.done();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        new ProblemsCheckingJob(this).schedule();
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class clazz) {
        if (IGotoMarker.class.equals((Object)clazz)) {
            return new GoToResource(this.getResourceDataModel(), this.fRenderer);
        }
        if (IContentOutlinePage.class.equals((Object)clazz)) {
            return new ResourceBundleOutlinePage(this);
        }
        return super.getAdapter(clazz);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        IStorage iStorage = null;
        if (iEditorInput instanceof IStorageEditorInput) {
            try {
                iStorage = ((IStorageEditorInput)iEditorInput).getStorage();
            }
            catch (CoreException coreException) {
                throw new PartInitException("Exception while getting storage from IStorageEditorInput.", (Throwable)coreException);
            }
        } else {
            throw new PartInitException("Invalid Input: Must be IStorageEditorInput.");
        }
        this.setReadOnly(iStorage.isReadOnly());
        try {
            ResourceBundleModel resourceBundleModel = ResourceBundleManager.createForFile((IStorage)iStorage, (boolean)true);
            if (resourceBundleModel == null) {
                throw new PartInitException("Could not create ResourceBundle model from File " + iStorage.getFullPath().toString() + "!");
            }
            this.setResourceDataModel(resourceBundleModel);
        }
        catch (CoreException coreException) {
            throw new PartInitException(coreException.getMessage());
        }
        catch (IOException iOException) {
            throw new PartInitException(iOException.getMessage());
        }
        iEditorSite.setSelectionProvider((ISelectionProvider)this);
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(this.getResourceDataModel().getName());
        this.setTitleToolTip(Messages.getString("editor.filename.addition", this.getResourceDataModel().getName()));
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        if (this.isDirty != bl) {
            this.isDirty = bl;
            this.firePropertyChange(257);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        this.fRenderer = new ResourceEditorRenderer(this);
        this.fRenderer.createContents(composite);
        this.createActions();
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent operationHistoryEvent) {
                ResourceEditor.this.onHistoryNotification(operationHistoryEvent);
            }
        });
        new ProblemsCheckingJob(this).schedule();
    }

    void onHistoryNotification(OperationHistoryEvent operationHistoryEvent) {
        IUndoContext iUndoContext = this.getResourceDataModel().getUndoContent();
        if (operationHistoryEvent.getOperation().hasContext(iUndoContext)) {
            IOperationHistory iOperationHistory = operationHistoryEvent.getHistory();
            switch (operationHistoryEvent.getEventType()) {
                case 1: {
                    if (this.fFirstOperation == null) {
                        this.fFirstOperation = operationHistoryEvent.getOperation();
                        break;
                    }
                    if (iOperationHistory.canUndo(iUndoContext) || !this.fFirstOperation.equals(iOperationHistory.getRedoOperation(iUndoContext))) break;
                    this.fFirstOperation = operationHistoryEvent.getOperation();
                    break;
                }
                default: {
                    boolean bl = false;
                    if (this.fFirstOperation != null) {
                        bl = iOperationHistory.canUndo(iUndoContext) ? true : !this.fFirstOperation.equals(iOperationHistory.getRedoOperation(iUndoContext));
                    }
                    this.setDirty(bl);
                }
            }
        }
    }

    public void cancelEditing() {
        this.fRenderer.cancelEditing();
    }

    public void sizeColumnsToEditorWidth() {
        this.fRenderer.sizeColumnsToEditorWidth();
    }

    public void sizeColumnsToOptimalWidth() {
        this.fRenderer.sizeColumnsToOptimalWidth();
    }

    public boolean isDisposed() {
        return this.fRenderer.isDisposed();
    }

    public void addColumn(String string) {
        this.fRenderer.addColumn(string);
    }

    public void removeColumn(String string) {
        this.fRenderer.removeColumn(string);
    }

    public void refreshTable() {
        this.fRenderer.refreshTable();
    }

    private void createActions() {
        this.setAction(ActionFactory.FIND.getId(), (IAction)new FindAction(this, this.fRenderer.getFocusCellManager()));
        this.setAction(ActionFactory.UNDO.getId(), (IAction)new UndoAction(this));
        this.setAction(ActionFactory.REDO.getId(), (IAction)new RedoAction(this));
    }

    private void setAction(String string, IAction iAction) {
        if (iAction == null) {
            this.fActions.remove(string);
        } else {
            this.fActions.put(string, iAction);
        }
    }

    public IAction getAction(String string) {
        return this.fActions.get(string);
    }

    public void setFocus() {
        this.fRenderer.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
        if (this.fRenderer != null) {
            this.fRenderer.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta[] iResourceDeltaArray;
        ResourceBundleModel resourceBundleModel = this.getResourceDataModel();
        int n = 0;
        while (n < resourceBundleModel.getResourceFileCount()) {
            if (iResourceChangeEvent.getDelta() != null && (iResourceDeltaArray = iResourceChangeEvent.getDelta().findMember(((ResourceFile)resourceBundleModel.getResourceFileMapEntry(n).getValue()).getFileStorage().getFullPath())) != null && (iResourceDeltaArray.getKind() == 4 && (iResourceDeltaArray.getFlags() & 0x100) != 0 || iResourceDeltaArray.getKind() == 2)) {
                new UpdateEditorJob(this, (IResourceDelta)iResourceDeltaArray, (ResourceFile)resourceBundleModel.getResourceFileMapEntry(n).getValue()).schedule();
            }
            ++n;
        }
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta().findMember(resourceBundleModel.getSelectedStorage().getFullPath().removeLastSegments(1));
        if (iResourceDelta != null && iResourceDelta.getKind() == 4) {
            iResourceDeltaArray = iResourceDelta.getAffectedChildren(1);
            int n2 = 0;
            while (n2 < iResourceDeltaArray.length) {
                ResourceFile resourceFile;
                if (iResourceDeltaArray[n2].getResource().getType() == 1 && iResourceDeltaArray[n2].getKind() == 1 && (resourceFile = ResourceBundleManager.checkAndGetMatchingFile((String)resourceBundleModel.getName(), (IStorage)((IFile)iResourceDeltaArray[n2].getResource()))) != null) {
                    new UpdateEditorJob(this, iResourceDeltaArray[n2], resourceFile).schedule();
                }
                ++n2;
            }
        }
    }

    void addNewRow() {
        this.cancelEditing();
        String string = "";
        ResourceRow resourceRow = this.getResourceDataModel().getRow(string);
        if (resourceRow == null) {
            this.execute((IUndoableOperation)new AddRowOperation(this.getResourceDataModel(), string));
        } else {
            this.fRenderer.setSelection((ISelection)new StructuredSelection((Object)resourceRow));
        }
    }

    void removeSelectedRows() {
        ISelection iSelection = this.fRenderer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ResourceRow resourceRow : (IStructuredSelection)iSelection) {
                arrayList.add(resourceRow.getKey());
            }
            if (arrayList.size() > 0) {
                this.execute((IUndoableOperation)new RemoveRowOperation(this.getResourceDataModel(), arrayList.toArray(new String[arrayList.size()])));
            }
        }
    }

    void execute(final IUndoableOperation iUndoableOperation) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    IOperationHistory iOperationHistory = OperationHistoryFactory.getOperationHistory();
                    iOperationHistory.execute(iUndoableOperation, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException executionException) {
                    String string = JIntoUI.getID();
                    Status status = new Status(4, string, 4, "ExecutionException occurs", (Throwable)executionException);
                    JIntoUI.getDefault().getLog().log((IStatus)status);
                    String string2 = Messages.getString("error.dialog.title", new Object[0]);
                    String string3 = Messages.getString("error.operation", new Object[0]);
                    ErrorDialog.openError((Shell)ResourceEditor.this.getEditorSite().getShell(), (String)string2, (String)string3, (IStatus)status);
                }
            }
        });
    }

    public void clearOperationHistory() {
        OperationHistoryFactory.getOperationHistory().dispose(this.getResourceDataModel().getUndoContent(), true, true, true);
    }

    public boolean selectRow(String string) {
        ResourceRow resourceRow = this.getResourceDataModel().getRow(string);
        if (resourceRow != null) {
            this.fRenderer.setSelection((ISelection)new StructuredSelection((Object)resourceRow));
            return true;
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isReadOnly) {
            if (keyEvent.character == '+') {
                keyEvent.doit = false;
                this.addNewRow();
            } else if (keyEvent.character == '-') {
                keyEvent.doit = false;
                this.removeSelectedRows();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public ISelectionProvider getTableSelectionProvider() {
        return this.fRenderer;
    }

    public ResourceBundleModel getResourceDataModel() {
        return this.resourceDataModel;
    }

    private void setResourceDataModel(ResourceBundleModel resourceBundleModel) {
        this.resourceDataModel = resourceBundleModel;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    private void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object[])new IStorage[]{this.getResourceDataModel().getSelectedStorage()});
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public void setSelection(ISelection iSelection) {
    }
}

