/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor;

import de.guhsoft.jinto.core.JIntoBundleMarker;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.table.ResourceViewer;
import de.guhsoft.jinto.ui.ruler.IRulerColumn;
import de.guhsoft.jinto.ui.ruler.VerticalTableRuler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class JIntoMarkerColumn
implements IRulerColumn,
IResourceChangeListener {
    private static final Image WARNING = JIntoUI.getImage("warningIcon");
    private static final Image ERROR = JIntoUI.getImage("errorIcon");
    VerticalTableRuler fRuler;
    private ResourceBundleModel fModel;
    private ResourceViewer fViewer;
    private Map<String, List<IMarker>> fMarkedRows;
    private String fDuplicateKey;

    public JIntoMarkerColumn(ResourceBundleModel resourceBundleModel, ResourceViewer resourceViewer) {
        this.fModel = resourceBundleModel;
        this.fViewer = resourceViewer;
        this.fMarkedRows = new HashMap<String, List<IMarker>>();
        this.updateMarkedRows();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void installed(VerticalTableRuler verticalTableRuler) {
        this.fRuler = verticalTableRuler;
    }

    public void deinstalled(VerticalTableRuler verticalTableRuler) {
        this.fRuler = null;
    }

    public void setDuplicateKey(String string) {
        this.fDuplicateKey = string;
        this.fRuler.redraw();
    }

    private void updateMarkedRows() {
        this.fMarkedRows.clear();
        try {
            IMarker[] iMarkerArray = JIntoBundleMarker.findMarkersForModel((ResourceBundleModel)this.fModel);
            if (iMarkerArray != null) {
                int n = 0;
                while (n < iMarkerArray.length) {
                    String[] stringArray = JIntoBundleMarker.getRows((IMarker)iMarkerArray[n]);
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        List<IMarker> list = this.fMarkedRows.get(stringArray[n2]);
                        if (list == null) {
                            list = new LinkedList<IMarker>();
                            this.fMarkedRows.put(stringArray[n2], list);
                        }
                        list.add(iMarkerArray[n]);
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            String string = JIntoUI.getID();
            String string2 = "CoreException occurs";
            Status status = new Status(4, string, 4, string2, (Throwable)coreException);
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
    }

    public int getPreferredRowHeight() {
        return Math.max(JIntoMarkerColumn.ERROR.getBounds().height, JIntoMarkerColumn.WARNING.getBounds().height);
    }

    public int getWidth() {
        return Math.max(JIntoMarkerColumn.ERROR.getBounds().width, JIntoMarkerColumn.WARNING.getBounds().width);
    }

    private String getKey(TableItem tableItem) {
        ViewerRow viewerRow = this.fViewer.getViewerRowFromItem((Widget)tableItem);
        if (viewerRow != null && viewerRow.getColumnCount() > 0) {
            return viewerRow.getText(0);
        }
        return null;
    }

    public String getTooltipText(TableItem tableItem) {
        String string = this.getKey(tableItem);
        if (string != null) {
            IMarker iMarker;
            if (string.equals(this.fDuplicateKey)) {
                return Messages.getString("editor.autoCheck.duplicateKeys", new Object[0]);
            }
            List<IMarker> list = this.fMarkedRows.get(string);
            if (list != null && !list.isEmpty() && (iMarker = list.get(0)).exists()) {
                return MarkerUtilities.getMessage((IMarker)iMarker);
            }
        }
        return null;
    }

    public void paint(GC gC, int n, int n2, TableItem tableItem) {
        String string = this.getKey(tableItem);
        if (string != null) {
            IMarker iMarker;
            List<IMarker> list;
            Image image = null;
            if (string.equals(this.fDuplicateKey)) {
                image = ERROR;
            }
            if (image == null && (list = this.fMarkedRows.get(string)) != null && !list.isEmpty() && (iMarker = list.get(0)).exists()) {
                switch (MarkerUtilities.getSeverity((IMarker)iMarker)) {
                    case 1: {
                        image = WARNING;
                        break;
                    }
                    case 2: {
                        image = ERROR;
                    }
                }
            }
            if (image != null) {
                int n3 = n;
                int n4 = n2 - image.getBounds().height;
                if (n4 > 0) {
                    n3 = (int)((double)n3 + ((double)n4 / 2.0 + 0.5));
                }
                gC.drawImage(image, 0, n3);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IMarkerDelta[] iMarkerDeltaArray = iResourceChangeEvent.findMarkerDeltas("de.guhsoft.jinto.core.bundle.problem", true);
        if (iMarkerDeltaArray != null && iMarkerDeltaArray.length > 0) {
            this.updateMarkedRows();
            if (this.fRuler != null && !this.fRuler.isDisposed()) {
                this.fRuler.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        JIntoMarkerColumn.this.fRuler.redraw();
                    }
                });
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

