/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor;

import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.editor.ResourceEditorRenderer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditorDialog
extends Dialog
implements KeyListener {
    private Text fText;
    private CLabel fErrorLabel;
    private final String fTitle;
    private String fValue;
    private ResourceEditorRenderer fRenderer;
    private boolean fIsKey;

    public EditorDialog(Shell shell, String string, String string2, ResourceEditorRenderer resourceEditorRenderer, boolean bl) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = string;
        this.fValue = string2;
        this.fRenderer = resourceEditorRenderer;
        this.fIsKey = bl;
    }

    public String getValue() {
        return this.fValue;
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        this.fErrorLabel = new CLabel(composite2, 16384);
        this.fErrorLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        this.fText = new Text(composite2, 2816);
        this.fText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fText.setText(this.fValue);
        this.fText.addKeyListener((KeyListener)this);
        return composite2;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.fValue = this.fText.getText().replaceAll("\r", "");
        }
        super.buttonPressed(n);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.stateMask == 262144 && keyEvent.character == '\r') {
            this.buttonPressed(0);
            keyEvent.doit = false;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.fIsKey) {
            String string = this.fRenderer.validateKey(this.fRenderer.getFocusCellManager().getFocusCell(), this.fText.getText());
            if (string != null) {
                this.getButton(0).setEnabled(false);
                this.fErrorLabel.setImage(JIntoUI.getImage("errorIcon"));
                this.fErrorLabel.setText(string);
            } else {
                this.getButton(0).setEnabled(true);
                this.fErrorLabel.setImage(null);
                this.fErrorLabel.setText("");
            }
        } else {
            this.getButton(0).setEnabled(true);
            this.fErrorLabel.setImage(null);
            this.fErrorLabel.setText("");
        }
    }
}

