/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.codeAssist.quickFix;

import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.util.ResourceBundleUtil;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.codeAssist.quickAssist.NewKeyCompletionProposal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIntoQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit iCompilationUnit, int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext iInvocationContext, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (iProblemLocationArray == null || iProblemLocationArray.length == 0) {
            return null;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(iProblemLocationArray.length);
        ArrayList<IJavaCompletionProposal> arrayList = new ArrayList<IJavaCompletionProposal>();
        int n = 0;
        while (n < iProblemLocationArray.length) {
            Integer n2 = new Integer(iProblemLocationArray[n].getProblemId());
            if (hashSet.add(n2)) {
                this.process(iInvocationContext, iProblemLocationArray[n], arrayList);
            }
            ++n;
        }
        return arrayList.toArray(new IJavaCompletionProposal[arrayList.size()]);
    }

    private void process(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection<IJavaCompletionProposal> collection) {
        int n = iProblemLocation.getProblemId();
        if (n == 0) {
            return;
        }
        switch (n) {
            case 1: {
                this.processNonExistingKey(iInvocationContext, iProblemLocation, collection);
            }
        }
    }

    private void processNonExistingKey(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection<IJavaCompletionProposal> collection) {
        String[] stringArray = iProblemLocation.getProblemArguments();
        if (stringArray != null && stringArray.length >= 1) {
            try {
                IJavaProject iJavaProject = iInvocationContext.getCompilationUnit().getJavaProject();
                ResourceBundleModel resourceBundleModel = ResourceBundleUtil.findByName((IJavaProject)iJavaProject, (String)stringArray[0], (boolean)true);
                if (resourceBundleModel != null) {
                    int n = iProblemLocation.getOffset();
                    int n2 = iProblemLocation.getLength();
                    IBuffer iBuffer = iInvocationContext.getCompilationUnit().getBuffer();
                    String string = iBuffer.getText(n + 1, n2 - 2);
                    Region region = new Region(n, n2);
                    Region region2 = new Region(iInvocationContext.getSelectionOffset(), iInvocationContext.getSelectionLength());
                    NewKeyCompletionProposal newKeyCompletionProposal = new NewKeyCompletionProposal(resourceBundleModel, iInvocationContext.getCompilationUnit(), string, (IRegion)region, (IRegion)region2){

                        public String getDisplayString() {
                            return Messages.getString("codeAssist.quickFix.addKey", this.getKey());
                        }

                        public String getAdditionalProposalInfo() {
                            return Messages.getString("codeAssist.quickFix.addKey.info", this.getKey(), this.getModel().getFullyQualifiedName(false));
                        }
                    };
                    collection.add(newKeyCompletionProposal);
                }
            }
            catch (JavaModelException javaModelException) {
                JIntoQuickFixProcessor.log((Exception)((Object)javaModelException));
            }
            catch (IOException iOException) {
                JIntoQuickFixProcessor.log(iOException);
            }
            catch (CoreException coreException) {
                JIntoQuickFixProcessor.log((Exception)((Object)coreException));
            }
        }
    }

    private static void log(Exception exception) {
        String string = "Error while processing nonExistingKey quickfix.";
        Status status = new Status(4, JIntoUI.getID(), string, (Throwable)exception);
        JIntoUI.getDefault().getLog().log((IStatus)status);
    }
}

