/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.codeAssist.quickAssist;

import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.codeAssist.AddNewKeyDialog;
import de.guhsoft.jinto.ui.codeAssist.JIntoCompletionProposal;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class NewKeyCompletionProposal
extends JIntoCompletionProposal {
    private IRegion fOldSelection;

    public NewKeyCompletionProposal(ResourceBundleModel resourceBundleModel, ICompilationUnit iCompilationUnit, String string, IRegion iRegion, IRegion iRegion2) {
        super(resourceBundleModel, iCompilationUnit, string, iRegion, iRegion, 0);
        this.fOldSelection = iRegion2;
    }

    public int getRelevance() {
        return 90;
    }

    public Image getImage() {
        return JIntoUI.getImage("addNewKey");
    }

    public String getDisplayString() {
        return Messages.getString("codeAssist.quickAssist.addNewKey", new Object[0]);
    }

    public String getAdditionalProposalInfo() {
        return Messages.getString("codeAssist.quickAssist.addNewKey.info", this.getModel().getFullyQualifiedName(false));
    }

    public Point getSelection(IDocument iDocument) {
        if (this.getKey() == null) {
            return new Point(this.fOldSelection.getOffset(), this.fOldSelection.getLength());
        }
        return super.getSelection(iDocument);
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        AddNewKeyDialog addNewKeyDialog = new AddNewKeyDialog(iTextViewer.getTextWidget().getShell(), this.getModel(), this.getKey());
        if (addNewKeyDialog.open() == 0) {
            this.setKey(addNewKeyDialog.getKey());
            super.apply(iTextViewer, c, n, n2);
            this.syncMarkers();
        }
    }

    private void syncMarkers() {
        block5: {
            IResource iResource = this.getCompilationUnit().getResource();
            if (iResource != null) {
                try {
                    IMarker[] iMarkerArray = iResource.findMarkers("de.guhsoft.jinto.core.java.problem", false, 0);
                    if (iMarkerArray == null || iMarkerArray.length <= 0) break block5;
                    IRegion iRegion = this.getReplacementRegion();
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        int n2 = iMarkerArray[n].getAttribute("charStart", -1);
                        int n3 = iMarkerArray[n].getAttribute("charEnd", -1);
                        if (iRegion.getOffset() == n2 && iRegion.getLength() == n3 - n2) {
                            iMarkerArray[n].delete();
                            break;
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    Status status = new Status(4, JIntoUI.getID(), "Exception while syncing markers.", (Throwable)coreException);
                    JIntoUI.getDefault().getLog().log((IStatus)status);
                }
            }
        }
    }
}

