/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.codeAssist.quickAssist;

import de.guhsoft.jinto.core.ASTUtil;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfigurationManager;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.codeAssist.quickAssist.NewKeyCompletionProposal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIntoQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext iInvocationContext) throws CoreException {
        ASTNode aSTNode = iInvocationContext.getCoveringNode();
        if (aSTNode != null) {
            return JIntoQuickAssistProcessor.addNewResourceBundleEntry(aSTNode, iInvocationContext, null);
        }
        return false;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext iInvocationContext, IProblemLocation[] iProblemLocationArray) throws CoreException {
        ASTNode aSTNode = iInvocationContext.getCoveringNode();
        if (aSTNode != null) {
            ArrayList<IJavaCompletionProposal> arrayList = new ArrayList<IJavaCompletionProposal>();
            JIntoQuickAssistProcessor.addNewResourceBundleEntry(aSTNode, iInvocationContext, arrayList);
            return arrayList.toArray(new IJavaCompletionProposal[arrayList.size()]);
        }
        return null;
    }

    private static boolean addNewResourceBundleEntry(ASTNode aSTNode, IInvocationContext iInvocationContext, Collection<IJavaCompletionProposal> collection) {
        MethodInvocation methodInvocation;
        IJavaProject iJavaProject = iInvocationContext.getCompilationUnit().getJavaProject();
        ResourceBundleModel resourceBundleModel = null;
        String string = null;
        try {
            if (aSTNode.getNodeType() == 42 && (methodInvocation = ASTUtil.getMethodInvocationParent((SimpleName)((SimpleName)aSTNode))) != null) {
                int n = ASTUtil.indexOf((MethodInvocation)methodInvocation, (ASTNode)aSTNode);
                resourceBundleModel = AccessorConfigurationManager.getInstance().getResourceBundle(iJavaProject, methodInvocation, n);
            }
        }
        catch (JavaModelException javaModelException) {
            JIntoQuickAssistProcessor.log((Exception)((Object)javaModelException));
        }
        catch (IOException iOException) {
            JIntoQuickAssistProcessor.log(iOException);
        }
        catch (CoreException coreException) {
            JIntoQuickAssistProcessor.log((Exception)((Object)coreException));
        }
        if (resourceBundleModel == null) {
            return false;
        }
        if (collection == null) {
            return true;
        }
        methodInvocation = new Region(aSTNode.getStartPosition(), aSTNode.getLength());
        Region region = new Region(iInvocationContext.getSelectionOffset(), iInvocationContext.getSelectionLength());
        collection.add(new NewKeyCompletionProposal(resourceBundleModel, iInvocationContext.getCompilationUnit(), string, (IRegion)methodInvocation, (IRegion)region));
        return true;
    }

    private static void log(Exception exception) {
        String string = "Error while resolving ResourceBundleModel.";
        JIntoUI.getDefault().getLog().log((IStatus)new Status(4, JIntoUI.getID(), string, (Throwable)exception));
    }
}

