/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.codeAssist;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceFile;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import de.guhsoft.jinto.core.util.LocaleComparator;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class AddNewKeyDialog
extends TitleAreaDialog {
    ResourceBundleModel fModel;
    private String fKey;
    private Text fKeyField;
    TableViewer fTableViewer;

    public AddNewKeyDialog(Shell shell, ResourceBundleModel resourceBundleModel) {
        this(shell, resourceBundleModel, null);
    }

    public AddNewKeyDialog(Shell shell, ResourceBundleModel resourceBundleModel, String string) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fModel = resourceBundleModel;
        this.fKey = string;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(Math.max(400, point.x), Math.max(550, point.y));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("codeAssist.quickAssist.addNewKeyDialog.title", new Object[0]));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.setHelpAvailable(false);
        this.setTitle(Messages.getString("codeAssist.quickAssist.addNewKeyDialog.titleMessage", this.fModel.getFullyQualifiedName(false)));
        this.setMessage(Messages.getString("codeAssist.quickAssist.addNewKeyDialog.message", new Object[0]));
        this.setTitleImage(JIntoUI.getImage("addNewKeyWizard"));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1808));
        composite3.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite3, 0);
        label.setText(Messages.getString("codeAssist.quickAssist.addNewKeyDialog.labelKey", new Object[0]));
        int n = 2048;
        if (this.fKey != null) {
            n |= 8;
        }
        this.fKeyField = new Text(composite3, n);
        this.fKeyField.setLayoutData((Object)new GridData(768));
        this.installKeyAutocompletion(this.fKeyField);
        Composite composite4 = new Composite(composite3, 2048);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite4.setLayout((Layout)gridLayout);
        final SashForm sashForm = new SashForm(composite4, 512);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new TableViewer((Composite)sashForm, 65540);
        final Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fTableViewer, 16384);
        final TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(Messages.getString("codeAssist.quickAssist.addNewKeyDialog.column.locale", new Object[0]));
        tableColumn.setResizable(false);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                ResourceFile resourceFile = ((TableRow)object).getResourceFile();
                return resourceFile.getResourceKey();
            }

            public Image getImage(Object object) {
                String string = ((TableRow)object).getMessage();
                if (string == null || string.length() == 0) {
                    return JIntoUI.getImage("warningIcon");
                }
                return JIntoUI.getImage("okIcon");
            }
        });
        tableViewerColumn = new TableViewerColumn(this.fTableViewer, 16384);
        final TableColumn tableColumn2 = tableViewerColumn.getColumn();
        tableColumn2.setText(Messages.getString("codeAssist.quickAssist.addNewKeyDialog.column.messages", new Object[0]));
        tableColumn2.setResizable(false);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((TableRow)object).getMessage();
            }
        });
        this.fTableViewer.setSorter(new ViewerSorter(){
            private final LocaleComparator fComparator = new LocaleComparator();

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof TableRow && object2 instanceof TableRow) {
                    Locale locale = ((TableRow)object).getResourceFile().getLocaleInfos();
                    Locale locale2 = ((TableRow)object2).getResourceFile().getLocaleInfos();
                    return this.fComparator.compare(locale, locale2);
                }
                return super.compare(viewer, object, object2);
            }
        });
        int n2 = this.fModel.getResourceFileCount();
        TableRow[] tableRowArray = new TableRow[n2];
        int n3 = 0;
        while (n3 < n2) {
            tableRowArray[n3] = new TableRow((ResourceFile)this.fModel.getResourceFileMapEntry(n3).getValue());
            ++n3;
        }
        this.fTableViewer.setInput((Object)tableRowArray);
        Composite composite5 = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite5.setLayout((Layout)gridLayout);
        Label label2 = new Label(composite5, 258);
        label2.setLayoutData((Object)new GridData(768));
        final Text text = new Text(composite5, 770);
        text.setLayoutData((Object)new GridData(1808));
        text.setEnabled(false);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TableRow tableRow;
                ISelection iSelection = AddNewKeyDialog.this.fTableViewer.getSelection();
                if (iSelection instanceof IStructuredSelection && (tableRow = (TableRow)((IStructuredSelection)iSelection).getFirstElement()) != null) {
                    tableRow.setMessage(Util.escapeForLabel((String)text.getText().trim()));
                    AddNewKeyDialog.this.fTableViewer.refresh((Object)tableRow, true);
                }
                AddNewKeyDialog.this.validate();
            }
        });
        table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AddNewKeyDialog.this.selectionChanged(AddNewKeyDialog.this.fTableViewer.getSelection(), text);
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AddNewKeyDialog.this.selectionChanged(selectionChangedEvent.getSelection(), text);
            }
        });
        this.fKeyField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 16) {
                    AddNewKeyDialog.this.tableTabNext(false);
                    traverseEvent.doit = false;
                }
            }
        });
        this.fKeyField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AddNewKeyDialog.this.validate();
            }
        });
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 16 && (traverseEvent.stateMask & 0x40000) != 0) {
                    if (AddNewKeyDialog.this.isLastRowSelected()) {
                        AddNewKeyDialog.this.fTableViewer.setSelection((ISelection)new StructuredSelection());
                        AddNewKeyDialog.this.getButton(0).setFocus();
                    } else {
                        AddNewKeyDialog.this.tableTabNext(true);
                        text.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                text.setFocus();
                            }
                        });
                    }
                }
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.stateMask == 262144 && keyEvent.character == '\r') {
                    AddNewKeyDialog.this.buttonPressed(0);
                    keyEvent.doit = false;
                }
            }
        });
        composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                int n;
                int n2;
                ScrollBar scrollBar;
                table.setRedraw(false);
                tableColumn.pack();
                tableColumn2.pack();
                Rectangle rectangle = table.getClientArea();
                int n3 = rectangle.width;
                if (table.getItemCount() > rectangle.height / table.getItemHeight() && (scrollBar = table.getVerticalBar()) != null) {
                    n3 -= scrollBar.getSize().x;
                }
                if ((n2 = tableColumn2.getWidth()) != (n = Math.max(n2, n3 -= tableColumn.getWidth() + table.getGridLineWidth()))) {
                    tableColumn2.setWidth(n);
                }
                table.setRedraw(true);
                int n4 = table.getHeaderHeight() + table.getItemCount() * (table.getItemHeight() + table.getGridLineWidth()) + table.computeTrim((int)0, (int)0, (int)0, (int)0).height;
                Rectangle rectangle2 = sashForm.getClientArea();
                if (n4 < rectangle2.height) {
                    sashForm.setWeights(new int[]{n4, rectangle2.height - n4});
                }
            }
        });
        if (this.fKey != null) {
            this.fKeyField.setText(this.fKey);
            this.tableTabNext(false);
        }
        return composite2;
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private void installKeyAutocompletion(Text text) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.fModel.getRowKeys();
        while (iterator.hasNext()) {
            linkedList.add((String)iterator.next());
        }
        iterator = new TextContentAdapter();
        SimpleContentProposalProvider simpleContentProposalProvider = new SimpleContentProposalProvider(linkedList.toArray(new String[linkedList.size()]));
        simpleContentProposalProvider.setFiltering(true);
        KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)32);
        ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)iterator, (IContentProposalProvider)simpleContentProposalProvider, keyStroke, null);
        contentProposalAdapter.setPropagateKeys(true);
        contentProposalAdapter.setProposalAcceptanceStyle(2);
        contentProposalAdapter.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((IContentProposal)object).getContent();
            }

            public Image getImage(Object object) {
                return JIntoUI.getImage("key");
            }
        });
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.setDescriptionText(String.valueOf(fieldDecoration.getDescription()) + " (" + keyStroke.format() + ")");
        controlDecoration.setShowOnlyOnFocus(true);
    }

    void validate() {
        String string = null;
        String string2 = this.fKeyField.getText().trim();
        if (string2.length() == 0) {
            string = Messages.getString("codeAssist.quickAssist.addNewKeyDialog.keyEmpty", new Object[0]);
        }
        if (string == null && this.fModel.getRow(string2) != null) {
            string = Messages.getString("codeAssist.quickAssist.addNewKeyDialog.keyExists", new Object[0]);
        }
        boolean bl = false;
        TableRow[] tableRowArray = (TableRow[])this.fTableViewer.getInput();
        int n = 0;
        while (n < tableRowArray.length) {
            if (tableRowArray[n].getMessage() != null && tableRowArray[n].getMessage().length() > 0) {
                bl = true;
                break;
            }
            ++n;
        }
        this.setErrorMessage(string);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(bl && string == null);
        }
    }

    void selectionChanged(ISelection iSelection, Text text) {
        if (iSelection instanceof IStructuredSelection) {
            TableRow tableRow = (TableRow)((IStructuredSelection)iSelection).getFirstElement();
            if (tableRow != null) {
                String string;
                if (!text.isEnabled()) {
                    text.setEnabled(true);
                }
                if ((string = tableRow.getMessage()) == null) {
                    string = "";
                }
                String string2 = Util.unescapeForLabel((String)string);
                text.setText(string2);
                text.setSelection(0, string2.length());
                text.setFocus();
            } else {
                text.setText("");
                text.setEnabled(false);
            }
        }
    }

    boolean isLastRowSelected() {
        Object object = null;
        ISelection iSelection = this.fTableViewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
        }
        Object object2 = this.fTableViewer.getInput();
        Object[] objectArray = ((IStructuredContentProvider)this.fTableViewer.getContentProvider()).getElements(object2);
        this.fTableViewer.getSorter().sort((Viewer)this.fTableViewer, objectArray);
        return objectArray[objectArray.length - 1].equals(object);
    }

    void tableTabNext(boolean bl) {
        ISelection iSelection;
        Object object = this.fTableViewer.getInput();
        Object[] objectArray = ((IStructuredContentProvider)this.fTableViewer.getContentProvider()).getElements(object);
        this.fTableViewer.getSorter().sort((Viewer)this.fTableViewer, objectArray);
        Object object2 = objectArray[0];
        if (bl && (iSelection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            Object object3 = ((IStructuredSelection)iSelection).getFirstElement();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].equals(object3)) {
                    if (n + 1 >= objectArray.length) break;
                    object2 = objectArray[n + 1];
                    break;
                }
                ++n;
            }
        }
        this.fTableViewer.setSelection((ISelection)new StructuredSelection(object2));
    }

    protected void okPressed() {
        Object object;
        this.fKey = this.fKeyField.getText().trim();
        TableRow[] tableRowArray = (TableRow[])this.fTableViewer.getInput();
        ResourceRow resourceRow = new ResourceRow(this.fKey, this.fModel);
        int n = 0;
        while (n < tableRowArray.length) {
            String string = tableRowArray[n].getResourceFile().getResourceKey();
            object = tableRowArray[n].getMessage();
            if (object != null) {
                resourceRow.setColumnValue(string, (String)object, false);
            }
            ++n;
        }
        this.fModel.addRow(this.fKey, resourceRow, false);
        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
        try {
            iProgressService.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    boolean bl = JIntoCore.getPreferences().getBoolean(IPreferenceConstants.SAVING_EMPTY_VALUES.key(), ((Boolean)IPreferenceConstants.SAVING_EMPTY_VALUES.defaultValue()).booleanValue());
                    boolean bl2 = JIntoCore.getPreferences().getBoolean(IPreferenceConstants.SAVING_INCLUDE_HEADER.key(), ((Boolean)IPreferenceConstants.SAVING_INCLUDE_HEADER.defaultValue()).booleanValue());
                    try {
                        AddNewKeyDialog.this.fModel.save(iProgressMonitor, bl, bl2);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            });
            super.okPressed();
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getCause();
            if (object == null) {
                object = invocationTargetException;
            }
            Status status = new Status(4, JIntoUI.getID(), 4, "Exception occurs", (Throwable)object);
            JIntoUI.getDefault().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("error.saving", new Object[0]), (IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            object = new Status(4, JIntoUI.getID(), 4, "IOException occurs", (Throwable)interruptedException);
            JIntoUI.getDefault().getLog().log((IStatus)object);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("error.dialog.title", new Object[0]), (String)Messages.getString("error.saving", new Object[0]), (IStatus)object);
        }
    }

    public String getKey() {
        return this.fKey;
    }

    private static class TableRow {
        private ResourceFile fResourceFile;
        private String fMessage;

        public TableRow(ResourceFile resourceFile) {
            this.fResourceFile = resourceFile;
            this.fMessage = null;
        }

        public ResourceFile getResourceFile() {
            return this.fResourceFile;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public void setMessage(String string) {
            this.fMessage = string;
        }
    }
}

