/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui;

import de.guhsoft.jinto.ui.Constants;
import de.guhsoft.jinto.ui.preferences.MainPreferencePage;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JIntoUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "de.guhsoft.jinto.ui";
    public static final String ICON_ADD = "addIcon";
    public static final String ICON_REMOVE = "removeIcon";
    public static final String ICON_WARN = "warningIcon";
    public static final String ICON_ERROR = "errorIcon";
    public static final String ICON_OK = "okIcon";
    public static final String ICON_RESOURCE_BUNDLE = "resourceBundle";
    public static final String ICON_KEY = "key";
    public static final String ICON_KEYLESS = "keyless";
    public static final String ICON_COLLAPSE_ALL = "collapseAll";
    public static final String ICON_PARAMETER = "parameter";
    public static final String ICON_INVALID_PARAMETER = "nonvalidParameter";
    public static final String ICON_SEARCH = "search";
    public static final String ICON_SEARCH_UNUSED_KEYS = "search/unusedKeys";
    public static final String ICON_SEARCH_UNUSED_KEY = "search/unusedKey";
    public static final String ICON_SEARCH_UNDEFINIED_KEYS = "search/undefiniedKeys";
    public static final String ICON_SEARCH_INDETERMINABLE_KEYS = "search/indeterminableKeys";
    public static final String ICON_COLUMNS_DISPLAY = "columnsDisplay";
    public static final String ICON_NEW_RESOURCE_FILE_WIZARD = "newResourceFileWizard";
    public static final String ICON_ADD_NEW_KEY = "addNewKey";
    public static final String ICON_ADD_NEW_KEY_WIZARD = "addNewKeyWizard";
    public static final String ICON_CLASS_OBJECT = "classObject";
    public static final String ICON_PUBLIC_METHOD = "publicMethod";
    public static final String ICON_PROJECT = "project";
    private static JIntoUI plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        MainPreferencePage.getVirtualTextColor().dispose();
        Constants.RED.dispose();
        Constants.BLUE.dispose();
        Constants.ITALIC.dispose();
        plugin = null;
    }

    public static JIntoUI getDefault() {
        return plugin;
    }

    public static String getID() {
        return JIntoUI.getDefault().getBundle().getSymbolicName();
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        super.initializeImageRegistry(imageRegistry);
        imageRegistry.put(ICON_ADD, JIntoUI.createImage("icons/add.gif"));
        imageRegistry.put(ICON_REMOVE, JIntoUI.createImage("icons/remove.gif"));
        imageRegistry.put(ICON_OK, JIntoUI.createImage("icons/ok.png"));
        imageRegistry.put(ICON_WARN, JIntoUI.createImage("icons/warning.gif"));
        imageRegistry.put(ICON_ERROR, JIntoUI.createImage("icons/error.gif"));
        imageRegistry.put(ICON_RESOURCE_BUNDLE, JIntoUI.createImage("icons/editor.gif"));
        imageRegistry.put(ICON_KEY, JIntoUI.createImage("icons/key.gif"));
        imageRegistry.put(ICON_KEYLESS, JIntoUI.createImage("icons/keyless.gif"));
        imageRegistry.put(ICON_COLLAPSE_ALL, JIntoUI.createImageDescriptor("icons/collapse.gif"));
        imageRegistry.put(ICON_PARAMETER, JIntoUI.createImageDescriptor("icons/parameter.gif"));
        imageRegistry.put(ICON_INVALID_PARAMETER, JIntoUI.createImageDescriptor("icons/parameterNonvalid.gif"));
        imageRegistry.put(ICON_SEARCH, JIntoUI.createImageDescriptor("icons/search.gif"));
        imageRegistry.put(ICON_SEARCH_UNUSED_KEYS, JIntoUI.createImage("icons/search/unusedKeys.gif"));
        imageRegistry.put(ICON_SEARCH_UNUSED_KEY, JIntoUI.createImage("icons/search/unusedKey.gif"));
        imageRegistry.put(ICON_SEARCH_UNDEFINIED_KEYS, JIntoUI.createImage("icons/search/undefiniedKeys.gif"));
        imageRegistry.put(ICON_SEARCH_INDETERMINABLE_KEYS, JIntoUI.createImage("icons/search/indeterminableKeys.gif"));
        imageRegistry.put(ICON_COLUMNS_DISPLAY, JIntoUI.createImage("icons/columnsDisplay.png"));
        imageRegistry.put(ICON_NEW_RESOURCE_FILE_WIZARD, JIntoUI.createImageDescriptor("icons/newResourceFileWizard.png"));
        imageRegistry.put(ICON_ADD_NEW_KEY, JIntoUI.createImage("icons/addNewKey.gif"));
        imageRegistry.put(ICON_ADD_NEW_KEY_WIZARD, JIntoUI.createImage("icons/addNewKeyWizard.png"));
        imageRegistry.put(ICON_CLASS_OBJECT, JIntoUI.createImage("icons/classObject.gif"));
        imageRegistry.put(ICON_PUBLIC_METHOD, JIntoUI.createImage("icons/publicMethod.gif"));
        imageRegistry.put(ICON_PROJECT, JIntoUI.createImage("icons/projects.gif"));
    }

    public static Image getImage(String string) {
        return JIntoUI.getDefault().getImageRegistry().get(string);
    }

    public static ImageDescriptor getDescriptor(String string) {
        return JIntoUI.getDefault().getImageRegistry().getDescriptor(string);
    }

    private static Image createImage(String string) {
        return JIntoUI.createImageDescriptor(string).createImage();
    }

    private static ImageDescriptor createImageDescriptor(String string) {
        URL uRL = null;
        try {
            uRL = new URL(JIntoUI.getDefault().getBundle().getEntry("/"), string);
        }
        catch (MalformedURLException malformedURLException) {}
        return ImageDescriptor.createFromURL(uRL);
    }
}

