/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSetDISI;

public class CachingWrapperFilter
extends Filter {
    protected Filter filter;
    protected transient Map cache;

    public CachingWrapperFilter(Filter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        Object cached = null;
        Map map = this.cache;
        synchronized (map) {
            cached = this.cache.get(reader);
        }
        if (cached != null) {
            if (cached instanceof BitSet) {
                return cached;
            }
            if (cached instanceof DocIdBitSet) {
                return ((DocIdBitSet)cached).getBitSet();
            }
        }
        BitSet bits = this.filter.bits(reader);
        Map map2 = this.cache;
        synchronized (map2) {
            this.cache.put(reader, bits);
        }
        return bits;
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, IndexReader reader) throws IOException {
        if (docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        return it == null ? DocIdSet.EMPTY_DOCIDSET : new OpenBitSetDISI(it, reader.maxDoc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        Object cached = null;
        Map map = this.cache;
        synchronized (map) {
            cached = this.cache.get(reader);
        }
        if (cached != null) {
            if (cached instanceof DocIdSet) {
                return cached;
            }
            return new DocIdBitSet(cached);
        }
        DocIdSet docIdSet = this.docIdSetToCache(this.filter.getDocIdSet(reader), reader);
        if (docIdSet != null) {
            Map map2 = this.cache;
            synchronized (map2) {
                this.cache.put(reader, docIdSet);
            }
        }
        return docIdSet;
    }

    public String toString() {
        return "CachingWrapperFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

