/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.jobs;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.actions.ShowExceptionAction;
import it.unibz.instasearch.jobs.UpdatePluginJob;
import it.unibz.instasearch.ui.InstaSearchUI;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class CheckUpdatesJob
extends WorkspaceJob {
    public static final int UPDATE_AVAILABLE_CODE = 1;
    public static final int NO_UPDATE_AVAILABLE_CODE = 2;
    private boolean updateAvailable;

    public CheckUpdatesJob() {
        super("InstaSearch Update Check");
        this.setProperty(IProgressConstants.ICON_PROPERTY, InstaSearchPlugin.getImageDescriptor("update"));
        this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
        this.setProperty(IProgressConstants.KEEPONE_PROPERTY, Boolean.TRUE);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        block4: {
            try {
                this.checkForUpdates(monitor);
                if (!this.isSystem()) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IAction action = CheckUpdatesJob.this.isUpdateAvailable() ? CheckUpdatesJob.createUpdateNotificationAction() : CheckUpdatesJob.this.createNoUpdateNotificationAction();
                            action.run();
                        }
                    });
                }
            }
            catch (Exception e) {
                ShowExceptionAction action = new ShowExceptionAction(e, "Error Checking Updates");
                this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)action);
                if (!this.isSystem()) {
                    this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                }
                if (this.isSystem()) break block4;
                InstaSearchPlugin.log(e);
                return new Status(4, InstaSearchPlugin.getPluginId(), 0, action.getText(), (Throwable)e);
            }
        }
        int returnCode = this.isUpdateAvailable() ? 1 : 2;
        return new Status(0, InstaSearchPlugin.getPluginId(), returnCode, "Done", null);
    }

    private boolean checkForUpdates(IProgressMonitor monitor) throws HttpException, IOException, URISyntaxException {
        this.updateAvailable = false;
        String versionCheckUrl = InstaSearchPlugin.getUpdateLocation();
        String v = InstaSearchPlugin.getVersion();
        HttpClient httpClient = new HttpClient();
        this.configureProxy(httpClient, versionCheckUrl);
        GetMethod getMethod = new GetMethod(String.valueOf(versionCheckUrl) + "?v=" + v);
        int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
        if (statusCode != 200) {
            return this.updateAvailable;
        }
        String response = getMethod.getResponseBodyAsString();
        getMethod.releaseConnection();
        if ("y".equals(response)) {
            this.updateAvailable = true;
        }
        return this.updateAvailable;
    }

    private void configureProxy(HttpClient httpClient, String versionCheckUrl) throws URISyntaxException {
        IProxyService proxyService = InstaSearchPlugin.getDefault().getProxyService();
        if (proxyService != null && proxyService.isProxiesEnabled()) {
            URI uri = new URI(versionCheckUrl);
            IProxyData[] proxiesData = proxyService.select(uri);
            IProxyData proxy = null;
            IProxyData[] iProxyDataArray = proxiesData;
            int n = proxiesData.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData proxyData = iProxyDataArray[n2];
                if (proxyData.getType().equals("HTTP")) {
                    proxy = proxyData;
                    break;
                }
                ++n2;
            }
            if (proxy == null) {
                return;
            }
            HostConfiguration config = httpClient.getHostConfiguration();
            config.setProxy(proxy.getHost(), proxy.getPort());
            if (proxy.isRequiresAuthentication()) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxy.getUserId(), proxy.getPassword());
                AuthScope authScope = new AuthScope(proxy.getHost(), proxy.getPort());
                httpClient.getState().setProxyCredentials(authScope, (Credentials)credentials);
            }
        }
    }

    private IAction createNoUpdateNotificationAction() {
        String text = "No Update Available";
        Action notificationAction = new Action(text){

            public void run() {
                InstaSearchUI.showMessage("You have the latest version (" + InstaSearchPlugin.getVersion() + ")");
                this.setEnabled(false);
            }
        };
        notificationAction.setDescription(text);
        notificationAction.setToolTipText(text);
        return notificationAction;
    }

    public static IAction createUpdateNotificationAction() {
        String text = "New Version Available";
        Action notificationAction = new Action("Update"){

            public void run() {
                boolean update = MessageDialog.openQuestion((Shell)InstaSearchUI.getActiveShell(), (String)this.getDescription(), (String)"There is a new version available. Update?");
                if (update) {
                    UpdatePluginJob updateJob = new UpdatePluginJob();
                    updateJob.schedule();
                }
            }
        };
        notificationAction.setDescription(text);
        notificationAction.setToolTipText(text);
        return notificationAction;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public boolean belongsTo(Object family) {
        return family == CheckUpdatesJob.class;
    }
}

