/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.tokenizers;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public abstract class TermSplitTokenizer
extends TokenFilter {
    private LinkedList<Token> tokens = new LinkedList();
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private PositionIncrementAttribute posAtt;

    public TermSplitTokenizer(TokenStream in) {
        super(in);
        assert (in.hasAttribute(TermAttribute.class));
        assert (in.hasAttribute(OffsetAttribute.class));
        assert (in.hasAttribute(PositionIncrementAttribute.class));
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (!this.tokens.isEmpty()) {
            this.applyToken(this.tokens.removeFirst());
        } else if (this.input.incrementToken()) {
            this.splitIntoTokens();
            if (!this.tokens.isEmpty() && !this.returnOriginalTerm()) {
                this.applyToken(this.tokens.removeFirst());
            }
        } else {
            return false;
        }
        return true;
    }

    private void splitIntoTokens() {
        String term = this.termAtt.term();
        String[] termParts = this.splitTerm(term);
        if (termParts.length > 1) {
            int termPos = this.offsetAtt.startOffset();
            int i = 0;
            while (i < termParts.length) {
                String termPart = termParts[i];
                int termPartPos = termPos + term.indexOf(termPart);
                int termPartEndPos = termPartPos + termPart.length();
                Token newToken = new Token(termPart, termPartPos, termPartEndPos);
                newToken.setPositionIncrement(0);
                this.tokens.add(newToken);
                ++i;
            }
        }
    }

    private void applyToken(Token token) {
        this.termAtt.setTermBuffer(token.termBuffer(), 0, token.termLength());
        this.posAtt.setPositionIncrement(token.getPositionIncrement());
        this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
    }

    protected boolean returnOriginalTerm() {
        return false;
    }

    public abstract String[] splitTerm(String var1);
}

