/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class QueryFuzzifier
extends QueryVisitor {
    @Override
    public Query visit(TermQuery termQuery, Field field) {
        if (field != Field.CONTENTS) {
            return termQuery;
        }
        Term term = termQuery.getTerm();
        PrefixQuery prefixQuery = new PrefixQuery(term);
        prefixQuery.setBoost(termQuery.getBoost());
        Term wildcardTerm = Field.CONTENTS.createTerm("*" + term.text() + "*");
        WildcardQuery wildcardQuery = new WildcardQuery(wildcardTerm);
        wildcardQuery.setBoost(termQuery.getBoost() * 0.75f);
        FuzzyQuery fuzzyQuery = new FuzzyQuery(term);
        fuzzyQuery.setBoost(termQuery.getBoost() * 0.5f);
        BooleanQuery boolQuery = new BooleanQuery();
        boolQuery.add((Query)prefixQuery, BooleanClause.Occur.SHOULD);
        boolQuery.add((Query)wildcardQuery, BooleanClause.Occur.SHOULD);
        boolQuery.add((Query)fuzzyQuery, BooleanClause.Occur.SHOULD);
        boolQuery.setBoost(termQuery.getBoost());
        return boolQuery;
    }

    @Override
    public Query visit(PhraseQuery phraseQuery) {
        BooleanQuery bq = new BooleanQuery();
        Term[] termArray = phraseQuery.getTerms();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            Field f = Field.getByName(t.field());
            if (f != Field.CONTENTS) {
                return phraseQuery;
            }
            bq.add((Query)new FuzzyQuery(t), BooleanClause.Occur.SHOULD);
            ++n2;
        }
        return bq;
    }

    @Override
    public boolean visit(BooleanClause boolClause) {
        return boolClause.getOccur() != BooleanClause.Occur.MUST_NOT;
    }
}

