/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;

public class ModifiedTimeConverter
extends QueryVisitor {
    private static ArrayList<String> intervalNames = new ArrayList();
    private static Calendar cal = Calendar.getInstance();

    static {
        Interval[] intervalArray = Interval.values();
        int n = intervalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Interval interval = intervalArray[n2];
            intervalNames.add(interval.toString().toLowerCase(Locale.ENGLISH));
            ++n2;
        }
        intervalNames.add("3 days");
    }

    public static List<String> getDurationNames() {
        return intervalNames;
    }

    @Override
    public Query visit(TermQuery termQuery, Field termField) {
        Interval interval;
        if (termField != Field.MODIFIED) {
            return super.visit(termQuery, termField);
        }
        Term t = termQuery.getTerm();
        String intervalName = t.text();
        int multiplier = 1;
        if (intervalName.matches("^[0-9]+.*$")) {
            String multiplierString = intervalName.replaceAll("[^0-9]+", "");
            multiplier = NumberUtils.toInt((String)multiplierString.trim(), (int)1);
            intervalName = intervalName.replaceAll("[0-9 ]+", "").trim();
        }
        if (intervalName.endsWith("s")) {
            intervalName = intervalName.substring(0, intervalName.length() - 1);
        }
        if ((interval = ModifiedTimeConverter.getIntervalByName(intervalName)) == null) {
            return super.visit(termQuery, termField);
        }
        long start = 0L;
        long end = System.currentTimeMillis();
        cal.setTimeInMillis(end);
        switch (interval) {
            case TODAY: {
                cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
                start = cal.getTimeInMillis();
                break;
            }
            case YESTERDAY: {
                cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
                end = cal.getTimeInMillis();
                cal.add(5, -1);
                start = cal.getTimeInMillis();
                break;
            }
            default: {
                start = end - (long)multiplier * interval.millis;
            }
        }
        String field = Field.MODIFIED.name().toLowerCase(Locale.ENGLISH);
        return new TermRangeQuery(field, "" + start, "" + end, true, true);
    }

    private static Interval getIntervalByName(String intervalName) {
        try {
            return Interval.valueOf(intervalName.toUpperCase());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static enum Interval {
        TODAY,
        YESTERDAY,
        HOUR(TimeUnit.HOURS.toMillis(1L)),
        DAY(TimeUnit.DAYS.toMillis(1L)),
        WEEK(TimeUnit.DAYS.toMillis(7L)),
        MONTH(TimeUnit.DAYS.toMillis(30L));

        private long millis;

        private Interval() {
        }

        private Interval(long millis) {
            this.millis = millis;
        }
    }
}

