/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.Searcher;
import it.unibz.instasearch.indexing.WorkspaceIndexer;
import it.unibz.instasearch.indexing.WorkspaceIndexerJDT;
import it.unibz.instasearch.jobs.DeleteIndexJob;
import it.unibz.instasearch.jobs.IndexUpdateJob;
import it.unibz.instasearch.jobs.IndexingJob;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class InstaSearch {
    private WorkspaceIndexer indexer;
    private Searcher searcher;
    private IndexingJob indexingJob;
    private IndexUpdateJob indexUpdateJob;

    InstaSearch() throws Exception {
        try {
            this.indexer = new WorkspaceIndexerJDT();
        }
        catch (Throwable ignored) {
            InstaSearchPlugin.debug(ignored);
        }
        if (this.indexer == null) {
            this.indexer = new WorkspaceIndexer();
        }
        this.searcher = new Searcher(this.getSearcherConfig());
        this.indexer.setIndexChangeListener(this.searcher);
        InstaSearchPlugin.addPreferenceChangeListener(this.indexer);
        InstaSearchPlugin.addPreferenceChangeListener(this.searcher);
        String lastVer = InstaSearchPlugin.getDefault().getPreferenceStore().getString("version");
        String curVer = InstaSearchPlugin.getVersion();
        InstaSearchPlugin.getDefault().getPreferenceStore().setValue("version", curVer);
        if (!(this.indexer.isIndexed() && this.indexer.isReadable() && curVer.equals(lastVer))) {
            this.createIndex();
        } else {
            this.searcher.onIndexUpdate();
        }
        int indexUpdateInterval = InstaSearchPlugin.getIntPref("indexUpdateInterval");
        boolean indexUpdateEnabled = InstaSearchPlugin.getBoolPref("indexUpdateEnabled");
        this.indexUpdateJob = new IndexUpdateJob(this.indexer, this.searcher);
        this.indexUpdateJob.setSystem(true);
        if (indexUpdateEnabled && indexUpdateInterval > 0) {
            this.indexUpdateJob.schedule(indexUpdateInterval);
        }
        InstaSearchPlugin.addPreferenceChangeListener(this.indexUpdateJob);
    }

    public WorkspaceIndexer getIndexer() {
        return this.indexer;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void rebuildIndex() {
        this.createIndex();
    }

    public void deleteIndex() {
        DeleteIndexJob deleteIndexJob = new DeleteIndexJob(this.indexer);
        deleteIndexJob.schedule();
    }

    public boolean isIndexing() {
        if (this.indexingJob == null) {
            return false;
        }
        return this.indexingJob.getState() == 4 || this.indexingJob.getState() == 2;
    }

    public void createIndex() {
        if (this.indexingJob == null) {
            this.indexingJob = new IndexingJob(this.indexer);
            this.indexingJob.setPriority(30);
        } else if (this.isIndexing()) {
            return;
        }
        this.indexingJob.schedule();
    }

    void cancelJobs() {
        if (this.indexingJob != null) {
            this.indexingJob.cancel();
        }
        if (this.indexUpdateJob != null) {
            this.indexUpdateJob.cancel();
        }
    }

    public void updateIndex() {
        if (this.indexUpdateJob != null) {
            this.indexUpdateJob.cancel();
            this.indexUpdateJob.schedule();
        }
    }

    public Searcher.SearcherConfig getSearcherConfig() {
        return new Searcher.SearcherConfig(){

            @Override
            public Directory getIndexDir() throws IOException {
                return FSDirectory.getDirectory((File)InstaSearchPlugin.getIndexDirLocation(), (boolean)false);
            }

            @Override
            public boolean getBoolPref(String pref) {
                return InstaSearchPlugin.getBoolPref(pref);
            }

            @Override
            public void log(Exception e) {
                InstaSearchPlugin.log(e);
            }
        };
    }
}

