/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MutexSchedulingRule
implements ISchedulingRule {
    public static final int MAX_JOBS = Runtime.getRuntime().availableProcessors();
    public static final boolean MULTICORE = MAX_JOBS > 1;
    private final IResource resource;

    public MutexSchedulingRule(IResource resource) {
        this.resource = resource;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (!(rule instanceof MutexSchedulingRule)) {
            return false;
        }
        MutexSchedulingRule mRule = (MutexSchedulingRule)rule;
        if (this.resource == null || mRule.resource == null) {
            return true;
        }
        if (MULTICORE) {
            return this.resource.contains((ISchedulingRule)mRule.resource);
        }
        return true;
    }

    public boolean contains(ISchedulingRule rule) {
        return this.isConflicting(rule);
    }

    public String toString() {
        return "MutexSchedulingRule, resource: " + this.resource;
    }
}

