/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ConditionCheck;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IMarkerResolution;

public class BugResolutionAssociations {
    private final Map<String, Set<Class<? extends IMarkerResolution>>> resolutionClasses;
    private final Map<String, Set<IMarkerResolution>> resolutions;

    protected BugResolutionAssociations(Map<String, Set<Class<? extends IMarkerResolution>>> resolutionClasses, Map<String, Set<IMarkerResolution>> resolutions) {
        if (resolutionClasses == null) {
            resolutionClasses = new Hashtable<String, Set<Class<? extends IMarkerResolution>>>();
        }
        if (resolutions == null) {
            resolutions = new Hashtable<String, Set<IMarkerResolution>>();
        }
        this.resolutionClasses = resolutionClasses;
        this.resolutions = resolutions;
    }

    protected BugResolutionAssociations(Map<String, Set<Class<? extends IMarkerResolution>>> resolutionClasses) {
        this(resolutionClasses, null);
    }

    public BugResolutionAssociations() {
        this(null);
    }

    public boolean registerBugResolution(String bugType, Class<? extends IMarkerResolution> resolutionClass) {
        ConditionCheck.checkForNull(bugType, "bug type");
        HashSet<Class<? extends IMarkerResolution>> classes = new HashSet<Class<? extends IMarkerResolution>>();
        classes.add(resolutionClass);
        return this.registerBugResolutions(bugType, classes);
    }

    public boolean deregisterBugResolution(String bugType, Class<? extends IMarkerResolution> resolutionClass) {
        ConditionCheck.checkForNull(bugType, "bug type");
        HashSet<Class<? extends IMarkerResolution>> classes = new HashSet<Class<? extends IMarkerResolution>>();
        classes.add(resolutionClass);
        return this.deregisterBugResolutions(bugType, classes);
    }

    protected boolean registerBugResolutions(String bugType, Set<Class<? extends IMarkerResolution>> resolutionClasses) {
        Assert.isNotNull((Object)bugType);
        Assert.isNotNull(resolutionClasses);
        if (resolutionClasses.isEmpty()) {
            return false;
        }
        Set<Class<? extends IMarkerResolution>> classes = this.resolutionClasses.get(bugType);
        if (classes != null) {
            return classes.addAll(resolutionClasses);
        }
        this.resolutionClasses.put(bugType, resolutionClasses);
        return true;
    }

    protected boolean deregisterBugResolutions(String bugType, Set<Class<? extends IMarkerResolution>> resolutionClasses) {
        Assert.isNotNull((Object)bugType);
        Assert.isNotNull(resolutionClasses);
        if (resolutionClasses.isEmpty()) {
            return false;
        }
        Set<Class<? extends IMarkerResolution>> classes = this.resolutionClasses.get(bugType);
        if (classes == null) {
            return false;
        }
        classes.removeAll(resolutionClasses);
        if (classes.isEmpty()) {
            this.resolutionClasses.remove(bugType);
        }
        return true;
    }

    public boolean addBugResolution(String bugType, IMarkerResolution bugFix) {
        return this.addBugResolutions(bugType, bugFix);
    }

    public boolean addBugResolutions(String bugType, IMarkerResolution ... resolutions) {
        Assert.isNotNull((Object)bugType);
        if (resolutions.length == 0) {
            return false;
        }
        HashSet<IMarkerResolution> fixes = new HashSet<IMarkerResolution>();
        for (IMarkerResolution bugFix : resolutions) {
            fixes.add(bugFix);
        }
        return this.addBugResolutions(bugType, fixes);
    }

    protected boolean addBugResolutions(String bugType, Set<IMarkerResolution> resolutions) {
        Assert.isNotNull((Object)bugType);
        Assert.isNotNull(resolutions);
        if (resolutions.isEmpty()) {
            return false;
        }
        HashSet<Class<? extends IMarkerResolution>> resolutionClasses = new HashSet<Class<? extends IMarkerResolution>>();
        for (IMarkerResolution bugFix : resolutions) {
            resolutionClasses.add(bugFix.getClass());
        }
        this.registerBugResolutions(bugType, resolutionClasses);
        Set<IMarkerResolution> fixes = this.resolutions.get(bugType);
        if (fixes != null) {
            return fixes.addAll(resolutions);
        }
        this.resolutions.put(bugType, resolutions);
        return true;
    }

    public IMarkerResolution[] getBugResolutions(String bugType) {
        Assert.isNotNull((Object)bugType);
        Set<IMarkerResolution> resolutionSet = this.resolutions.get(bugType);
        if (resolutionSet != null) {
            return resolutionSet.toArray(new IMarkerResolution[resolutionSet.size()]);
        }
        return this.createBugResolutions(bugType);
    }

    public boolean containsBugResolution(String bugType) {
        Assert.isNotNull((Object)bugType);
        return this.resolutions.containsKey(bugType) || this.resolutionClasses.containsKey(bugType);
    }

    public boolean removeBugResolution(String bugType, IMarkerResolution bugFix) {
        return this.removeBugResolutions(bugType, bugFix);
    }

    public boolean removeBugResolutions(String bugType, IMarkerResolution ... resolutions) {
        HashSet<IMarkerResolution> resolutionSet;
        Assert.isNotNull((Object)bugType);
        if (resolutions.length > 0) {
            resolutionSet = new HashSet();
            for (IMarkerResolution resolution : resolutions) {
                resolutionSet.add(resolution);
            }
        } else {
            resolutionSet = this.resolutions.get(bugType);
        }
        return this.removeBugResolutions(bugType, resolutionSet);
    }

    protected boolean removeBugResolutions(String bugType, Set<IMarkerResolution> resolutions) {
        Assert.isNotNull((Object)bugType);
        Assert.isNotNull(resolutions);
        if (resolutions.isEmpty()) {
            return false;
        }
        HashSet<Class<? extends IMarkerResolution>> resolutionClasses = new HashSet<Class<? extends IMarkerResolution>>();
        for (IMarkerResolution resolution : resolutions) {
            resolutionClasses.add(resolution.getClass());
        }
        Set<IMarkerResolution> resolutionSet = this.resolutions.get(bugType);
        if (resolutionSet == null) {
            return false;
        }
        resolutionSet.removeAll(resolutions);
        if (resolutionSet.isEmpty()) {
            this.resolutions.remove(bugType);
        }
        return this.deregisterBugResolutions(bugType, resolutionClasses);
    }

    public void clear() {
        this.resolutionClasses.clear();
        this.resolutions.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Set<Class<? extends IMarkerResolution>>> entry : this.resolutionClasses.entrySet()) {
            String bugType = entry.getKey();
            sb.append(bugType);
            sb.append(" { ");
            for (Class<? extends IMarkerResolution> resolutionClass : entry.getValue()) {
                sb.append(resolutionClass.getName());
                sb.append(", ");
            }
            sb.replace(sb.length() - 2, sb.length(), " }\n");
        }
        return sb.toString();
    }

    private IMarkerResolution[] createBugResolutions(String bugType) {
        Assert.isNotNull((Object)bugType);
        Set<Class<? extends IMarkerResolution>> classes = this.resolutionClasses.get(bugType);
        if (classes == null) {
            return new IMarkerResolution[0];
        }
        Set<IMarkerResolution> fixes = this.instantiateBugResolutions(classes);
        this.resolutions.put(bugType, fixes);
        return fixes.toArray(new IMarkerResolution[fixes.size()]);
    }

    private Set<IMarkerResolution> instantiateBugResolutions(Set<Class<? extends IMarkerResolution>> classes) {
        Assert.isNotNull(classes);
        HashSet<IMarkerResolution> fixes = new HashSet<IMarkerResolution>();
        for (Class<? extends IMarkerResolution> resolutionClass : classes) {
            IMarkerResolution fixer = this.instantiateBugResolution(resolutionClass);
            if (fixer == null) continue;
            fixes.add(fixer);
        }
        return fixes;
    }

    @CheckForNull
    private <F extends IMarkerResolution> F instantiateBugResolution(Class<F> resolutionClass) {
        try {
            return (F)((IMarkerResolution)resolutionClass.newInstance());
        }
        catch (InstantiationException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to instantiate bug-resolution '" + resolutionClass.getName() + "'.");
            return null;
        }
        catch (IllegalAccessException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to create bug-resolution '" + resolutionClass.getName() + "'.");
            return null;
        }
    }
}

