/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.Type;

public class UselessSubclassMethod
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    @DottedClassName
    private String superclassName;
    private State state;
    private int curParm;
    private int curParmOffset;
    private int invokePC;
    private Type[] argTypes;
    private Set<String> interfaceMethods = null;

    public UselessSubclassMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            this.superclassName = cls.getSuperclassName();
            JavaClass[] interfaces = null;
            if (cls.isClass() && (cls.getAccessFlags() & 0x400) != 0) {
                interfaces = cls.getAllInterfaces();
                this.interfaceMethods = new HashSet<String>();
                for (JavaClass aInterface : interfaces) {
                    Method[] infMethods;
                    for (Method meth : infMethods = aInterface.getMethods()) {
                        this.interfaceMethods.add(meth.getName() + meth.getSignature());
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        super.visitClassContext(classContext);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.interfaceMethods = null;
        super.visitAfter(obj);
    }

    @Override
    public void visitMethod(Method obj) {
        if (this.interfaceMethods != null && (obj.getAccessFlags() & 0x400) != 0) {
            String curDetail = obj.getName() + obj.getSignature();
            for (String infMethodDetail : this.interfaceMethods) {
                if (!curDetail.equals(infMethodDetail)) continue;
                this.bugReporter.reportBug(new BugInstance(this, "USM_USELESS_ABSTRACT_METHOD", 3).addClassAndMethod(this.getClassContext().getJavaClass(), obj));
            }
        }
        super.visitMethod(obj);
    }

    @Override
    public void visitCode(Code obj) {
        try {
            String methodName = this.getMethodName();
            if (!methodName.equals("<init>") && !methodName.equals("clone") && (this.getMethod().getAccessFlags() & 0x1008) == 0) {
                Attribute[] atts;
                for (Attribute att : atts = this.getMethod().getAttributes()) {
                    if (!att.getClass().equals(Synthetic.class)) continue;
                    return;
                }
                byte[] codeBytes = obj.getCode();
                if (codeBytes.length == 0 || codeBytes[0] != 42) {
                    return;
                }
                this.state = State.SEEN_NOTHING;
                this.invokePC = 0;
                super.visitCode(obj);
                if (this.state == State.SEEN_RETURN && this.invokePC != 0) {
                    Method superMethod = this.findSuperclassMethod(this.superclassName, this.getMethod());
                    if (superMethod == null || this.differentAttributes(this.getMethod(), superMethod) || this.getMethod().isProtected() && !this.samePackage(this.getDottedClassName(), this.superclassName)) {
                        return;
                    }
                    this.bugReporter.reportBug(new BugInstance(this, "USM_USELESS_SUBCLASS_METHOD", 3).addClassAndMethod(this).addSourceLine(this, this.invokePC));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public String getPackage(@DottedClassName String classname) {
        int i = classname.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return classname.substring(0, i);
    }

    public boolean samePackage(@DottedClassName String classname1, @DottedClassName String classname2) {
        return this.getPackage(classname1).equals(this.getPackage(classname2));
    }

    @Override
    public void sawOpcode(int seen) {
        switch (this.state) {
            case SEEN_NOTHING: {
                if (seen == 42) {
                    this.argTypes = Type.getArgumentTypes((String)this.getMethodSig());
                    this.curParm = 0;
                    this.curParmOffset = 1;
                    if (this.argTypes.length > 0) {
                        this.state = State.SEEN_PARM;
                        break;
                    }
                    this.state = State.SEEN_LAST_PARM;
                    break;
                }
                this.state = State.SEEN_INVALID;
                break;
            }
            case SEEN_PARM: {
                String signature;
                char typeChar0;
                if (this.curParm >= this.argTypes.length) {
                    this.state = State.SEEN_INVALID;
                    break;
                }
                if ((typeChar0 = (signature = this.argTypes[this.curParm++].getSignature()).charAt(0)) == 'L' || typeChar0 == '[') {
                    this.checkParm(seen, 42, 25, 1);
                } else if (typeChar0 == 'D') {
                    this.checkParm(seen, 38, 24, 2);
                } else if (typeChar0 == 'F') {
                    this.checkParm(seen, 34, 23, 1);
                } else if (typeChar0 == 'I' || typeChar0 == 'Z' || typeChar0 == 'S' || typeChar0 == 'C') {
                    this.checkParm(seen, 26, 21, 1);
                } else if (typeChar0 == 'J') {
                    this.checkParm(seen, 30, 22, 2);
                } else {
                    this.state = State.SEEN_INVALID;
                }
                if (this.state == State.SEEN_INVALID || this.curParm < this.argTypes.length) break;
                this.state = State.SEEN_LAST_PARM;
                break;
            }
            case SEEN_LAST_PARM: {
                if (seen == 183 && this.getMethodName().equals(this.getNameConstantOperand()) && this.getMethodSig().equals(this.getSigConstantOperand())) {
                    this.invokePC = this.getPC();
                    this.state = State.SEEN_INVOKE;
                    break;
                }
                this.state = State.SEEN_INVALID;
                break;
            }
            case SEEN_INVOKE: {
                Type returnType = this.getMethod().getReturnType();
                char retSigChar0 = returnType.getSignature().charAt(0);
                if (retSigChar0 == 'V' && seen == 177) {
                    this.state = State.SEEN_RETURN;
                    break;
                }
                if ((retSigChar0 == 'L' || retSigChar0 == '[') && seen == 176) {
                    this.state = State.SEEN_RETURN;
                    break;
                }
                if (retSigChar0 == 'D' && seen == 175) {
                    this.state = State.SEEN_RETURN;
                    break;
                }
                if (retSigChar0 == 'F' && seen == 174) {
                    this.state = State.SEEN_RETURN;
                    break;
                }
                if ((retSigChar0 == 'I' || retSigChar0 == 'S' || retSigChar0 == 'C' || retSigChar0 == 'B' || retSigChar0 == 'Z') && seen == 172) {
                    this.state = State.SEEN_RETURN;
                    break;
                }
                if (retSigChar0 == 'J' && seen == 173) {
                    this.state = State.SEEN_RETURN;
                    break;
                }
                this.state = State.SEEN_INVALID;
                break;
            }
            case SEEN_RETURN: {
                this.state = State.SEEN_INVALID;
                break;
            }
        }
    }

    private void checkParm(int seen, int fastOpBase, int slowOp, int parmSize) {
        if (this.curParmOffset >= 1 && this.curParmOffset <= 3) {
            if (seen == fastOpBase + this.curParmOffset) {
                this.curParmOffset += parmSize;
            } else {
                this.state = State.SEEN_INVALID;
            }
        } else if (this.curParmOffset == 0) {
            this.state = State.SEEN_INVALID;
        } else if (seen == slowOp && this.getRegisterOperand() == this.curParmOffset) {
            this.curParmOffset += parmSize;
        } else {
            this.state = State.SEEN_INVALID;
        }
    }

    private Method findSuperclassMethod(@DottedClassName String superclassName, Method subclassMethod) throws ClassNotFoundException {
        Method[] methods;
        String methodName = subclassMethod.getName();
        Type[] subArgs = null;
        JavaClass superClass = Repository.lookupClass((String)superclassName);
        block0: for (Method m : methods = superClass.getMethods()) {
            Type[] superArgs;
            if (!m.getName().equals(methodName)) continue;
            if (subArgs == null) {
                subArgs = Type.getArgumentTypes((String)subclassMethod.getSignature());
            }
            if (subArgs.length != (superArgs = Type.getArgumentTypes((String)m.getSignature())).length) continue;
            for (int j = 0; j < subArgs.length; ++j) {
                if (!superArgs[j].equals((Object)subArgs[j])) continue block0;
            }
            return m;
        }
        if (!superclassName.equals("Object")) {
            String superSuperClassName = superClass.getSuperclassName();
            if (superSuperClassName.equals(superclassName)) {
                throw new ClassNotFoundException("superclass of " + superclassName + " is itself");
            }
            return this.findSuperclassMethod(superSuperClassName, subclassMethod);
        }
        return null;
    }

    HashSet<String> thrownExceptions(Method m) {
        HashSet<String> result = new HashSet<String>();
        ExceptionTable exceptionTable = m.getExceptionTable();
        if (exceptionTable != null) {
            for (String e : exceptionTable.getExceptionNames()) {
                result.add(e);
            }
        }
        return result;
    }

    private boolean differentAttributes(Method m1, Method m2) {
        if (m1.getAnnotationEntries().length > 0 || m2.getAnnotationEntries().length > 0) {
            return true;
        }
        int access1 = m1.getAccessFlags() & 0x17;
        int access2 = m2.getAccessFlags() & 0x17;
        m1.getAnnotationEntries();
        if (access1 != access2) {
            return true;
        }
        if (!this.thrownExceptions(m1).equals(this.thrownExceptions(m2))) {
            return false;
        }
        m1.getExceptionTable();
        return false;
    }

    static enum State {
        SEEN_NOTHING,
        SEEN_PARM,
        SEEN_LAST_PARM,
        SEEN_INVOKE,
        SEEN_RETURN,
        SEEN_INVALID;

    }
}

