/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ByteCodePatternDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DominatorsAnalysis;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.PostDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.bcp.Binding;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePattern;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import edu.umd.cs.findbugs.ba.bcp.IfNull;
import edu.umd.cs.findbugs.ba.bcp.Load;
import edu.umd.cs.findbugs.ba.bcp.PatternElementMatch;
import edu.umd.cs.findbugs.ba.bcp.Store;
import edu.umd.cs.findbugs.ba.bcp.Wild;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;

public final class LazyInit
extends ByteCodePatternDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private static final boolean DEBUG = SystemProperties.getBoolean("lazyinit.debug");
    private static ByteCodePattern pattern = new ByteCodePattern();
    BitSet reported = new BitSet();

    public LazyInit(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public BugReporter getBugReporter() {
        return this.bugReporter;
    }

    @Override
    public ByteCodePattern getPattern() {
        return pattern;
    }

    @Override
    public boolean prescreen(Method method, ClassContext classContext) {
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        Code code = method.getCode();
        if (code.getCode().length > 5000) {
            return false;
        }
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return false;
        }
        boolean hasGetStatic = bytecodeSet.get(178);
        boolean hasPutStatic = bytecodeSet.get(179);
        if (!hasGetStatic || !hasPutStatic) {
            return false;
        }
        if (method.isSynchronized()) {
            return false;
        }
        this.reported.clear();
        return true;
    }

    @Override
    public void reportMatch(ClassContext classContext, Method method, ByteCodePatternMatch match) throws CFGBuilderException, DataflowAnalysisException {
        boolean isDefaultAccess;
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        BindingSet bindingSet = match.getBindingSet();
        Binding binding = bindingSet.lookup("f");
        FieldVariable field = (FieldVariable)binding.getVariable();
        XField xfield = Hierarchy.findXField(field.getClassName(), field.getFieldName(), field.getFieldSig(), field.isStatic());
        if (!xfield.isResolved()) {
            return;
        }
        if (!xfield.isStatic()) {
            return;
        }
        if (xfield.getName().startsWith("class$") || xfield.getName().startsWith("array$")) {
            if (DEBUG) {
                System.out.println("Ignoring field " + xfield.getName());
            }
            return;
        }
        String signature = xfield.getSignature();
        if (!signature.startsWith("[") && !signature.startsWith("L")) {
            if (DEBUG) {
                System.out.println("Ignoring non-reference field " + xfield.getName());
            }
            return;
        }
        if (signature.equals("Ljava/lang/String;")) {
            return;
        }
        if (signature.charAt(0) == 'L') {
            ClassDescriptor fieldType = DescriptorFactory.createClassDescriptorFromFieldSignature(signature);
            while (fieldType != null) {
                XClass fieldClass;
                try {
                    fieldClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, fieldType);
                }
                catch (CheckedAnalysisException e) {
                    break;
                }
                String name = fieldClass.getClassDescriptor().getClassName();
                if (name.startsWith("java/awt") || name.startsWith("javax/swing")) {
                    return;
                }
                if (name.equals("java/lang/Object")) break;
                fieldType = fieldClass.getSuperclassDescriptor();
            }
        }
        PatternElementMatch createBegin = match.getFirstLabeledMatch("createObject");
        PatternElementMatch store = match.getFirstLabeledMatch("end");
        PatternElementMatch test = match.getFirstLabeledMatch("test");
        InstructionHandle testInstructionHandle = test.getMatchedInstructionInstructionHandle();
        if (this.reported.get(testInstructionHandle.getPosition())) {
            return;
        }
        DominatorsAnalysis domAnalysis = classContext.getNonExceptionDominatorsAnalysis(method);
        PostDominatorsAnalysis postDomAnalysis = classContext.getNonExceptionPostDominatorsAnalysis(method);
        BitSet extent = domAnalysis.getAllDominatedBy(createBegin.getBasicBlock());
        BitSet postDom = postDomAnalysis.getAllDominatedBy(store.getBasicBlock());
        if (DEBUG) {
            System.out.println("test  dominates: " + extent);
            System.out.println("Field store postdominates " + postDom);
        }
        extent.and(postDom);
        if (DEBUG) {
            System.out.println("extent: " + extent);
        }
        LockDataflow lockDataflow = classContext.getLockDataflow(method);
        LockSet lockSet = null;
        boolean sawNEW = false;
        boolean sawINVOKE = false;
        for (BasicBlock block : cfg.getBlocks(extent)) {
            InstructionHandle handle;
            BasicBlock.InstructionIterator j = block.instructionIterator();
            while (j.hasNext() && !(handle = (InstructionHandle)j.next()).equals(store.getMatchedInstructionInstructionHandle())) {
                Location location = new Location(handle, block);
                Instruction ins = handle.getInstruction();
                if (DEBUG) {
                    System.out.println(location);
                }
                if (ins instanceof AllocationInstruction) {
                    sawNEW = true;
                } else if (ins instanceof InvokeInstruction) {
                    if (ins instanceof INVOKESTATIC && ((INVOKESTATIC)ins).getMethodName(classContext.getConstantPoolGen()).startsWith("new")) {
                        sawNEW = true;
                    }
                    sawINVOKE = true;
                }
                LockSet insLockSet = (LockSet)lockDataflow.getFactAtLocation(location);
                if (lockSet == null) {
                    lockSet = new LockSet();
                    lockSet.copyFrom(insLockSet);
                    continue;
                }
                lockSet.intersectWith(insLockSet);
            }
        }
        if (!sawNEW && !sawINVOKE) {
            return;
        }
        if (lockSet == null) {
            throw new IllegalStateException("lock set is null");
        }
        if (!lockSet.isEmpty()) {
            return;
        }
        boolean sawGetStaticAfterPutStatic = false;
        if (signature.startsWith("[") || signature.startsWith("L")) {
            BitSet postStore = domAnalysis.getAllDominatedBy(store.getBasicBlock());
            block5: for (BasicBlock block : cfg.getBlocks(postStore)) {
                BasicBlock.InstructionIterator j = block.instructionIterator();
                while (j.hasNext()) {
                    XField field2;
                    InstructionHandle handle = (InstructionHandle)j.next();
                    InstructionHandle nextHandle = handle.getNext();
                    Instruction ins = handle.getInstruction();
                    if (!(ins instanceof GETSTATIC) || !this.potentialInitialization(nextHandle) || !xfield.equals(field2 = XFactory.createXField((FieldInstruction)ins, methodGen.getConstantPool()))) continue;
                    sawGetStaticAfterPutStatic = true;
                    break block5;
                }
            }
        }
        if (!sawGetStaticAfterPutStatic && xfield.isVolatile()) {
            return;
        }
        int priority = 3;
        boolean bl = isDefaultAccess = (method.getAccessFlags() & 7) == 0;
        if (method.isPublic()) {
            priority = 2;
        } else if (method.isProtected() || isDefaultAccess) {
            priority = 2;
        }
        if (signature.startsWith("[") || signature.startsWith("Ljava/util/")) {
            --priority;
        }
        if (!sawNEW) {
            ++priority;
        }
        if (!sawGetStaticAfterPutStatic && priority < 3) {
            priority = 3;
        }
        if (classContext.getXClass().usesConcurrency()) {
            --priority;
        }
        InstructionHandle start = match.getLabeledInstruction("start");
        InstructionHandle end = match.getLabeledInstruction("end");
        String sourceFile = javaClass.getSourceFileName();
        this.bugReporter.reportBug(new BugInstance(this, sawGetStaticAfterPutStatic ? "LI_LAZY_INIT_UPDATE_STATIC" : "LI_LAZY_INIT_STATIC", priority).addClassAndMethod(methodGen, sourceFile).addField(xfield).describe("FIELD_ON").addSourceLine(classContext, methodGen, sourceFile, start, end));
        this.reported.set(testInstructionHandle.getPosition());
    }

    private boolean potentialInitialization(InstructionHandle nextHandle) {
        if (nextHandle == null) {
            return true;
        }
        Instruction instruction = nextHandle.getInstruction();
        if (instruction instanceof ReturnInstruction) {
            return false;
        }
        return !(instruction instanceof IfInstruction);
    }

    static {
        pattern.add(new Load("f", "val").label("start")).add(new IfNull("val").label("test")).add(new Wild(1, 1).label("createObject").dominatedBy("test")).add(new Store("f", pattern.dummyVariable()).label("end").dominatedBy("createObject"));
    }
}

