/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.DetectorToDetector2Adapter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.JavaVersion;
import edu.umd.cs.findbugs.JavaVersionException;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.NonReportingDetectorToDetector2Adapter;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class DetectorFactory {
    private static final boolean DEBUG_JAVA_VERSION = SystemProperties.getBoolean("findbugs.debug.javaversion");
    private static final boolean SUPPORT_OLD_DETECTOR_INTERFACE = SystemProperties.getBoolean("findbugs.support.old.detector.interface");
    private static final Class<?>[] constructorArgTypes = new Class[]{BugReporter.class};
    @Nonnull
    private final Plugin plugin;
    private final ReflectionDetectorCreator detectorCreator;
    @Nonnull
    @DottedClassName
    private final String className;
    private int positionSpecifiedInPluginDescriptor;
    private final boolean defEnabled;
    private final String speed;
    private final String reports;
    private final String requireJRE;
    private String detailHTML;
    private int priorityAdjustment;
    private boolean enabledButNonReporting;
    private boolean hidden;

    public DetectorFactory(@Nonnull Plugin plugin, @Nonnull String className, Class<?> detectorClass, boolean enabled, String speed, String reports, String requireJRE) {
        this.plugin = plugin;
        this.className = className;
        this.detectorCreator = FindBugs.isNoAnalysis() ? null : new ReflectionDetectorCreator(detectorClass);
        this.defEnabled = enabled;
        this.speed = speed;
        this.reports = reports;
        this.requireJRE = requireJRE;
        this.priorityAdjustment = 0;
        this.hidden = false;
    }

    public String toString() {
        return this.getShortName();
    }

    public void setPositionSpecifiedInPluginDescriptor(int positionSpecifiedInPluginDescriptor) {
        this.positionSpecifiedInPluginDescriptor = positionSpecifiedInPluginDescriptor;
    }

    public int getPositionSpecifiedInPluginDescriptor() {
        return this.positionSpecifiedInPluginDescriptor;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isDetectorClassSubtypeOf(Class<?> otherClass) {
        if (FindBugs.isNoAnalysis()) {
            throw new IllegalStateException("No analysis specified");
        }
        return otherClass.isAssignableFrom(this.detectorCreator.getDetectorClass());
    }

    public boolean isReportingDetector() {
        return !this.isDetectorClassSubtypeOf(TrainingDetector.class) && !this.isDetectorClassSubtypeOf(FirstPassDetector.class);
    }

    public boolean isEnabledForCurrentJRE() {
        if (this.requireJRE.equals("")) {
            return true;
        }
        try {
            JavaVersion requiredVersion = new JavaVersion(this.requireJRE);
            JavaVersion runtimeVersion = JavaVersion.getRuntimeVersion();
            if (DEBUG_JAVA_VERSION) {
                System.out.println("Checking JRE version for " + this.getShortName() + " (requires " + requiredVersion + ", running on " + runtimeVersion + ")");
            }
            boolean enabledForCurrentJRE = runtimeVersion.isSameOrNewerThan(requiredVersion);
            if (DEBUG_JAVA_VERSION) {
                System.out.println("\t==> " + enabledForCurrentJRE);
            }
            return enabledForCurrentJRE;
        }
        catch (JavaVersionException e) {
            if (DEBUG_JAVA_VERSION) {
                System.out.println("Couldn't check Java version: " + e.toString());
                e.printStackTrace(System.out);
            }
            return false;
        }
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDefaultEnabled() {
        return this.defEnabled;
    }

    public void setPriorityAdjustment(int priorityAdjustment) {
        this.priorityAdjustment = priorityAdjustment;
    }

    public void setEnabledButNonReporting(boolean notReporting) {
        this.enabledButNonReporting = notReporting;
    }

    public int getPriorityAdjustment() {
        if (this.enabledButNonReporting) {
            return 100;
        }
        return this.priorityAdjustment;
    }

    @Deprecated
    public String getSpeed() {
        return this.speed;
    }

    public String getReportedBugPatternCodes() {
        return this.reports;
    }

    public Set<BugPattern> getReportedBugPatterns() {
        TreeSet<BugPattern> result = new TreeSet<BugPattern>();
        StringTokenizer tok = new StringTokenizer(this.reports, ",");
        while (tok.hasMoreTokens()) {
            String type = tok.nextToken();
            BugPattern bugPattern = DetectorFactoryCollection.instance().lookupBugPattern(type);
            if (bugPattern == null) continue;
            result.add(bugPattern);
        }
        return result;
    }

    public String getDetailHTML() {
        return this.detailHTML;
    }

    public void setDetailHTML(String detailHTML) {
        this.detailHTML = detailHTML;
    }

    @Deprecated
    public Detector create(BugReporter bugReporter) {
        if (FindBugs.isNoAnalysis()) {
            throw new IllegalStateException("No analysis specified");
        }
        return this.detectorCreator.createDetector(bugReporter);
    }

    public Detector2 createDetector2(BugReporter bugReporter) {
        if (FindBugs.isNoAnalysis()) {
            throw new IllegalStateException("No analysis specified");
        }
        return this.detectorCreator.createDetector2(bugReporter);
    }

    public String getShortName() {
        int endOfPkg = this.className.lastIndexOf(46);
        if (endOfPkg >= 0) {
            return this.className.substring(endOfPkg + 1);
        }
        return this.className;
    }

    @Nonnull
    @DottedClassName
    public String getFullName() {
        return this.className;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.className.hashCode();
        result = 31 * result + this.plugin.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DetectorFactory)) {
            return false;
        }
        DetectorFactory other = (DetectorFactory)obj;
        if (!this.className.equals(other.className)) {
            return false;
        }
        return this.plugin.equals(other.plugin);
    }

    static class ReflectionDetectorCreator {
        private final Class<?> detectorClass;
        private Method setAnalysisContext;

        ReflectionDetectorCreator(Class<?> detectorClass) {
            this.detectorClass = detectorClass;
            if (SUPPORT_OLD_DETECTOR_INTERFACE) {
                try {
                    this.setAnalysisContext = detectorClass.getDeclaredMethod("setAnalysisContext", AnalysisContext.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.detectorClass.getSimpleName();
        }

        public Detector createDetector(BugReporter bugReporter) {
            try {
                Constructor<?> constructor = this.detectorClass.getConstructor(constructorArgTypes);
                Detector detector = (Detector)constructor.newInstance(bugReporter);
                if (this.setAnalysisContext != null) {
                    this.setAnalysisContext.invoke((Object)detector, AnalysisContext.currentAnalysisContext());
                }
                return detector;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate " + this.detectorClass.getName() + " as Detector", e);
            }
        }

        public Detector2 createDetector2(BugReporter bugReporter) {
            if (Detector2.class.isAssignableFrom(this.detectorClass)) {
                try {
                    Constructor<?> constructor = this.detectorClass.getConstructor(constructorArgTypes);
                    return (Detector2)constructor.newInstance(bugReporter);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate " + this.detectorClass.getName() + " as Detector2", e);
                }
            }
            if (Detector.class.isAssignableFrom(this.detectorClass)) {
                if (NonReportingDetector.class.isAssignableFrom(this.detectorClass)) {
                    return new NonReportingDetectorToDetector2Adapter(this.createDetector(bugReporter));
                }
                return new DetectorToDetector2Adapter(this.createDetector(bugReporter));
            }
            throw new RuntimeException("Class " + this.detectorClass.getName() + " is not a detector class");
        }

        public Class<?> getDetectorClass() {
            return this.detectorClass;
        }
    }
}

