/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.username.WebCloudNameLookup;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class SigninStatusBox
extends Composite {
    private final Cloud.CloudStatusListener cloudStatusListener = new Cloud.CloudStatusListener(){

        @Override
        public void handleStateChange(Cloud.SigninState oldState, Cloud.SigninState state) {
            SigninStatusBox.this.updateLabel();
        }

        @Override
        public void handleIssueDataDownloadedEvent() {
        }
    };
    private Cloud cloud;
    private Label statusLine;

    public SigninStatusBox(Composite parent, int style) {
        super(parent, style);
        this.createControls();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SigninStatusBox.this.dispose();
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                SigninStatusBox.this.statusLine.pack(true);
                SigninStatusBox.this.pack(true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    public void dispose() {
        if (this.statusLine.isDisposed()) {
            return;
        }
        this.statusLine.getCursor().dispose();
        super.dispose();
        if (this.cloud != null) {
            this.cloud.removeStatusListener(this.cloudStatusListener);
        }
    }

    public void setCloud(Cloud cloud) {
        if (this.cloud != null) {
            this.cloud.removeStatusListener(this.cloudStatusListener);
        }
        this.cloud = cloud;
        if (cloud != null) {
            cloud.addStatusListener(this.cloudStatusListener);
        }
        this.updateLabel();
    }

    private void createControls() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.statusLine = new Label((Composite)this, 0);
        this.statusLine.setLayoutData((Object)new GridData(131072, 2, true, false));
        this.statusLine.setAlignment(0x1000000);
        this.statusLine.setCursor(new Cursor(null, 21));
        this.statusLine.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SigninStatusBox.this.showSigninPopupMenu(SigninStatusBox.this.statusLine.toDisplay(e.x, e.y));
            }
        });
        this.updateLabel();
    }

    private void showSigninPopupMenu(Point p) {
        Menu popupMenu = new Menu((Control)this);
        MenuItem automaticCheckbox = new MenuItem(popupMenu, 32);
        automaticCheckbox.setText("Sign in automatically");
        Cloud.SigninState state = this.cloud.getSigninState();
        automaticCheckbox.setEnabled(state != Cloud.SigninState.NO_SIGNIN_REQUIRED);
        final boolean origSelection = WebCloudNameLookup.isSavingSessionInfoEnabled();
        automaticCheckbox.setSelection(origSelection);
        automaticCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebCloudNameLookup.setSaveSessionInformation(!origSelection);
            }
        });
        if (state.couldSignIn()) {
            MenuItem signInItem = new MenuItem(popupMenu, 0);
            signInItem.setText("Sign in");
            signInItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        SigninStatusBox.this.cloud.signIn();
                    }
                    catch (IOException e1) {
                        MessageDialog.openError((Shell)FindbugsPlugin.getShell(), (String)"Error", (String)e1.toString());
                    }
                }
            });
        } else if (state == Cloud.SigninState.SIGNING_IN || state == Cloud.SigninState.SIGNED_IN) {
            MenuItem signOutItem = new MenuItem(popupMenu, 0);
            signOutItem.setText("Sign out");
            signOutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SigninStatusBox.this.cloud.signOut();
                }
            });
        }
        popupMenu.setLocation(p);
        popupMenu.setVisible(true);
    }

    private void updateLabel() {
        FindbugsPlugin.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SigninStatusBox.this.statusLine != null && !SigninStatusBox.this.statusLine.isDisposed()) {
                    if (SigninStatusBox.this.cloud != null) {
                        String text = SigninStatusBox.this.cloud.getCloudName() + "\n" + (Object)((Object)SigninStatusBox.this.cloud.getSigninState());
                        if (SigninStatusBox.this.cloud.getUser() != null) {
                            text = text + ": " + SigninStatusBox.this.cloud.getUser();
                        }
                        SigninStatusBox.this.statusLine.setText(text);
                        SigninStatusBox.this.statusLine.pack(true);
                        SigninStatusBox.this.pack(true);
                    } else {
                        SigninStatusBox.this.statusLine.setText("");
                    }
                }
            }
        });
    }
}

