/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindBugsJob;
import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.WorkItem;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.reporter.JdtUtils;
import de.tobject.findbugs.reporter.MarkerParameter;
import de.tobject.findbugs.reporter.MarkerReporter;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.view.explorer.BugGroup;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public final class MarkerUtil {
    static final Pattern fullName = Pattern.compile("^(.+?)(([$+][0-9].*)?)");
    private static final IMarker[] EMPTY = new IMarker[0];
    private static final int DONT_KNOW_LINE = -42;

    private MarkerUtil() {
    }

    public static void createMarkers(final IJavaProject javaProject, final SortedBugCollection theCollection, ISchedulingRule rule, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        final List<MarkerParameter> bugParameters = MarkerUtil.createBugParameters(javaProject, theCollection, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        WorkspaceJob wsJob = new WorkspaceJob("Creating FindBugs markers"){

            public IStatus runInWorkspace(IProgressMonitor monitor1) throws CoreException {
                IProject project = javaProject.getProject();
                try {
                    new MarkerReporter(bugParameters, theCollection, project).run(monitor1);
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Core exception on add marker");
                    return e.getStatus();
                }
                return monitor1.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        wsJob.setRule(rule);
        wsJob.setSystem(true);
        wsJob.setUser(false);
        wsJob.schedule();
    }

    public static List<MarkerParameter> createBugParameters(IJavaProject project, BugCollection theCollection, IProgressMonitor monitor) {
        ArrayList<MarkerParameter> bugParameters = new ArrayList<MarkerParameter>();
        if (project == null) {
            FindbugsPlugin.getDefault().logException(new NullPointerException("project is null"), "project is null");
            return bugParameters;
        }
        Iterator<BugInstance> iterator = theCollection.iterator();
        while (iterator.hasNext() && !monitor.isCanceled()) {
            MarkerParameter mp;
            BugInstance bug = iterator.next();
            DetectorFactory detectorFactory = bug.getDetectorFactory();
            if (detectorFactory != null && !detectorFactory.getPlugin().isGloballyEnabled() || (mp = MarkerUtil.createMarkerParameter(project, bug)) == null) continue;
            bugParameters.add(mp);
        }
        return bugParameters;
    }

    private static MarkerParameter createMarkerParameter(IJavaProject project, BugInstance bug) {
        IJavaElement type = null;
        WorkItem resource = null;
        try {
            type = MarkerUtil.getJavaElement(bug, project);
            if (type != null) {
                resource = new WorkItem(type);
            }
        }
        catch (JavaModelException e1) {
            FindbugsPlugin.getDefault().logException(e1, "Could not find Java type for FindBugs warning");
        }
        if (resource == null) {
            if (Reporter.DEBUG) {
                MarkerUtil.reportNoResourceFound(bug);
            }
            return null;
        }
        int primaryLine = bug.getPrimarySourceLineAnnotation().getStartLine();
        int startLine = -42;
        if (primaryLine != -42 && primaryLine <= 1 && type instanceof IType) {
            IType iType = (IType)type;
            try {
                startLine = MarkerUtil.getLineStart(iType);
                if (startLine > 0 && Reporter.DEBUG) {
                    System.out.println("4. Fixed start line to: " + startLine + " on " + type.getElementName());
                }
            }
            catch (JavaModelException e1) {
                FindbugsPlugin.getDefault().logException(e1, "Could not find source line for Java type " + type + "for FindBugs warning: " + bug);
            }
        }
        if (primaryLine <= 0 && startLine <= 0) {
            startLine = 1;
            if (Reporter.DEBUG) {
                System.out.println("5. Fixed start line to *default* (1) on " + type);
            }
        }
        MarkerParameter parameter = startLine > 0 ? new MarkerParameter(bug, resource, startLine, primaryLine) : new MarkerParameter(bug, resource, primaryLine, primaryLine);
        return parameter;
    }

    private static void reportNoResourceFound(BugInstance bug) {
        String className = null;
        String packageName = null;
        ClassAnnotation primaryClass = bug.getPrimaryClass();
        if (primaryClass != null) {
            className = primaryClass.getClassName();
            packageName = primaryClass.getPackageName();
        }
        if (Reporter.DEBUG) {
            System.out.println("NOT found resource for a BUG in BUG in class: " + packageName + "." + className + ": \n\t" + bug.getMessage() + " / Annotation: " + bug.getAnnotationText() + " / Source Line: " + bug.getPrimarySourceLineAnnotation());
        }
    }

    @CheckForNull
    private static IJavaElement getJavaElement(BugInstance bug, IJavaProject project) throws JavaModelException {
        FieldAnnotation primaryField;
        IType type;
        SourceLineAnnotation primarySourceLineAnnotation = bug.getPrimarySourceLineAnnotation();
        String qualifiedClassName = primarySourceLineAnnotation.getClassName();
        Matcher m = fullName.matcher(qualifiedClassName);
        String innerName = null;
        if (m.matches() && m.group(2).length() > 0) {
            String outerQualifiedClassName = m.group(1).replace('$', '.');
            innerName = m.group(2).substring(1);
            type = project.findType(outerQualifiedClassName, (IProgressMonitor)null);
            if (type != null && !MarkerUtil.hasLineInfo(primarySourceLineAnnotation)) {
                MarkerUtil.completeInnerClassInfo(qualifiedClassName, innerName, type, bug);
            }
        } else {
            type = project.findType(qualifiedClassName.replace('$', '.'), (IProgressMonitor)null);
            if (type != null && type.isMember() && !MarkerUtil.hasLineInfo(primarySourceLineAnnotation)) {
                MarkerUtil.completeInnerClassInfo(qualifiedClassName, type.getElementName(), type, bug);
            }
        }
        primarySourceLineAnnotation = bug.getPrimarySourceLineAnnotation();
        int startLine = primarySourceLineAnnotation.getStartLine();
        if (startLine <= 1 && type != null && (primaryField = bug.getPrimaryField()) != null) {
            MarkerUtil.completeFieldInfo(qualifiedClassName, type, bug, primaryField);
        }
        return type;
    }

    private static boolean hasLineInfo(SourceLineAnnotation annotation) {
        return annotation != null && annotation.getStartLine() > 1;
    }

    private static void completeFieldInfo(String qualifiedClassName, @Nonnull IType type, @Nonnull BugInstance bug, @Nonnull FieldAnnotation field) {
        IField ifield = type.getField(field.getFieldName());
        ISourceRange sourceRange = null;
        JavaModelException ex = null;
        try {
            sourceRange = ifield.getNameRange();
        }
        catch (JavaModelException e) {
            ex = e;
        }
        IScanner scanner = null;
        try {
            if (sourceRange == null) {
                sourceRange = ifield.getSourceRange();
            }
            scanner = MarkerUtil.initScanner(type, sourceRange);
        }
        catch (JavaModelException e) {
            String message = "Can not complete field annotation " + field + " for the field: " + ifield + " in class: " + qualifiedClassName + ", type " + type + ", bug " + bug;
            if (ex != null) {
                e = ex;
            }
            FindbugsPlugin.getDefault().logMessage(2, message, e);
        }
        if (scanner == null || sourceRange == null) {
            return;
        }
        int lineNbr = scanner.getLineNumber(sourceRange.getOffset());
        if (lineNbr > 0) {
            String sourceFileStr = MarkerUtil.getSourceFileHint(type, qualifiedClassName);
            field.setSourceLines(new SourceLineAnnotation(qualifiedClassName, sourceFileStr, lineNbr, lineNbr, 0, 0));
            if (Reporter.DEBUG) {
                System.out.println("2. Fixed start line to: " + lineNbr + " on " + qualifiedClassName);
            }
        }
    }

    private static String getSourceFileHint(IType type, String qualifiedClassName) {
        String sourceFileStr = "";
        IJavaElement primaryElement = type.getPrimaryElement();
        if (primaryElement != null) {
            return primaryElement.getElementName() + ".java";
        }
        return sourceFileStr;
    }

    private static void completeInnerClassInfo(String qualifiedClassName, String innerName, @Nonnull IType type, BugInstance bug) throws JavaModelException {
        String sourceFileStr;
        int lineNbr = MarkerUtil.findChildSourceLine(type, innerName, bug);
        if (lineNbr > 0 && (sourceFileStr = MarkerUtil.getSourceFileHint(type, qualifiedClassName)) != null && sourceFileStr.length() > 0) {
            bug.addSourceLine(new SourceLineAnnotation(qualifiedClassName, sourceFileStr, lineNbr, lineNbr, 0, 0));
            if (Reporter.DEBUG) {
                System.out.println("1. Fixed start line to: " + lineNbr + " on " + qualifiedClassName + "$" + innerName);
            }
        }
    }

    private static int getLineStart(IType source) throws JavaModelException {
        IScanner scanner;
        ISourceRange range = source.getNameRange();
        if (range == null) {
            range = source.getSourceRange();
        }
        if ((scanner = MarkerUtil.initScanner(source, range)) != null && range != null) {
            return scanner.getLineNumber(range.getOffset());
        }
        return -42;
    }

    private static IScanner initScanner(IType source, ISourceRange range) throws JavaModelException {
        if (range == null) {
            return null;
        }
        char[] charContent = MarkerUtil.getContent(source);
        if (charContent == null) {
            return null;
        }
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        scanner.setSource(charContent);
        int offset = range.getOffset();
        try {
            while (scanner.getNextToken() != 158 && offset > scanner.getCurrentTokenEndPosition()) {
            }
        }
        catch (InvalidInputException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not init scanner for type: " + source);
        }
        return scanner;
    }

    private static char[] getContent(IType source) throws JavaModelException {
        String content;
        char[] charContent = null;
        IOpenable op = source.getOpenable();
        if (op instanceof CompilationUnit) {
            charContent = ((CompilationUnit)op).getContents();
        }
        if (charContent == null && (content = source.getSource()) != null) {
            charContent = content.toCharArray();
        }
        return charContent;
    }

    private static int findChildSourceLine(IType parentType, String name, BugInstance bug) throws JavaModelException {
        boolean innerFromMember;
        if (parentType == null) {
            return -1;
        }
        char firstChar = name.charAt(0);
        boolean firstIsDigit = Character.isDigit(firstChar);
        if (!firstIsDigit) {
            return MarkerUtil.findInnerClassSourceLine((IJavaElement)parentType, name);
        }
        boolean bl = innerFromMember = firstIsDigit && name.length() > 1 && !Character.isDigit(name.charAt(1));
        if (innerFromMember) {
            return MarkerUtil.findInnerClassSourceLine((IJavaElement)parentType, name.substring(1));
        }
        return MarkerUtil.findInnerAnonymousClassSourceLine((IJavaElement)parentType, name);
    }

    private static int findInnerAnonymousClassSourceLine(IJavaElement parentType, String innerName) throws JavaModelException {
        IType anon = JdtUtils.findAnonymous((IType)parentType, innerName);
        if (anon != null) {
            return MarkerUtil.getLineStart(anon);
        }
        return -42;
    }

    private static int findInnerClassSourceLine(IJavaElement type, String name) throws JavaModelException {
        String elemName = type.getElementName();
        if (name.equals(elemName) && type instanceof IType) {
            return MarkerUtil.getLineStart((IType)type);
        }
        if (type instanceof IParent) {
            IJavaElement[] children = ((IParent)type).getChildren();
            for (int i = 0; i < children.length; ++i) {
                int line = MarkerUtil.findInnerClassSourceLine(children[i], name);
                if (line <= 0) continue;
                return line;
            }
        }
        return -42;
    }

    public static void removeMarkers(IResource res) throws CoreException {
        res.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
        if (res instanceof IProject) {
            IProject project = (IProject)res;
            FindbugsPlugin.clearBugCollection(project);
        }
    }

    public static boolean shouldDisplayWarning(BugInstance bugInstance, ProjectFilterSettings filterSettings) {
        return filterSettings.displayWarning(bugInstance);
    }

    public static void redisplayMarkers(final IJavaProject javaProject) {
        final IProject project = javaProject.getProject();
        FindBugsJob job = new FindBugsJob("Refreshing FindBugs markers", (IResource)project){

            @Override
            protected void runWithProgress(IProgressMonitor monitor) throws CoreException {
                SortedBugCollection bugs = FindbugsPlugin.getBugCollection(project, monitor);
                project.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
                MarkerUtil.createMarkers(javaProject, bugs, (ISchedulingRule)project, monitor);
            }
        };
        job.setRule((ISchedulingRule)project);
        job.scheduleInteractive();
    }

    @CheckForNull
    public static BugCode findBugCodeForMarker(IMarker marker) {
        try {
            Object bugCode = marker.getAttribute("PATTERNTYPE");
            if (bugCode instanceof String) {
                return DetectorFactoryCollection.instance().getBugCode((String)bugCode);
            }
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Marker does not contain bug code");
            return null;
        }
        return null;
    }

    public static int findBugRankForMarker(IMarker marker) {
        return marker.getAttribute("RANK", 20);
    }

    public static FindBugsMarker.MarkerConfidence findConfidenceForMarker(IMarker marker) {
        return FindBugsMarker.MarkerConfidence.getConfidence(marker.getAttribute("CONFIDENCE", FindBugsMarker.MarkerConfidence.Ignore.name()));
    }

    @CheckForNull
    public static BugPattern findBugPatternForMarker(IMarker marker) {
        try {
            Object patternId = marker.getAttribute("BUGTYPE");
            if (patternId instanceof String) {
                return DetectorFactoryCollection.instance().lookupBugPattern((String)patternId);
            }
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Marker does not contain pattern id");
            return null;
        }
        return null;
    }

    @CheckForNull
    public static IJavaElement findJavaElementForMarker(IMarker marker) {
        try {
            Object elementId = marker.getAttribute("UNIQUE_JAVA_ID");
            if (elementId instanceof String) {
                return JavaCore.create((String)((String)elementId));
            }
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Marker does not contain valid java element id");
            return null;
        }
        return null;
    }

    @CheckForNull
    public static Plugin findDetectorPluginFor(IMarker marker) {
        try {
            Object pluginId = marker.getAttribute("DETECTOR_PLUGIN_ID");
            if (pluginId instanceof String) {
                return DetectorFactoryCollection.instance().getPluginById((String)pluginId);
            }
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Marker does not contain valid plugin id");
            return null;
        }
        return null;
    }

    public static Set<IMarker> findMarkerForJavaElement(IJavaElement elt, IMarker[] possibleCandidates, boolean recursive) {
        String id = elt.getHandleIdentifier();
        HashSet<IMarker> markers = new HashSet<IMarker>();
        for (IMarker marker : possibleCandidates) {
            try {
                Object elementId = marker.getAttribute("UNIQUE_JAVA_ID");
                if (!(elementId instanceof String)) continue;
                String stringId = (String)elementId;
                if (!recursive) {
                    if (stringId.equals(id)) {
                        markers.add(marker);
                        continue;
                    }
                    if (!MarkerUtil.isDirectChild(id, stringId)) continue;
                    markers.add(marker);
                    continue;
                }
                if (!stringId.startsWith(id)) continue;
                markers.add(marker);
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Marker does not contain valid java element id");
            }
        }
        return markers;
    }

    private static boolean isDirectChild(String parentId, String childId) {
        return childId.startsWith(parentId) && childId.length() > parentId.length() + 1 && childId.charAt(parentId.length()) == '(';
    }

    @CheckForNull
    public static BugInstance findBugInstanceForMarker(IMarker marker) {
        BugCollectionAndInstance bci = MarkerUtil.findBugCollectionAndInstanceForMarker(marker);
        if (bci == null) {
            return null;
        }
        return bci.bugInstance;
    }

    @CheckForNull
    public static BugCollectionAndInstance findBugCollectionAndInstanceForMarker(IMarker marker) {
        IResource resource = marker.getResource();
        IProject project = resource.getProject();
        if (project == null) {
            FindbugsPlugin.getDefault().logError("No project for warning marker");
            return null;
        }
        if (!MarkerUtil.isFindBugsMarker(marker)) {
            return null;
        }
        String bugId = marker.getAttribute("FINDBUGS_UNIQUE_ID", null);
        if (bugId == null) {
            FindbugsPlugin.getDefault().logError("Marker does not contain unique id for warning");
            return null;
        }
        try {
            SortedBugCollection bugCollection = FindbugsPlugin.getBugCollection(project, null);
            if (bugCollection == null) {
                FindbugsPlugin.getDefault().logError("Could not get BugCollection for FindBugs marker");
                return null;
            }
            String bugType = (String)marker.getAttribute("BUGTYPE");
            Integer primaryLineNumber = (Integer)marker.getAttribute("PRIMARY_LINE");
            if (primaryLineNumber == null) {
                primaryLineNumber = MarkerUtil.getEditorLine(marker);
            }
            if (bugType == null) {
                FindbugsPlugin.getDefault().logError("Could not get find attributes for marker " + marker + ": (" + bugId + ", " + primaryLineNumber + ")");
                return null;
            }
            BugInstance bug = bugCollection.findBug(bugId, bugType, primaryLineNumber);
            if (bug == null) {
                FindbugsPlugin.getDefault().logError("Could not get find bug for marker on " + resource + ": (" + bugId + ", " + primaryLineNumber + ")");
                return null;
            }
            return new BugCollectionAndInstance(bugCollection, bug);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not get BugInstance for FindBugs marker");
            return null;
        }
    }

    private static int getEditorLine(IMarker marker) {
        return marker.getAttribute("lineNumber", -1);
    }

    public static Set<IMarker> getMarkerFromSelection(ISelection selection) {
        HashSet<IMarker> markers = new HashSet<IMarker>();
        if (!(selection instanceof IStructuredSelection)) {
            return markers;
        }
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        for (Object next : sSelection) {
            markers.addAll(MarkerUtil.getMarkers(next));
        }
        return markers;
    }

    public static Set<IMarker> getMarkers(Object obj) {
        HashSet<IMarker> markers = new HashSet<IMarker>();
        if (obj instanceof IMarker) {
            IMarker marker = (IMarker)obj;
            if (MarkerUtil.isFindBugsMarker(marker)) {
                markers.add(marker);
            }
        } else if (obj instanceof BugGroup) {
            BugGroup group = (BugGroup)obj;
            markers.addAll(group.getAllMarkers());
        } else if (obj instanceof IResource) {
            IMarker[] markers2;
            IResource res = (IResource)obj;
            for (IMarker marker : markers2 = MarkerUtil.getAllMarkers(res)) {
                markers.add(marker);
            }
        } else if (obj instanceof IJavaElement) {
            markers.addAll(new WorkItem((IJavaElement)obj).getMarkers(true));
        } else if (obj instanceof IAdaptable) {
            IAdaptable adapter = (IAdaptable)obj;
            IMarker marker = (IMarker)adapter.getAdapter(IMarker.class);
            if (marker == null) {
                IResource resource = (IResource)adapter.getAdapter(IResource.class);
                if (resource == null) {
                    return markers;
                }
                IMarker[] markers2 = MarkerUtil.getMarkers(resource, 2);
                markers.addAll(Arrays.asList(markers2));
            } else if (MarkerUtil.isFindBugsMarker(marker)) {
                markers.add(marker);
            }
        }
        return markers;
    }

    public static IMarker getMarkerFromEditor(ITextSelection selection, IEditorPart editor) {
        IMarker[] allMarkers;
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IFile.class);
        if (resource != null) {
            allMarkers = MarkerUtil.getMarkers(resource, 0);
        } else {
            IClassFile classFile = (IClassFile)editor.getEditorInput().getAdapter(IClassFile.class);
            if (classFile == null) {
                return null;
            }
            Set<IMarker> markers = MarkerUtil.getMarkers(classFile.getType());
            allMarkers = markers.toArray(new IMarker[markers.size()]);
        }
        if (allMarkers.length == 1) {
            return allMarkers[0];
        }
        int startLine = selection.getStartLine() + 1;
        for (IMarker marker : allMarkers) {
            int line = MarkerUtil.getEditorLine(marker);
            if (startLine != line) continue;
            return marker;
        }
        return null;
    }

    public static IMarker getMarkerFromSingleSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            IEditorPart editor = FindbugsPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (!(editor instanceof ITextEditor)) {
                return null;
            }
            IMarker marker = MarkerUtil.getMarkerFromEditor((ITextSelection)selection, (IEditorPart)((ITextEditor)editor));
            selection = marker != null ? new StructuredSelection((Object)marker) : new StructuredSelection();
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection.size() != 1) {
            return null;
        }
        Object next = sSelection.getFirstElement();
        if (next instanceof IMarker) {
            IMarker marker = (IMarker)next;
            if (!MarkerUtil.isFindBugsMarker(marker)) {
                return null;
            }
            return marker;
        }
        if (next instanceof BugGroup) {
            return null;
        }
        if (next instanceof IResource) {
            return null;
        }
        if (next instanceof IAdaptable) {
            IAdaptable adapter = (IAdaptable)next;
            IMarker marker = (IMarker)adapter.getAdapter(IMarker.class);
            if (!MarkerUtil.isFindBugsMarker(marker)) {
                return null;
            }
            return marker;
        }
        return null;
    }

    public static boolean isFindBugsMarker(IMarker marker) {
        try {
            return marker != null && marker.exists() && marker.isSubtypeOf("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker");
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Exception while checking FindBugs type on marker.");
            return false;
        }
    }

    @Nonnull
    public static String getPluginId(@Nonnull IMarker marker) {
        return marker.getAttribute("DETECTOR_PLUGIN_ID", "");
    }

    public static IMarker[] getAllMarkers(IResource fileOrFolder) {
        return MarkerUtil.getMarkers(fileOrFolder, 2);
    }

    @Nonnull
    public static IMarker[] getMarkers(IResource fileOrFolder, int depth) {
        if (fileOrFolder.getType() == 4 && !fileOrFolder.isAccessible()) {
            return EMPTY;
        }
        try {
            return fileOrFolder.findMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, depth);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Cannot collect FindBugs warnings from: " + fileOrFolder);
            return EMPTY;
        }
    }

    public static boolean isFiltered(IMarker marker, Set<String> bugIdToFilter) {
        if (marker == null) {
            return true;
        }
        if (bugIdToFilter == null) {
            return false;
        }
        String pattern = marker.getAttribute("BUGTYPE", "not found");
        String patternType = marker.getAttribute("PATTERNTYPE", "not found");
        for (String badId : bugIdToFilter) {
            if (!badId.equals(patternType) && !badId.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public static class BugCollectionAndInstance {
        final BugCollection bugCollection;
        final BugInstance bugInstance;

        public BugCollection getBugCollection() {
            return this.bugCollection;
        }

        public BugInstance getBugInstance() {
            return this.bugInstance;
        }

        public BugCollectionAndInstance(@Nonnull BugCollection bugCollection, @Nonnull BugInstance bugInstance) {
            if (bugCollection == null) {
                throw new NullPointerException("Null bug collection");
            }
            if (bugInstance == null) {
                throw new NullPointerException("Null bug instance");
            }
            this.bugCollection = bugCollection;
            this.bugInstance = bugInstance;
        }

        public String toString() {
            return this.bugInstance.getMessage();
        }
    }
}

