/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import de.tobject.findbugs.reporter.MarkerSeverity;
import edu.umd.cs.findbugs.BugRankCategory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ReportConfigurationTab
extends Composite {
    private final FindbugsPropertyPage propertyPage;
    private List<Button> chkEnableBugCategoryList;
    private Scale minRankSlider;
    private Label rankValueLabel;
    private Combo minPriorityCombo;
    private Combo scariestRankCombo;
    private MarkerSeverity initialScariestRank;
    private Combo scaryRankCombo;
    private MarkerSeverity initialScaryRank;
    private Combo troublingRankCombo;
    private MarkerSeverity initialTroublingRank;
    private Combo ofConcernRankCombo;
    private MarkerSeverity initialOfConcernRank;

    public ReportConfigurationTab(TabFolder parent, FindbugsPropertyPage page, int style) {
        super((Composite)parent, style);
        this.propertyPage = page;
        this.setLayout((Layout)new GridLayout());
        TabItem tabDetector = new TabItem(parent, 0);
        tabDetector.setText(this.getMessage("property.reportConfigurationTab"));
        tabDetector.setControl((Control)this);
        tabDetector.setToolTipText("Configure bugs reported to the UI");
        Composite rankAndPrioGroup = new Composite((Composite)this, 0);
        rankAndPrioGroup.setLayout((Layout)new GridLayout(2, false));
        this.createRankGroup(rankAndPrioGroup);
        this.createPriorityGroup(rankAndPrioGroup);
        this.createBugCategoriesGroup(rankAndPrioGroup, page.getProject());
        this.createBugSeverityGroup(rankAndPrioGroup);
    }

    private void createBugSeverityGroup(Composite parent) {
        IPreferenceStore store = this.propertyPage.getPreferenceStore();
        MarkerSeverity[] markerSeverities = MarkerSeverity.values();
        Group rankGroup = new Group(parent, 0);
        rankGroup.setLayout((Layout)new GridLayout(2, false));
        rankGroup.setText("Mark bugs with ... rank as:");
        rankGroup.setLayoutData((Object)new GridData(1, 128, true, true));
        Label bugSeverityLabel = new Label((Composite)rankGroup, 0);
        bugSeverityLabel.setText("Scariest:");
        this.scariestRankCombo = new Combo((Composite)rankGroup, 12);
        for (MarkerSeverity markerSeverity : markerSeverities) {
            this.scariestRankCombo.add(markerSeverity.name());
        }
        this.initialScariestRank = MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScariest"));
        this.scariestRankCombo.setText(this.initialScariestRank.name());
        bugSeverityLabel = new Label((Composite)rankGroup, 0);
        bugSeverityLabel.setText("Scary:");
        this.scaryRankCombo = new Combo((Composite)rankGroup, 12);
        for (MarkerSeverity markerSeverity : markerSeverities) {
            this.scaryRankCombo.add(markerSeverity.name());
        }
        this.initialScaryRank = MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScary"));
        this.scaryRankCombo.setText(this.initialScaryRank.name());
        bugSeverityLabel = new Label((Composite)rankGroup, 0);
        bugSeverityLabel.setText("Troubling:");
        this.troublingRankCombo = new Combo((Composite)rankGroup, 12);
        for (MarkerSeverity markerSeverity : markerSeverities) {
            this.troublingRankCombo.add(markerSeverity.name());
        }
        this.initialTroublingRank = MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerTroubling"));
        this.troublingRankCombo.setText(this.initialTroublingRank.name());
        bugSeverityLabel = new Label((Composite)rankGroup, 0);
        bugSeverityLabel.setText("Of concern:");
        this.ofConcernRankCombo = new Combo((Composite)rankGroup, 12);
        for (MarkerSeverity markerSeverity : markerSeverities) {
            this.ofConcernRankCombo.add(markerSeverity.name());
        }
        this.initialOfConcernRank = MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerOfConcern"));
        this.ofConcernRankCombo.setText(this.initialOfConcernRank.name());
    }

    private void createPriorityGroup(Composite parent) {
        Composite prioGroup = new Composite(parent, 0);
        prioGroup.setLayout((Layout)new GridLayout(2, false));
        Label minPrioLabel = new Label(prioGroup, 0);
        minPrioLabel.setText(this.getMessage("property.minPriority"));
        minPrioLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.minPriorityCombo = new Combo(prioGroup, 12);
        this.minPriorityCombo.add("High");
        this.minPriorityCombo.add("Medium");
        this.minPriorityCombo.add("Low");
        this.minPriorityCombo.setText(this.propertyPage.getOriginalUserPreferences().getFilterSettings().getMinPriority());
        this.minPriorityCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.minPriorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String data = ReportConfigurationTab.this.minPriorityCombo.getText();
                ReportConfigurationTab.this.getCurrentProps().getFilterSettings().setMinPriority(data);
            }
        });
    }

    private void createRankGroup(Composite parent) {
        Composite prioGroup = new Composite(parent, 0);
        prioGroup.setLayout((Layout)new GridLayout(2, false));
        Label minRankLabel = new Label(prioGroup, 0);
        minRankLabel.setText(this.getMessage("property.minRank") + System.getProperty("line.separator") + this.getMessage("property.minRank.line2"));
        minRankLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.minRankSlider = new Scale(prioGroup, 12);
        this.minRankSlider.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.minRankSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int rank = ReportConfigurationTab.this.minRankSlider.getSelection();
                ReportConfigurationTab.this.getCurrentProps().getFilterSettings().setMinRank(rank);
                ReportConfigurationTab.this.updateRankValueLabel();
            }
        });
        this.minRankSlider.setMinimum(1);
        this.minRankSlider.setMaximum(20);
        this.minRankSlider.setSelection(this.getCurrentProps().getFilterSettings().getMinRank());
        this.minRankSlider.setIncrement(1);
        this.minRankSlider.setPageIncrement(5);
        Label dummyLabel = new Label(prioGroup, 0);
        dummyLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.rankValueLabel = new Label(prioGroup, 0);
        this.rankValueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.updateRankValueLabel();
    }

    private void updateRankValueLabel() {
        int rank = this.minRankSlider.getSelection();
        BugRankCategory category = BugRankCategory.getRank(rank);
        String label = category.toString();
        this.rankValueLabel.setText(rank + " (" + label + ")");
    }

    protected String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    private void createBugCategoriesGroup(Composite parent, IProject project) {
        Group checkBoxGroup = new Group(parent, 64);
        checkBoxGroup.setText(this.getMessage("property.categoriesGroup"));
        checkBoxGroup.setLayout((Layout)new GridLayout(1, true));
        checkBoxGroup.setLayoutData((Object)new GridData(1, 128, true, true));
        LinkedList<String> bugCategoryList = new LinkedList<String>(DetectorFactoryCollection.instance().getBugCategories());
        this.chkEnableBugCategoryList = new LinkedList<Button>();
        ProjectFilterSettings origFilterSettings = this.propertyPage.getOriginalUserPreferences().getFilterSettings();
        for (String category : bugCategoryList) {
            Button checkBox = new Button((Composite)checkBoxGroup, 32);
            checkBox.setText(I18N.instance().getBugCategoryDescription(category));
            checkBox.setSelection(origFilterSettings.containsCategory(category));
            GridData layoutData = new GridData();
            layoutData.horizontalIndent = 10;
            checkBox.setLayoutData((Object)layoutData);
            checkBox.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ReportConfigurationTab.this.syncSelectedCategories();
                }
            });
            checkBox.setData((Object)category);
            this.chkEnableBugCategoryList.add(checkBox);
        }
    }

    protected void syncSelectedCategories() {
        ProjectFilterSettings filterSettings = this.getCurrentProps().getFilterSettings();
        for (Button checkBox : this.chkEnableBugCategoryList) {
            String category = (String)checkBox.getData();
            if (checkBox.getSelection()) {
                filterSettings.addCategory(category);
                continue;
            }
            filterSettings.removeCategory(category);
        }
        this.propertyPage.getVisibleDetectors().clear();
    }

    protected UserPreferences getCurrentProps() {
        return this.propertyPage.getCurrentUserPreferences();
    }

    public void setEnabled(boolean enabled) {
        this.minPriorityCombo.setEnabled(enabled);
        this.ofConcernRankCombo.setEnabled(enabled);
        this.troublingRankCombo.setEnabled(enabled);
        this.scaryRankCombo.setEnabled(enabled);
        this.scariestRankCombo.setEnabled(enabled);
        this.minRankSlider.setEnabled(enabled);
        for (Button checkBox : this.chkEnableBugCategoryList) {
            checkBox.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void setMinRank(int rank) {
        this.minRankSlider.setSelection(rank);
    }

    public int getMinRank() {
        return this.minRankSlider.getSelection();
    }

    public boolean isMarkerSeveritiesChanged() {
        if (this.isMarkerSeveritiesChanged("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScariest", this.initialScariestRank)) {
            return true;
        }
        if (this.isMarkerSeveritiesChanged("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScary", this.initialScaryRank)) {
            return true;
        }
        if (this.isMarkerSeveritiesChanged("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerTroubling", this.initialTroublingRank)) {
            return true;
        }
        return this.isMarkerSeveritiesChanged("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerOfConcern", this.initialOfConcernRank);
    }

    private boolean isMarkerSeveritiesChanged(String propertyName, MarkerSeverity marker) {
        IPreferenceStore store = this.propertyPage.getPreferenceStore();
        return !store.getString(propertyName).equals(marker.name());
    }

    void refreshUI(UserPreferences prefs) {
        IPreferenceStore store = this.propertyPage.getPreferenceStore();
        this.scariestRankCombo.setText(MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScariest")).name());
        this.scaryRankCombo.setText(MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScary")).name());
        this.troublingRankCombo.setText(MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerTroubling")).name());
        this.ofConcernRankCombo.setText(MarkerSeverity.get(store.getString("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerOfConcern")).name());
        ProjectFilterSettings filterSettings = prefs.getFilterSettings();
        this.minRankSlider.setSelection(filterSettings.getMinRank());
        this.updateRankValueLabel();
        this.minPriorityCombo.setText(filterSettings.getMinPriority());
        for (Button checkBox : this.chkEnableBugCategoryList) {
            checkBox.setSelection(filterSettings.containsCategory((String)checkBox.getData()));
        }
        this.syncSelectedCategories();
    }

    protected List<Button> getChkEnableBugCategoryList() {
        return this.chkEnableBugCategoryList;
    }

    public void performOk() {
        IPreferenceStore store = this.propertyPage.getPreferenceStore();
        String scariest = this.scariestRankCombo.getText();
        store.setValue("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScariest", scariest);
        String scary = this.scaryRankCombo.getText();
        store.setValue("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScary", scary);
        String troubling = this.troublingRankCombo.getText();
        store.setValue("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerTroubling", troubling);
        String ofConcern = this.ofConcernRankCombo.getText();
        store.setValue("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerOfConcern", ofConcern);
    }
}

