/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.preferences;

import java.util.Set;
import java.util.TreeSet;

public final class FindBugsConstants {
    public static final String KEY_CACHE_CLASS_DATA = "cacheClassData";
    public static final String KEY_RUN_ANALYSIS_AS_EXTRA_JOB = "runAnalysisAsExtraJob";
    public static final String RANK_OFCONCERN_MARKER_SEVERITY = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerOfConcern";
    public static final String RANK_TROUBLING_MARKER_SEVERITY = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerTroubling";
    public static final String RANK_SCARY_MARKER_SEVERITY = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScary";
    public static final String RANK_SCARIEST_MARKER_SEVERITY = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScariest";
    public static final String LAST_USED_EXPORT_FILTER = "lastUsedExportFilter";
    public static final String EXPORT_SORT_ORDER = "exportSortOrder";
    public static final String ORDER_BY_NAME = "byName";
    public static final String ORDER_BY_OVERALL_BUGS_COUNT = "byOverallBugsCount";
    public static final String ORDER_BY_NOT_FILTERED_BUGS_COUNT = "byNotFilteredBugsCount";
    public static final String DONT_REMIND_ABOUT_FULL_BUILD = "dontRemindAboutFullBuild";
    public static final String LAST_USED_GROUPING = "lastUsedGrouping";
    public static final String LAST_USED_WORKING_SET = "lastUsedWorkingSet";
    public static final String ASK_ABOUT_PERSPECTIVE_SWITCH = "askAboutPerspectiveSwitch";
    public static final String SWITCH_PERSPECTIVE_AFTER_ANALYSIS = "switchPerspectiveAfterAnalysis";
    public static final String DISABLED_CATEGORIES = "disabledCategories";
    public static final String DISABLED_DETECTORS = "disabledDetectors";
    public static final String DISABLED_PATTERN_TYPES = "disabledPatternTypes";
    public static final String DISABLED_PATTERNS = "disabledPatterns";
    public static final String RUN_ANALYSIS_AUTOMATICALLY = "runAnalysisAutomatically";
    public static final String RUN_ANALYSIS_ON_FULL_BUILD = "runAnalysisOnFullBuild";
    public static final String PROJECT_PROPS_DISABLED = "disableProjectProps";
    public static final String ENABLE_CONSOLE_OUTPUT = "enableConsoleOutput";
    public static final String PROFILE_OUTPUT_MODE = "profileOutputMode";
    public static final String PROFILE_OUTPUT_BY_TIME = "profileOutputByTime";
    public static final String PROFILE_OUTPUT_BY_CALL = "profileOutputByCall";
    public static final String PROFILE_OUTPUT_BY_TIME_PER_CALL = "profileOutputByTimePerCall";
    public static final String IDS_PATTERN = "\\s*,\\s*";
    public static final String IDS_SEPARATOR = ", ";

    private FindBugsConstants() {
    }

    public static String encodeIds(Set<String> ids) {
        StringBuilder sb = new StringBuilder();
        for (String string : ids) {
            sb.append(string).append(IDS_SEPARATOR);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - IDS_SEPARATOR.length());
        }
        return sb.toString();
    }

    public static Set<String> decodeIds(String text) {
        String[] strings;
        TreeSet<String> sortedIds = new TreeSet<String>();
        if (text == null || text.trim().length() == 0) {
            return sortedIds;
        }
        for (String string : strings = text.split(IDS_PATTERN)) {
            if ((string = string.trim()).length() <= 0) continue;
            sortedIds.add(string);
        }
        return sortedIds;
    }
}

